/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.identity;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDateTime;

public class Connection {
    StringUtil util = new StringUtil();
    @JsonProperty(value="id")
    private UUID id;
    @JsonProperty(value="tenantId")
    private UUID tenantId;
    @JsonProperty(value="authEventId")
    private UUID authEventId;
    @JsonProperty(value="tenantType")
    private String tenantType;
    @JsonProperty(value="tenantName")
    private String tenantName;
    @JsonProperty(value="createdDateUtc")
    private LocalDateTime createdDateUtc;
    @JsonProperty(value="updatedDateUtc")
    private LocalDateTime updatedDateUtc;

    public Connection id(UUID id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="Xero identifier")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public Connection tenantId(UUID tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @ApiModelProperty(value="Xero identifier of organisation")
    public UUID getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(UUID tenantId) {
        this.tenantId = tenantId;
    }

    public Connection authEventId(UUID authEventId) {
        this.authEventId = authEventId;
        return this;
    }

    @ApiModelProperty(value="Identifier shared across connections authorised at the same time")
    public UUID getAuthEventId() {
        return this.authEventId;
    }

    public void setAuthEventId(UUID authEventId) {
        this.authEventId = authEventId;
    }

    public Connection tenantType(String tenantType) {
        this.tenantType = tenantType;
        return this;
    }

    @ApiModelProperty(value="Xero tenant type (i.e. ORGANISATION, PRACTICE)")
    public String getTenantType() {
        return this.tenantType;
    }

    public void setTenantType(String tenantType) {
        this.tenantType = tenantType;
    }

    public Connection tenantName(String tenantName) {
        this.tenantName = tenantName;
        return this;
    }

    @ApiModelProperty(value="Xero tenant name")
    public String getTenantName() {
        return this.tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public Connection createdDateUtc(LocalDateTime createdDateUtc) {
        this.createdDateUtc = createdDateUtc;
        return this;
    }

    @ApiModelProperty(value="The date when the user connected this tenant to your app")
    public LocalDateTime getCreatedDateUtc() {
        return this.createdDateUtc;
    }

    public void setCreatedDateUtc(LocalDateTime createdDateUtc) {
        this.createdDateUtc = createdDateUtc;
    }

    public Connection updatedDateUtc(LocalDateTime updatedDateUtc) {
        this.updatedDateUtc = updatedDateUtc;
        return this;
    }

    @ApiModelProperty(value="The date when the user most recently connected this tenant to your app. May differ to the created date if the user has disconnected and subsequently reconnected this tenant to your app.")
    public LocalDateTime getUpdatedDateUtc() {
        return this.updatedDateUtc;
    }

    public void setUpdatedDateUtc(LocalDateTime updatedDateUtc) {
        this.updatedDateUtc = updatedDateUtc;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Connection connection = (Connection)o;
        return Objects.equals(this.id, connection.id) && Objects.equals(this.tenantId, connection.tenantId) && Objects.equals(this.authEventId, connection.authEventId) && Objects.equals(this.tenantType, connection.tenantType) && Objects.equals(this.tenantName, connection.tenantName) && Objects.equals(this.createdDateUtc, connection.createdDateUtc) && Objects.equals(this.updatedDateUtc, connection.updatedDateUtc);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.tenantId, this.authEventId, this.tenantType, this.tenantName, this.createdDateUtc, this.updatedDateUtc);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Connection {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("    authEventId: ").append(this.toIndentedString(this.authEventId)).append("\n");
        sb.append("    tenantType: ").append(this.toIndentedString(this.tenantType)).append("\n");
        sb.append("    tenantName: ").append(this.toIndentedString(this.tenantName)).append("\n");
        sb.append("    createdDateUtc: ").append(this.toIndentedString(this.createdDateUtc)).append("\n");
        sb.append("    updatedDateUtc: ").append(this.toIndentedString(this.updatedDateUtc)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

