/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrollau;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum AccountType {
    BANK("BANK"),
    CURRENT("CURRENT"),
    CURRLIAB("CURRLIAB"),
    DEPRECIATN("DEPRECIATN"),
    DIRECTCOSTS("DIRECTCOSTS"),
    EQUITY("EQUITY"),
    EXPENSE("EXPENSE"),
    FIXED("FIXED"),
    INVENTORY("INVENTORY"),
    LIABILITY("LIABILITY"),
    NONCURRENT("NONCURRENT"),
    OTHERINCOME("OTHERINCOME"),
    OVERHEADS("OVERHEADS"),
    PREPAYMENT("PREPAYMENT"),
    REVENUE("REVENUE"),
    SALES("SALES"),
    TERMLIAB("TERMLIAB"),
    PAYGLIABILITY("PAYGLIABILITY"),
    PAYG("PAYG"),
    SUPERANNUATIONEXPENSE("SUPERANNUATIONEXPENSE"),
    SUPERANNUATIONLIABILITY("SUPERANNUATIONLIABILITY"),
    WAGESEXPENSE("WAGESEXPENSE"),
    WAGESPAYABLELIABILITY("WAGESPAYABLELIABILITY");

    private String value;

    private AccountType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static AccountType fromValue(String value) {
        for (AccountType b : AccountType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
}

