/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrollau;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import com.xero.models.payrollau.EarningsRateCalculationType;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;

public class EarningsLine {
    StringUtil util = new StringUtil();
    @JsonProperty(value="EarningsRateID")
    private UUID earningsRateID;
    @JsonProperty(value="CalculationType")
    private EarningsRateCalculationType calculationType;
    @JsonProperty(value="AnnualSalary")
    private Double annualSalary;
    @JsonProperty(value="NumberOfUnitsPerWeek")
    private Double numberOfUnitsPerWeek;
    @JsonProperty(value="RatePerUnit")
    private Double ratePerUnit;
    @JsonProperty(value="NormalNumberOfUnits")
    private Double normalNumberOfUnits;
    @JsonProperty(value="Amount")
    private Double amount;
    @JsonProperty(value="NumberOfUnits")
    private Double numberOfUnits;
    @JsonProperty(value="FixedAmount")
    private Double fixedAmount;

    public EarningsLine earningsRateID(UUID earningsRateID) {
        this.earningsRateID = earningsRateID;
        return this;
    }

    @ApiModelProperty(example="72e962d1-fcac-4083-8a71-742bb3e7ae14", required=true, value="Xero unique id for earnings rate")
    public UUID getEarningsRateID() {
        return this.earningsRateID;
    }

    public void setEarningsRateID(UUID earningsRateID) {
        this.earningsRateID = earningsRateID;
    }

    public EarningsLine calculationType(EarningsRateCalculationType calculationType) {
        this.calculationType = calculationType;
        return this;
    }

    @ApiModelProperty(value="")
    public EarningsRateCalculationType getCalculationType() {
        return this.calculationType;
    }

    public void setCalculationType(EarningsRateCalculationType calculationType) {
        this.calculationType = calculationType;
    }

    public EarningsLine annualSalary(Double annualSalary) {
        this.annualSalary = annualSalary;
        return this;
    }

    @ApiModelProperty(example="40000.0", value="Annual salary for earnings line")
    public Double getAnnualSalary() {
        return this.annualSalary;
    }

    public void setAnnualSalary(Double annualSalary) {
        this.annualSalary = annualSalary;
    }

    public EarningsLine numberOfUnitsPerWeek(Double numberOfUnitsPerWeek) {
        this.numberOfUnitsPerWeek = numberOfUnitsPerWeek;
        return this;
    }

    @ApiModelProperty(example="38.0", value="number of units for earning line")
    public Double getNumberOfUnitsPerWeek() {
        return this.numberOfUnitsPerWeek;
    }

    public void setNumberOfUnitsPerWeek(Double numberOfUnitsPerWeek) {
        this.numberOfUnitsPerWeek = numberOfUnitsPerWeek;
    }

    public EarningsLine ratePerUnit(Double ratePerUnit) {
        this.ratePerUnit = ratePerUnit;
        return this;
    }

    @ApiModelProperty(example="38.0", value="Rate per unit of the EarningsLine.")
    public Double getRatePerUnit() {
        return this.ratePerUnit;
    }

    public void setRatePerUnit(Double ratePerUnit) {
        this.ratePerUnit = ratePerUnit;
    }

    public EarningsLine normalNumberOfUnits(Double normalNumberOfUnits) {
        this.normalNumberOfUnits = normalNumberOfUnits;
        return this;
    }

    @ApiModelProperty(example="38.0", value="Normal number of units for EarningsLine. Applicable when RateType is \"MULTIPLE\"")
    public Double getNormalNumberOfUnits() {
        return this.normalNumberOfUnits;
    }

    public void setNormalNumberOfUnits(Double normalNumberOfUnits) {
        this.normalNumberOfUnits = normalNumberOfUnits;
    }

    public EarningsLine amount(Double amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(example="38.0", value="Earnings rate amount")
    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public EarningsLine numberOfUnits(Double numberOfUnits) {
        this.numberOfUnits = numberOfUnits;
        return this;
    }

    @ApiModelProperty(example="2.5", value="Earnings rate number of units.")
    public Double getNumberOfUnits() {
        return this.numberOfUnits;
    }

    public void setNumberOfUnits(Double numberOfUnits) {
        this.numberOfUnits = numberOfUnits;
    }

    public EarningsLine fixedAmount(Double fixedAmount) {
        this.fixedAmount = fixedAmount;
        return this;
    }

    @ApiModelProperty(example="2.5", value="Earnings rate amount. Only applicable if the EarningsRate RateType is Fixed")
    public Double getFixedAmount() {
        return this.fixedAmount;
    }

    public void setFixedAmount(Double fixedAmount) {
        this.fixedAmount = fixedAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EarningsLine earningsLine = (EarningsLine)o;
        return Objects.equals(this.earningsRateID, earningsLine.earningsRateID) && Objects.equals((Object)this.calculationType, (Object)earningsLine.calculationType) && Objects.equals(this.annualSalary, earningsLine.annualSalary) && Objects.equals(this.numberOfUnitsPerWeek, earningsLine.numberOfUnitsPerWeek) && Objects.equals(this.ratePerUnit, earningsLine.ratePerUnit) && Objects.equals(this.normalNumberOfUnits, earningsLine.normalNumberOfUnits) && Objects.equals(this.amount, earningsLine.amount) && Objects.equals(this.numberOfUnits, earningsLine.numberOfUnits) && Objects.equals(this.fixedAmount, earningsLine.fixedAmount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.earningsRateID, this.calculationType, this.annualSalary, this.numberOfUnitsPerWeek, this.ratePerUnit, this.normalNumberOfUnits, this.amount, this.numberOfUnits, this.fixedAmount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EarningsLine {\n");
        sb.append("    earningsRateID: ").append(this.toIndentedString(this.earningsRateID)).append("\n");
        sb.append("    calculationType: ").append(this.toIndentedString((Object)this.calculationType)).append("\n");
        sb.append("    annualSalary: ").append(this.toIndentedString(this.annualSalary)).append("\n");
        sb.append("    numberOfUnitsPerWeek: ").append(this.toIndentedString(this.numberOfUnitsPerWeek)).append("\n");
        sb.append("    ratePerUnit: ").append(this.toIndentedString(this.ratePerUnit)).append("\n");
        sb.append("    normalNumberOfUnits: ").append(this.toIndentedString(this.normalNumberOfUnits)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    numberOfUnits: ").append(this.toIndentedString(this.numberOfUnits)).append("\n");
        sb.append("    fixedAmount: ").append(this.toIndentedString(this.fixedAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

