/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrollau;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import com.xero.models.payrollau.AllowanceType;
import com.xero.models.payrollau.EarningsType;
import com.xero.models.payrollau.EmploymentTerminationPaymentType;
import com.xero.models.payrollau.RateType;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.OffsetDateTime;

public class EarningsRate {
    StringUtil util = new StringUtil();
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="AccountCode")
    private String accountCode;
    @JsonProperty(value="TypeOfUnits")
    private String typeOfUnits;
    @JsonProperty(value="IsExemptFromTax")
    private Boolean isExemptFromTax;
    @JsonProperty(value="IsExemptFromSuper")
    private Boolean isExemptFromSuper;
    @JsonProperty(value="IsReportableAsW1")
    private Boolean isReportableAsW1;
    @JsonProperty(value="EarningsType")
    private EarningsType earningsType;
    @JsonProperty(value="EarningsRateID")
    private UUID earningsRateID;
    @JsonProperty(value="RateType")
    private RateType rateType;
    @JsonProperty(value="RatePerUnit")
    private String ratePerUnit;
    @JsonProperty(value="Multiplier")
    private Double multiplier;
    @JsonProperty(value="AccrueLeave")
    private Boolean accrueLeave;
    @JsonProperty(value="Amount")
    private Double amount;
    @JsonProperty(value="EmploymentTerminationPaymentType")
    private EmploymentTerminationPaymentType employmentTerminationPaymentType;
    @JsonProperty(value="UpdatedDateUTC")
    private String updatedDateUTC;
    @JsonProperty(value="CurrentRecord")
    private Boolean currentRecord;
    @JsonProperty(value="AllowanceType")
    private AllowanceType allowanceType;

    public EarningsRate name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="PTO", value="Name of the earnings rate (max length = 100)")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EarningsRate accountCode(String accountCode) {
        this.accountCode = accountCode;
        return this;
    }

    @ApiModelProperty(example="720", value="See Accounts")
    public String getAccountCode() {
        return this.accountCode;
    }

    public void setAccountCode(String accountCode) {
        this.accountCode = accountCode;
    }

    public EarningsRate typeOfUnits(String typeOfUnits) {
        this.typeOfUnits = typeOfUnits;
        return this;
    }

    @ApiModelProperty(example="Fixed", value="Type of units used to record earnings (max length = 50). Only When RateType is RATEPERUNIT")
    public String getTypeOfUnits() {
        return this.typeOfUnits;
    }

    public void setTypeOfUnits(String typeOfUnits) {
        this.typeOfUnits = typeOfUnits;
    }

    public EarningsRate isExemptFromTax(Boolean isExemptFromTax) {
        this.isExemptFromTax = isExemptFromTax;
        return this;
    }

    @ApiModelProperty(example="false", value="Most payments are subject to tax, so you should only set this value if you are sure that a payment is exempt from PAYG withholding")
    public Boolean getIsExemptFromTax() {
        return this.isExemptFromTax;
    }

    public void setIsExemptFromTax(Boolean isExemptFromTax) {
        this.isExemptFromTax = isExemptFromTax;
    }

    public EarningsRate isExemptFromSuper(Boolean isExemptFromSuper) {
        this.isExemptFromSuper = isExemptFromSuper;
        return this;
    }

    @ApiModelProperty(example="false", value="See the ATO website for details of which payments are exempt from SGC")
    public Boolean getIsExemptFromSuper() {
        return this.isExemptFromSuper;
    }

    public void setIsExemptFromSuper(Boolean isExemptFromSuper) {
        this.isExemptFromSuper = isExemptFromSuper;
    }

    public EarningsRate isReportableAsW1(Boolean isReportableAsW1) {
        this.isReportableAsW1 = isReportableAsW1;
        return this;
    }

    @ApiModelProperty(example="false", value="Boolean to determine if the earnings rate is reportable or exempt from W1")
    public Boolean getIsReportableAsW1() {
        return this.isReportableAsW1;
    }

    public void setIsReportableAsW1(Boolean isReportableAsW1) {
        this.isReportableAsW1 = isReportableAsW1;
    }

    public EarningsRate earningsType(EarningsType earningsType) {
        this.earningsType = earningsType;
        return this;
    }

    @ApiModelProperty(value="")
    public EarningsType getEarningsType() {
        return this.earningsType;
    }

    public void setEarningsType(EarningsType earningsType) {
        this.earningsType = earningsType;
    }

    public EarningsRate earningsRateID(UUID earningsRateID) {
        this.earningsRateID = earningsRateID;
        return this;
    }

    @ApiModelProperty(example="e0eb6747-7c17-4075-b804-989f8d4e5d39", value="Xero identifier")
    public UUID getEarningsRateID() {
        return this.earningsRateID;
    }

    public void setEarningsRateID(UUID earningsRateID) {
        this.earningsRateID = earningsRateID;
    }

    public EarningsRate rateType(RateType rateType) {
        this.rateType = rateType;
        return this;
    }

    @ApiModelProperty(value="")
    public RateType getRateType() {
        return this.rateType;
    }

    public void setRateType(RateType rateType) {
        this.rateType = rateType;
    }

    public EarningsRate ratePerUnit(String ratePerUnit) {
        this.ratePerUnit = ratePerUnit;
        return this;
    }

    @ApiModelProperty(example="10", value="Default rate per unit (optional). Only applicable if RateType is RATEPERUNIT.")
    public String getRatePerUnit() {
        return this.ratePerUnit;
    }

    public void setRatePerUnit(String ratePerUnit) {
        this.ratePerUnit = ratePerUnit;
    }

    public EarningsRate multiplier(Double multiplier) {
        this.multiplier = multiplier;
        return this;
    }

    @ApiModelProperty(example="1.5", value="This is the multiplier used to calculate the rate per unit, based on the employee\u2019s ordinary earnings rate. For example, for time and a half enter 1.5. Only applicable if RateType is MULTIPLE")
    public Double getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(Double multiplier) {
        this.multiplier = multiplier;
    }

    public EarningsRate accrueLeave(Boolean accrueLeave) {
        this.accrueLeave = accrueLeave;
        return this;
    }

    @ApiModelProperty(example="false", value="Indicates that this earnings rate should accrue leave. Only applicable if RateType is MULTIPLE")
    public Boolean getAccrueLeave() {
        return this.accrueLeave;
    }

    public void setAccrueLeave(Boolean accrueLeave) {
        this.accrueLeave = accrueLeave;
    }

    public EarningsRate amount(Double amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(example="50.3", value="Optional Amount for FIXEDAMOUNT RateType EarningsRate")
    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public EarningsRate employmentTerminationPaymentType(EmploymentTerminationPaymentType employmentTerminationPaymentType) {
        this.employmentTerminationPaymentType = employmentTerminationPaymentType;
        return this;
    }

    @ApiModelProperty(value="")
    public EmploymentTerminationPaymentType getEmploymentTerminationPaymentType() {
        return this.employmentTerminationPaymentType;
    }

    public void setEmploymentTerminationPaymentType(EmploymentTerminationPaymentType employmentTerminationPaymentType) {
        this.employmentTerminationPaymentType = employmentTerminationPaymentType;
    }

    @ApiModelProperty(example="/Date(1583967733054+0000)/", value="Last modified timestamp")
    public String getUpdatedDateUTC() {
        return this.updatedDateUTC;
    }

    public OffsetDateTime getUpdatedDateUTCAsDate() {
        if (this.updatedDateUTC != null) {
            try {
                return this.util.convertStringToOffsetDateTime(this.updatedDateUTC);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public EarningsRate currentRecord(Boolean currentRecord) {
        this.currentRecord = currentRecord;
        return this;
    }

    @ApiModelProperty(example="true", value="Is the current record")
    public Boolean getCurrentRecord() {
        return this.currentRecord;
    }

    public void setCurrentRecord(Boolean currentRecord) {
        this.currentRecord = currentRecord;
    }

    public EarningsRate allowanceType(AllowanceType allowanceType) {
        this.allowanceType = allowanceType;
        return this;
    }

    @ApiModelProperty(value="")
    public AllowanceType getAllowanceType() {
        return this.allowanceType;
    }

    public void setAllowanceType(AllowanceType allowanceType) {
        this.allowanceType = allowanceType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EarningsRate earningsRate = (EarningsRate)o;
        return Objects.equals(this.name, earningsRate.name) && Objects.equals(this.accountCode, earningsRate.accountCode) && Objects.equals(this.typeOfUnits, earningsRate.typeOfUnits) && Objects.equals(this.isExemptFromTax, earningsRate.isExemptFromTax) && Objects.equals(this.isExemptFromSuper, earningsRate.isExemptFromSuper) && Objects.equals(this.isReportableAsW1, earningsRate.isReportableAsW1) && Objects.equals((Object)this.earningsType, (Object)earningsRate.earningsType) && Objects.equals(this.earningsRateID, earningsRate.earningsRateID) && Objects.equals((Object)this.rateType, (Object)earningsRate.rateType) && Objects.equals(this.ratePerUnit, earningsRate.ratePerUnit) && Objects.equals(this.multiplier, earningsRate.multiplier) && Objects.equals(this.accrueLeave, earningsRate.accrueLeave) && Objects.equals(this.amount, earningsRate.amount) && Objects.equals((Object)this.employmentTerminationPaymentType, (Object)earningsRate.employmentTerminationPaymentType) && Objects.equals(this.updatedDateUTC, earningsRate.updatedDateUTC) && Objects.equals(this.currentRecord, earningsRate.currentRecord) && Objects.equals((Object)this.allowanceType, (Object)earningsRate.allowanceType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.accountCode, this.typeOfUnits, this.isExemptFromTax, this.isExemptFromSuper, this.isReportableAsW1, this.earningsType, this.earningsRateID, this.rateType, this.ratePerUnit, this.multiplier, this.accrueLeave, this.amount, this.employmentTerminationPaymentType, this.updatedDateUTC, this.currentRecord, this.allowanceType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EarningsRate {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    accountCode: ").append(this.toIndentedString(this.accountCode)).append("\n");
        sb.append("    typeOfUnits: ").append(this.toIndentedString(this.typeOfUnits)).append("\n");
        sb.append("    isExemptFromTax: ").append(this.toIndentedString(this.isExemptFromTax)).append("\n");
        sb.append("    isExemptFromSuper: ").append(this.toIndentedString(this.isExemptFromSuper)).append("\n");
        sb.append("    isReportableAsW1: ").append(this.toIndentedString(this.isReportableAsW1)).append("\n");
        sb.append("    earningsType: ").append(this.toIndentedString((Object)this.earningsType)).append("\n");
        sb.append("    earningsRateID: ").append(this.toIndentedString(this.earningsRateID)).append("\n");
        sb.append("    rateType: ").append(this.toIndentedString((Object)this.rateType)).append("\n");
        sb.append("    ratePerUnit: ").append(this.toIndentedString(this.ratePerUnit)).append("\n");
        sb.append("    multiplier: ").append(this.toIndentedString(this.multiplier)).append("\n");
        sb.append("    accrueLeave: ").append(this.toIndentedString(this.accrueLeave)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    employmentTerminationPaymentType: ").append(this.toIndentedString((Object)this.employmentTerminationPaymentType)).append("\n");
        sb.append("    updatedDateUTC: ").append(this.toIndentedString(this.updatedDateUTC)).append("\n");
        sb.append("    currentRecord: ").append(this.toIndentedString(this.currentRecord)).append("\n");
        sb.append("    allowanceType: ").append(this.toIndentedString((Object)this.allowanceType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

