/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrollau;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import com.xero.models.payrollau.BankAccount;
import com.xero.models.payrollau.EmployeeStatus;
import com.xero.models.payrollau.HomeAddress;
import com.xero.models.payrollau.LeaveBalance;
import com.xero.models.payrollau.LeaveLine;
import com.xero.models.payrollau.OpeningBalances;
import com.xero.models.payrollau.PayTemplate;
import com.xero.models.payrollau.SuperMembership;
import com.xero.models.payrollau.TaxDeclaration;
import com.xero.models.payrollau.ValidationError;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.ZoneId;

public class Employee {
    StringUtil util = new StringUtil();
    @JsonProperty(value="FirstName")
    private String firstName;
    @JsonProperty(value="LastName")
    private String lastName;
    @JsonProperty(value="DateOfBirth")
    private String dateOfBirth;
    @JsonProperty(value="HomeAddress")
    private HomeAddress homeAddress;
    @JsonProperty(value="StartDate")
    private String startDate;
    @JsonProperty(value="Title")
    private String title;
    @JsonProperty(value="MiddleNames")
    private String middleNames;
    @JsonProperty(value="Email")
    private String email;
    @JsonProperty(value="Gender")
    private GenderEnum gender;
    @JsonProperty(value="Phone")
    private String phone;
    @JsonProperty(value="Mobile")
    private String mobile;
    @JsonProperty(value="TwitterUserName")
    private String twitterUserName;
    @JsonProperty(value="IsAuthorisedToApproveLeave")
    private Boolean isAuthorisedToApproveLeave;
    @JsonProperty(value="IsAuthorisedToApproveTimesheets")
    private Boolean isAuthorisedToApproveTimesheets;
    @JsonProperty(value="JobTitle")
    private String jobTitle;
    @JsonProperty(value="Classification")
    private String classification;
    @JsonProperty(value="OrdinaryEarningsRateID")
    private UUID ordinaryEarningsRateID;
    @JsonProperty(value="PayrollCalendarID")
    private UUID payrollCalendarID;
    @JsonProperty(value="EmployeeGroupName")
    private String employeeGroupName;
    @JsonProperty(value="EmployeeID")
    private UUID employeeID;
    @JsonProperty(value="TerminationDate")
    private String terminationDate;
    @JsonProperty(value="TerminationReason")
    private TerminationReasonEnum terminationReason;
    @JsonProperty(value="BankAccounts")
    private List<BankAccount> bankAccounts = new ArrayList<BankAccount>();
    @JsonProperty(value="PayTemplate")
    private PayTemplate payTemplate;
    @JsonProperty(value="OpeningBalances")
    private OpeningBalances openingBalances;
    @JsonProperty(value="TaxDeclaration")
    private TaxDeclaration taxDeclaration;
    @JsonProperty(value="LeaveBalances")
    private List<LeaveBalance> leaveBalances = new ArrayList<LeaveBalance>();
    @JsonProperty(value="LeaveLines")
    private List<LeaveLine> leaveLines = new ArrayList<LeaveLine>();
    @JsonProperty(value="SuperMemberships")
    private List<SuperMembership> superMemberships = new ArrayList<SuperMembership>();
    @JsonProperty(value="Status")
    private EmployeeStatus status;
    @JsonProperty(value="UpdatedDateUTC")
    private String updatedDateUTC;
    @JsonProperty(value="ValidationErrors")
    private List<ValidationError> validationErrors = new ArrayList<ValidationError>();

    public Employee firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @ApiModelProperty(example="Karen", required=true, value="First name of employee")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public Employee lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @ApiModelProperty(example="Jones", required=true, value="Last name of employee")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public Employee dateOfBirth(String dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
        return this;
    }

    @ApiModelProperty(example="/Date(322560000000+0000)/", required=true, value="Date of birth of the employee (YYYY-MM-DD)")
    public String getDateOfBirth() {
        return this.dateOfBirth;
    }

    public LocalDate getDateOfBirthAsDate() {
        if (this.dateOfBirth != null) {
            try {
                return this.util.convertStringToDate(this.dateOfBirth);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setDateOfBirth(String dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public void setDateOfBirth(LocalDate dateOfBirth) {
        Instant instant = dateOfBirth.atStartOfDay(ZoneId.of((String)"UTC").normalized()).toInstant();
        long timeInMillis = instant.toEpochMilli();
        this.dateOfBirth = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
    }

    public Employee homeAddress(HomeAddress homeAddress) {
        this.homeAddress = homeAddress;
        return this;
    }

    @ApiModelProperty(value="")
    public HomeAddress getHomeAddress() {
        return this.homeAddress;
    }

    public void setHomeAddress(HomeAddress homeAddress) {
        this.homeAddress = homeAddress;
    }

    public Employee startDate(String startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(example="/Date(320284900000+0000)/", value="Start date for an employee (YYYY-MM-DD)")
    public String getStartDate() {
        return this.startDate;
    }

    public LocalDate getStartDateAsDate() {
        if (this.startDate != null) {
            try {
                return this.util.convertStringToDate(this.startDate);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public void setStartDate(LocalDate startDate) {
        Instant instant = startDate.atStartOfDay(ZoneId.of((String)"UTC").normalized()).toInstant();
        long timeInMillis = instant.toEpochMilli();
        this.startDate = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
    }

    public Employee title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(example="Mrs", value="Title of the employee")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Employee middleNames(String middleNames) {
        this.middleNames = middleNames;
        return this;
    }

    @ApiModelProperty(example="Adena", value="Middle name(s) of the employee")
    public String getMiddleNames() {
        return this.middleNames;
    }

    public void setMiddleNames(String middleNames) {
        this.middleNames = middleNames;
    }

    public Employee email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(example="developer@me.com", value="The email address for the employee")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Employee gender(GenderEnum gender) {
        this.gender = gender;
        return this;
    }

    @ApiModelProperty(example="F", value="The employee\u2019s gender. See\u00a0Employee Gender")
    public GenderEnum getGender() {
        return this.gender;
    }

    public void setGender(GenderEnum gender) {
        this.gender = gender;
    }

    public Employee phone(String phone) {
        this.phone = phone;
        return this;
    }

    @ApiModelProperty(example="415-555-1212", value="Employee phone number")
    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public Employee mobile(String mobile) {
        this.mobile = mobile;
        return this;
    }

    @ApiModelProperty(example="415-234-5678", value="Employee mobile number")
    public String getMobile() {
        return this.mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public Employee twitterUserName(String twitterUserName) {
        this.twitterUserName = twitterUserName;
        return this;
    }

    @ApiModelProperty(example="xeroapi", value="Employee\u2019s twitter name")
    public String getTwitterUserName() {
        return this.twitterUserName;
    }

    public void setTwitterUserName(String twitterUserName) {
        this.twitterUserName = twitterUserName;
    }

    public Employee isAuthorisedToApproveLeave(Boolean isAuthorisedToApproveLeave) {
        this.isAuthorisedToApproveLeave = isAuthorisedToApproveLeave;
        return this;
    }

    @ApiModelProperty(example="false", value="Authorised to approve other employees' leave requests")
    public Boolean getIsAuthorisedToApproveLeave() {
        return this.isAuthorisedToApproveLeave;
    }

    public void setIsAuthorisedToApproveLeave(Boolean isAuthorisedToApproveLeave) {
        this.isAuthorisedToApproveLeave = isAuthorisedToApproveLeave;
    }

    public Employee isAuthorisedToApproveTimesheets(Boolean isAuthorisedToApproveTimesheets) {
        this.isAuthorisedToApproveTimesheets = isAuthorisedToApproveTimesheets;
        return this;
    }

    @ApiModelProperty(example="true", value="Authorised to approve timesheets")
    public Boolean getIsAuthorisedToApproveTimesheets() {
        return this.isAuthorisedToApproveTimesheets;
    }

    public void setIsAuthorisedToApproveTimesheets(Boolean isAuthorisedToApproveTimesheets) {
        this.isAuthorisedToApproveTimesheets = isAuthorisedToApproveTimesheets;
    }

    public Employee jobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
        return this;
    }

    @ApiModelProperty(example="Manager", value="JobTitle of the employee")
    public String getJobTitle() {
        return this.jobTitle;
    }

    public void setJobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
    }

    public Employee classification(String classification) {
        this.classification = classification;
        return this;
    }

    @ApiModelProperty(example="99383", value="Employees classification")
    public String getClassification() {
        return this.classification;
    }

    public void setClassification(String classification) {
        this.classification = classification;
    }

    public Employee ordinaryEarningsRateID(UUID ordinaryEarningsRateID) {
        this.ordinaryEarningsRateID = ordinaryEarningsRateID;
        return this;
    }

    @ApiModelProperty(value="Xero unique identifier for earnings rate")
    public UUID getOrdinaryEarningsRateID() {
        return this.ordinaryEarningsRateID;
    }

    public void setOrdinaryEarningsRateID(UUID ordinaryEarningsRateID) {
        this.ordinaryEarningsRateID = ordinaryEarningsRateID;
    }

    public Employee payrollCalendarID(UUID payrollCalendarID) {
        this.payrollCalendarID = payrollCalendarID;
        return this;
    }

    @ApiModelProperty(example="2ee8e5cc-9835-40d5-bb18-09fdb118db9c", value="Xero unique identifier for payroll calendar for the employee")
    public UUID getPayrollCalendarID() {
        return this.payrollCalendarID;
    }

    public void setPayrollCalendarID(UUID payrollCalendarID) {
        this.payrollCalendarID = payrollCalendarID;
    }

    public Employee employeeGroupName(String employeeGroupName) {
        this.employeeGroupName = employeeGroupName;
        return this;
    }

    @ApiModelProperty(example="marketing", value="The Employee Group allows you to report on payroll expenses and liabilities for each group of employees")
    public String getEmployeeGroupName() {
        return this.employeeGroupName;
    }

    public void setEmployeeGroupName(String employeeGroupName) {
        this.employeeGroupName = employeeGroupName;
    }

    public Employee employeeID(UUID employeeID) {
        this.employeeID = employeeID;
        return this;
    }

    @ApiModelProperty(example="4ff1e5cc-9835-40d5-bb18-09fdb118db9c", value="Xero unique identifier for an Employee")
    public UUID getEmployeeID() {
        return this.employeeID;
    }

    public void setEmployeeID(UUID employeeID) {
        this.employeeID = employeeID;
    }

    public Employee terminationDate(String terminationDate) {
        this.terminationDate = terminationDate;
        return this;
    }

    @ApiModelProperty(example="/Date(1584662400000+0000)/", value="Employee Termination Date (YYYY-MM-DD)")
    public String getTerminationDate() {
        return this.terminationDate;
    }

    public LocalDate getTerminationDateAsDate() {
        if (this.terminationDate != null) {
            try {
                return this.util.convertStringToDate(this.terminationDate);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setTerminationDate(String terminationDate) {
        this.terminationDate = terminationDate;
    }

    public void setTerminationDate(LocalDate terminationDate) {
        Instant instant = terminationDate.atStartOfDay(ZoneId.of((String)"UTC").normalized()).toInstant();
        long timeInMillis = instant.toEpochMilli();
        this.terminationDate = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
    }

    public Employee terminationReason(TerminationReasonEnum terminationReason) {
        this.terminationReason = terminationReason;
        return this;
    }

    @ApiModelProperty(example="F", value="* `V` Voluntary cessation - An employee resignation, retirement, domestic or pressing necessity or abandonment of employment * `I` Ill health - An employee resignation due to medical condition that prevents the continuation of employment, such as for illness, ill-health, medical unfitness or total permanent disability * `D` Deceased - The death of an employee * `R` Redundancy - An employer-initiated termination of employment due to a genuine redundancy or approved early retirement scheme * `F` Dismissal - An employer-initiated termination of employment due to dismissal, inability to perform the required work, misconduct or inefficiency * `C` Contract cessation - The natural conclusion of a limited employment relationship due to contract/engagement duration or task completion, seasonal work completion, or to cease casuals that are no longer required * `T` Transfer - The administrative arrangements performed to transfer employees across payroll systems, move them temporarily to another employer (machinery of government for public servants), transfer of business, move them to outsourcing arrangements or other such technical activities. ")
    public TerminationReasonEnum getTerminationReason() {
        return this.terminationReason;
    }

    public void setTerminationReason(TerminationReasonEnum terminationReason) {
        this.terminationReason = terminationReason;
    }

    public Employee bankAccounts(List<BankAccount> bankAccounts) {
        this.bankAccounts = bankAccounts;
        return this;
    }

    public Employee addBankAccountsItem(BankAccount bankAccountsItem) {
        if (this.bankAccounts == null) {
            this.bankAccounts = new ArrayList<BankAccount>();
        }
        this.bankAccounts.add(bankAccountsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<BankAccount> getBankAccounts() {
        return this.bankAccounts;
    }

    public void setBankAccounts(List<BankAccount> bankAccounts) {
        this.bankAccounts = bankAccounts;
    }

    public Employee payTemplate(PayTemplate payTemplate) {
        this.payTemplate = payTemplate;
        return this;
    }

    @ApiModelProperty(value="")
    public PayTemplate getPayTemplate() {
        return this.payTemplate;
    }

    public void setPayTemplate(PayTemplate payTemplate) {
        this.payTemplate = payTemplate;
    }

    public Employee openingBalances(OpeningBalances openingBalances) {
        this.openingBalances = openingBalances;
        return this;
    }

    @ApiModelProperty(value="")
    public OpeningBalances getOpeningBalances() {
        return this.openingBalances;
    }

    public void setOpeningBalances(OpeningBalances openingBalances) {
        this.openingBalances = openingBalances;
    }

    public Employee taxDeclaration(TaxDeclaration taxDeclaration) {
        this.taxDeclaration = taxDeclaration;
        return this;
    }

    @ApiModelProperty(value="")
    public TaxDeclaration getTaxDeclaration() {
        return this.taxDeclaration;
    }

    public void setTaxDeclaration(TaxDeclaration taxDeclaration) {
        this.taxDeclaration = taxDeclaration;
    }

    public Employee leaveBalances(List<LeaveBalance> leaveBalances) {
        this.leaveBalances = leaveBalances;
        return this;
    }

    public Employee addLeaveBalancesItem(LeaveBalance leaveBalancesItem) {
        if (this.leaveBalances == null) {
            this.leaveBalances = new ArrayList<LeaveBalance>();
        }
        this.leaveBalances.add(leaveBalancesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<LeaveBalance> getLeaveBalances() {
        return this.leaveBalances;
    }

    public void setLeaveBalances(List<LeaveBalance> leaveBalances) {
        this.leaveBalances = leaveBalances;
    }

    public Employee leaveLines(List<LeaveLine> leaveLines) {
        this.leaveLines = leaveLines;
        return this;
    }

    public Employee addLeaveLinesItem(LeaveLine leaveLinesItem) {
        if (this.leaveLines == null) {
            this.leaveLines = new ArrayList<LeaveLine>();
        }
        this.leaveLines.add(leaveLinesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<LeaveLine> getLeaveLines() {
        return this.leaveLines;
    }

    public void setLeaveLines(List<LeaveLine> leaveLines) {
        this.leaveLines = leaveLines;
    }

    public Employee superMemberships(List<SuperMembership> superMemberships) {
        this.superMemberships = superMemberships;
        return this;
    }

    public Employee addSuperMembershipsItem(SuperMembership superMembershipsItem) {
        if (this.superMemberships == null) {
            this.superMemberships = new ArrayList<SuperMembership>();
        }
        this.superMemberships.add(superMembershipsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<SuperMembership> getSuperMemberships() {
        return this.superMemberships;
    }

    public void setSuperMemberships(List<SuperMembership> superMemberships) {
        this.superMemberships = superMemberships;
    }

    public Employee status(EmployeeStatus status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="")
    public EmployeeStatus getStatus() {
        return this.status;
    }

    public void setStatus(EmployeeStatus status) {
        this.status = status;
    }

    @ApiModelProperty(example="/Date(1583967733054+0000)/", value="Last modified timestamp")
    public String getUpdatedDateUTC() {
        return this.updatedDateUTC;
    }

    public OffsetDateTime getUpdatedDateUTCAsDate() {
        if (this.updatedDateUTC != null) {
            try {
                return this.util.convertStringToOffsetDateTime(this.updatedDateUTC);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Employee validationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
        return this;
    }

    public Employee addValidationErrorsItem(ValidationError validationErrorsItem) {
        if (this.validationErrors == null) {
            this.validationErrors = new ArrayList<ValidationError>();
        }
        this.validationErrors.add(validationErrorsItem);
        return this;
    }

    @ApiModelProperty(value="Displays array of validation error messages from the API")
    public List<ValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    public void setValidationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Employee employee = (Employee)o;
        return Objects.equals(this.firstName, employee.firstName) && Objects.equals(this.lastName, employee.lastName) && Objects.equals(this.dateOfBirth, employee.dateOfBirth) && Objects.equals(this.homeAddress, employee.homeAddress) && Objects.equals(this.startDate, employee.startDate) && Objects.equals(this.title, employee.title) && Objects.equals(this.middleNames, employee.middleNames) && Objects.equals(this.email, employee.email) && Objects.equals((Object)this.gender, (Object)employee.gender) && Objects.equals(this.phone, employee.phone) && Objects.equals(this.mobile, employee.mobile) && Objects.equals(this.twitterUserName, employee.twitterUserName) && Objects.equals(this.isAuthorisedToApproveLeave, employee.isAuthorisedToApproveLeave) && Objects.equals(this.isAuthorisedToApproveTimesheets, employee.isAuthorisedToApproveTimesheets) && Objects.equals(this.jobTitle, employee.jobTitle) && Objects.equals(this.classification, employee.classification) && Objects.equals(this.ordinaryEarningsRateID, employee.ordinaryEarningsRateID) && Objects.equals(this.payrollCalendarID, employee.payrollCalendarID) && Objects.equals(this.employeeGroupName, employee.employeeGroupName) && Objects.equals(this.employeeID, employee.employeeID) && Objects.equals(this.terminationDate, employee.terminationDate) && Objects.equals((Object)this.terminationReason, (Object)employee.terminationReason) && Objects.equals(this.bankAccounts, employee.bankAccounts) && Objects.equals(this.payTemplate, employee.payTemplate) && Objects.equals(this.openingBalances, employee.openingBalances) && Objects.equals(this.taxDeclaration, employee.taxDeclaration) && Objects.equals(this.leaveBalances, employee.leaveBalances) && Objects.equals(this.leaveLines, employee.leaveLines) && Objects.equals(this.superMemberships, employee.superMemberships) && Objects.equals((Object)this.status, (Object)employee.status) && Objects.equals(this.updatedDateUTC, employee.updatedDateUTC) && Objects.equals(this.validationErrors, employee.validationErrors);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.firstName, this.lastName, this.dateOfBirth, this.homeAddress, this.startDate, this.title, this.middleNames, this.email, this.gender, this.phone, this.mobile, this.twitterUserName, this.isAuthorisedToApproveLeave, this.isAuthorisedToApproveTimesheets, this.jobTitle, this.classification, this.ordinaryEarningsRateID, this.payrollCalendarID, this.employeeGroupName, this.employeeID, this.terminationDate, this.terminationReason, this.bankAccounts, this.payTemplate, this.openingBalances, this.taxDeclaration, this.leaveBalances, this.leaveLines, this.superMemberships, this.status, this.updatedDateUTC, this.validationErrors});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Employee {\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    dateOfBirth: ").append(this.toIndentedString(this.dateOfBirth)).append("\n");
        sb.append("    homeAddress: ").append(this.toIndentedString(this.homeAddress)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    middleNames: ").append(this.toIndentedString(this.middleNames)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    gender: ").append(this.toIndentedString((Object)this.gender)).append("\n");
        sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        sb.append("    mobile: ").append(this.toIndentedString(this.mobile)).append("\n");
        sb.append("    twitterUserName: ").append(this.toIndentedString(this.twitterUserName)).append("\n");
        sb.append("    isAuthorisedToApproveLeave: ").append(this.toIndentedString(this.isAuthorisedToApproveLeave)).append("\n");
        sb.append("    isAuthorisedToApproveTimesheets: ").append(this.toIndentedString(this.isAuthorisedToApproveTimesheets)).append("\n");
        sb.append("    jobTitle: ").append(this.toIndentedString(this.jobTitle)).append("\n");
        sb.append("    classification: ").append(this.toIndentedString(this.classification)).append("\n");
        sb.append("    ordinaryEarningsRateID: ").append(this.toIndentedString(this.ordinaryEarningsRateID)).append("\n");
        sb.append("    payrollCalendarID: ").append(this.toIndentedString(this.payrollCalendarID)).append("\n");
        sb.append("    employeeGroupName: ").append(this.toIndentedString(this.employeeGroupName)).append("\n");
        sb.append("    employeeID: ").append(this.toIndentedString(this.employeeID)).append("\n");
        sb.append("    terminationDate: ").append(this.toIndentedString(this.terminationDate)).append("\n");
        sb.append("    terminationReason: ").append(this.toIndentedString((Object)this.terminationReason)).append("\n");
        sb.append("    bankAccounts: ").append(this.toIndentedString(this.bankAccounts)).append("\n");
        sb.append("    payTemplate: ").append(this.toIndentedString(this.payTemplate)).append("\n");
        sb.append("    openingBalances: ").append(this.toIndentedString(this.openingBalances)).append("\n");
        sb.append("    taxDeclaration: ").append(this.toIndentedString(this.taxDeclaration)).append("\n");
        sb.append("    leaveBalances: ").append(this.toIndentedString(this.leaveBalances)).append("\n");
        sb.append("    leaveLines: ").append(this.toIndentedString(this.leaveLines)).append("\n");
        sb.append("    superMemberships: ").append(this.toIndentedString(this.superMemberships)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    updatedDateUTC: ").append(this.toIndentedString(this.updatedDateUTC)).append("\n");
        sb.append("    validationErrors: ").append(this.toIndentedString(this.validationErrors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TerminationReasonEnum {
        V("V"),
        I("I"),
        D("D"),
        R("R"),
        F("F"),
        C("C"),
        T("T");

        private String value;

        private TerminationReasonEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TerminationReasonEnum fromValue(String value) {
            for (TerminationReasonEnum b : TerminationReasonEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum GenderEnum {
        N("N"),
        M("M"),
        F("F"),
        I("I");

        private String value;

        private GenderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static GenderEnum fromValue(String value) {
            for (GenderEnum b : GenderEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

