/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrollau;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import com.xero.models.payrollau.LeavePeriod;
import com.xero.models.payrollau.ValidationError;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.ZoneId;

public class LeaveApplication {
    StringUtil util = new StringUtil();
    @JsonProperty(value="LeaveApplicationID")
    private UUID leaveApplicationID;
    @JsonProperty(value="EmployeeID")
    private UUID employeeID;
    @JsonProperty(value="LeaveTypeID")
    private UUID leaveTypeID;
    @JsonProperty(value="Title")
    private String title;
    @JsonProperty(value="StartDate")
    private String startDate;
    @JsonProperty(value="EndDate")
    private String endDate;
    @JsonProperty(value="Description")
    private String description;
    @JsonProperty(value="LeavePeriods")
    private List<LeavePeriod> leavePeriods = new ArrayList<LeavePeriod>();
    @JsonProperty(value="UpdatedDateUTC")
    private String updatedDateUTC;
    @JsonProperty(value="ValidationErrors")
    private List<ValidationError> validationErrors = new ArrayList<ValidationError>();

    public LeaveApplication leaveApplicationID(UUID leaveApplicationID) {
        this.leaveApplicationID = leaveApplicationID;
        return this;
    }

    @ApiModelProperty(example="e0eb6747-7c17-4075-b804-989f8d4e5d39", value="The Xero identifier for Payroll Employee")
    public UUID getLeaveApplicationID() {
        return this.leaveApplicationID;
    }

    public void setLeaveApplicationID(UUID leaveApplicationID) {
        this.leaveApplicationID = leaveApplicationID;
    }

    public LeaveApplication employeeID(UUID employeeID) {
        this.employeeID = employeeID;
        return this;
    }

    @ApiModelProperty(example="fb4ebd68-6568-41eb-96ab-628a0f54b4b8", value="The Xero identifier for Payroll Employee")
    public UUID getEmployeeID() {
        return this.employeeID;
    }

    public void setEmployeeID(UUID employeeID) {
        this.employeeID = employeeID;
    }

    public LeaveApplication leaveTypeID(UUID leaveTypeID) {
        this.leaveTypeID = leaveTypeID;
        return this;
    }

    @ApiModelProperty(example="742998cb-7584-4ecf-aa88-d694f59c50f9", value="The Xero identifier for Leave Type")
    public UUID getLeaveTypeID() {
        return this.leaveTypeID;
    }

    public void setLeaveTypeID(UUID leaveTypeID) {
        this.leaveTypeID = leaveTypeID;
    }

    public LeaveApplication title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(example="Annual Leave", value="The title of the leave")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public LeaveApplication startDate(String startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(example="/Date(322560000000+0000)/", value="Start date of the leave (YYYY-MM-DD)")
    public String getStartDate() {
        return this.startDate;
    }

    public LocalDate getStartDateAsDate() {
        if (this.startDate != null) {
            try {
                return this.util.convertStringToDate(this.startDate);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public void setStartDate(LocalDate startDate) {
        Instant instant = startDate.atStartOfDay(ZoneId.of((String)"UTC").normalized()).toInstant();
        long timeInMillis = instant.toEpochMilli();
        this.startDate = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
    }

    public LeaveApplication endDate(String endDate) {
        this.endDate = endDate;
        return this;
    }

    @ApiModelProperty(example="/Date(322560000000+0000)/", value="End date of the leave (YYYY-MM-DD)")
    public String getEndDate() {
        return this.endDate;
    }

    public LocalDate getEndDateAsDate() {
        if (this.endDate != null) {
            try {
                return this.util.convertStringToDate(this.endDate);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public void setEndDate(LocalDate endDate) {
        Instant instant = endDate.atStartOfDay(ZoneId.of((String)"UTC").normalized()).toInstant();
        long timeInMillis = instant.toEpochMilli();
        this.endDate = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
    }

    public LeaveApplication description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="My leave", value="The Description of the Leave")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public LeaveApplication leavePeriods(List<LeavePeriod> leavePeriods) {
        this.leavePeriods = leavePeriods;
        return this;
    }

    public LeaveApplication addLeavePeriodsItem(LeavePeriod leavePeriodsItem) {
        if (this.leavePeriods == null) {
            this.leavePeriods = new ArrayList<LeavePeriod>();
        }
        this.leavePeriods.add(leavePeriodsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<LeavePeriod> getLeavePeriods() {
        return this.leavePeriods;
    }

    public void setLeavePeriods(List<LeavePeriod> leavePeriods) {
        this.leavePeriods = leavePeriods;
    }

    @ApiModelProperty(example="/Date(1583967733054+0000)/", value="Last modified timestamp")
    public String getUpdatedDateUTC() {
        return this.updatedDateUTC;
    }

    public OffsetDateTime getUpdatedDateUTCAsDate() {
        if (this.updatedDateUTC != null) {
            try {
                return this.util.convertStringToOffsetDateTime(this.updatedDateUTC);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public LeaveApplication validationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
        return this;
    }

    public LeaveApplication addValidationErrorsItem(ValidationError validationErrorsItem) {
        if (this.validationErrors == null) {
            this.validationErrors = new ArrayList<ValidationError>();
        }
        this.validationErrors.add(validationErrorsItem);
        return this;
    }

    @ApiModelProperty(value="Displays array of validation error messages from the API")
    public List<ValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    public void setValidationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LeaveApplication leaveApplication = (LeaveApplication)o;
        return Objects.equals(this.leaveApplicationID, leaveApplication.leaveApplicationID) && Objects.equals(this.employeeID, leaveApplication.employeeID) && Objects.equals(this.leaveTypeID, leaveApplication.leaveTypeID) && Objects.equals(this.title, leaveApplication.title) && Objects.equals(this.startDate, leaveApplication.startDate) && Objects.equals(this.endDate, leaveApplication.endDate) && Objects.equals(this.description, leaveApplication.description) && Objects.equals(this.leavePeriods, leaveApplication.leavePeriods) && Objects.equals(this.updatedDateUTC, leaveApplication.updatedDateUTC) && Objects.equals(this.validationErrors, leaveApplication.validationErrors);
    }

    public int hashCode() {
        return Objects.hash(this.leaveApplicationID, this.employeeID, this.leaveTypeID, this.title, this.startDate, this.endDate, this.description, this.leavePeriods, this.updatedDateUTC, this.validationErrors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LeaveApplication {\n");
        sb.append("    leaveApplicationID: ").append(this.toIndentedString(this.leaveApplicationID)).append("\n");
        sb.append("    employeeID: ").append(this.toIndentedString(this.employeeID)).append("\n");
        sb.append("    leaveTypeID: ").append(this.toIndentedString(this.leaveTypeID)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    leavePeriods: ").append(this.toIndentedString(this.leavePeriods)).append("\n");
        sb.append("    updatedDateUTC: ").append(this.toIndentedString(this.updatedDateUTC)).append("\n");
        sb.append("    validationErrors: ").append(this.toIndentedString(this.validationErrors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

