/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrollau;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.OffsetDateTime;

public class LeaveType {
    StringUtil util = new StringUtil();
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="TypeOfUnits")
    private String typeOfUnits;
    @JsonProperty(value="LeaveTypeID")
    private UUID leaveTypeID;
    @JsonProperty(value="NormalEntitlement")
    private Double normalEntitlement;
    @JsonProperty(value="LeaveLoadingRate")
    private Double leaveLoadingRate;
    @JsonProperty(value="UpdatedDateUTC")
    private String updatedDateUTC;
    @JsonProperty(value="IsPaidLeave")
    private Boolean isPaidLeave;
    @JsonProperty(value="ShowOnPayslip")
    private Boolean showOnPayslip;
    @JsonProperty(value="CurrentRecord")
    private Boolean currentRecord;

    public LeaveType name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="PTO", value="Name of the earnings rate (max length = 100)")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LeaveType typeOfUnits(String typeOfUnits) {
        this.typeOfUnits = typeOfUnits;
        return this;
    }

    @ApiModelProperty(example="Hours", value="The type of units by which leave entitlements are normally tracked. These are typically the same as the type of units used for the employee\u2019s ordinary earnings rate")
    public String getTypeOfUnits() {
        return this.typeOfUnits;
    }

    public void setTypeOfUnits(String typeOfUnits) {
        this.typeOfUnits = typeOfUnits;
    }

    public LeaveType leaveTypeID(UUID leaveTypeID) {
        this.leaveTypeID = leaveTypeID;
        return this;
    }

    @ApiModelProperty(example="e0eb6747-7c17-4075-b804-989f8d4e5d39", value="Xero identifier")
    public UUID getLeaveTypeID() {
        return this.leaveTypeID;
    }

    public void setLeaveTypeID(UUID leaveTypeID) {
        this.leaveTypeID = leaveTypeID;
    }

    public LeaveType normalEntitlement(Double normalEntitlement) {
        this.normalEntitlement = normalEntitlement;
        return this;
    }

    @ApiModelProperty(example="152.0", value="The number of units the employee is entitled to each year")
    public Double getNormalEntitlement() {
        return this.normalEntitlement;
    }

    public void setNormalEntitlement(Double normalEntitlement) {
        this.normalEntitlement = normalEntitlement;
    }

    public LeaveType leaveLoadingRate(Double leaveLoadingRate) {
        this.leaveLoadingRate = leaveLoadingRate;
        return this;
    }

    @ApiModelProperty(example="2.0", value="Enter an amount here if your organisation pays an additional percentage on top of ordinary earnings when your employees take leave (typically 17.5%)")
    public Double getLeaveLoadingRate() {
        return this.leaveLoadingRate;
    }

    public void setLeaveLoadingRate(Double leaveLoadingRate) {
        this.leaveLoadingRate = leaveLoadingRate;
    }

    @ApiModelProperty(example="/Date(1583967733054+0000)/", value="Last modified timestamp")
    public String getUpdatedDateUTC() {
        return this.updatedDateUTC;
    }

    public OffsetDateTime getUpdatedDateUTCAsDate() {
        if (this.updatedDateUTC != null) {
            try {
                return this.util.convertStringToOffsetDateTime(this.updatedDateUTC);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public LeaveType isPaidLeave(Boolean isPaidLeave) {
        this.isPaidLeave = isPaidLeave;
        return this;
    }

    @ApiModelProperty(example="true", value="Set this to indicate that an employee will be paid when taking this type of leave")
    public Boolean getIsPaidLeave() {
        return this.isPaidLeave;
    }

    public void setIsPaidLeave(Boolean isPaidLeave) {
        this.isPaidLeave = isPaidLeave;
    }

    public LeaveType showOnPayslip(Boolean showOnPayslip) {
        this.showOnPayslip = showOnPayslip;
        return this;
    }

    @ApiModelProperty(example="true", value="Set this if you want a balance for this leave type to be shown on your employee\u2019s payslips")
    public Boolean getShowOnPayslip() {
        return this.showOnPayslip;
    }

    public void setShowOnPayslip(Boolean showOnPayslip) {
        this.showOnPayslip = showOnPayslip;
    }

    public LeaveType currentRecord(Boolean currentRecord) {
        this.currentRecord = currentRecord;
        return this;
    }

    @ApiModelProperty(example="true", value="Is the current record")
    public Boolean getCurrentRecord() {
        return this.currentRecord;
    }

    public void setCurrentRecord(Boolean currentRecord) {
        this.currentRecord = currentRecord;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LeaveType leaveType = (LeaveType)o;
        return Objects.equals(this.name, leaveType.name) && Objects.equals(this.typeOfUnits, leaveType.typeOfUnits) && Objects.equals(this.leaveTypeID, leaveType.leaveTypeID) && Objects.equals(this.normalEntitlement, leaveType.normalEntitlement) && Objects.equals(this.leaveLoadingRate, leaveType.leaveLoadingRate) && Objects.equals(this.updatedDateUTC, leaveType.updatedDateUTC) && Objects.equals(this.isPaidLeave, leaveType.isPaidLeave) && Objects.equals(this.showOnPayslip, leaveType.showOnPayslip) && Objects.equals(this.currentRecord, leaveType.currentRecord);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.typeOfUnits, this.leaveTypeID, this.normalEntitlement, this.leaveLoadingRate, this.updatedDateUTC, this.isPaidLeave, this.showOnPayslip, this.currentRecord);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LeaveType {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    typeOfUnits: ").append(this.toIndentedString(this.typeOfUnits)).append("\n");
        sb.append("    leaveTypeID: ").append(this.toIndentedString(this.leaveTypeID)).append("\n");
        sb.append("    normalEntitlement: ").append(this.toIndentedString(this.normalEntitlement)).append("\n");
        sb.append("    leaveLoadingRate: ").append(this.toIndentedString(this.leaveLoadingRate)).append("\n");
        sb.append("    updatedDateUTC: ").append(this.toIndentedString(this.updatedDateUTC)).append("\n");
        sb.append("    isPaidLeave: ").append(this.toIndentedString(this.isPaidLeave)).append("\n");
        sb.append("    showOnPayslip: ").append(this.toIndentedString(this.showOnPayslip)).append("\n");
        sb.append("    currentRecord: ").append(this.toIndentedString(this.currentRecord)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

