/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrollau;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import com.xero.models.payrollau.CalendarType;
import com.xero.models.payrollau.ValidationError;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.ZoneId;

public class PayrollCalendar {
    StringUtil util = new StringUtil();
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="CalendarType")
    private CalendarType calendarType;
    @JsonProperty(value="StartDate")
    private String startDate;
    @JsonProperty(value="PaymentDate")
    private String paymentDate;
    @JsonProperty(value="PayrollCalendarID")
    private UUID payrollCalendarID;
    @JsonProperty(value="UpdatedDateUTC")
    private String updatedDateUTC;
    @JsonProperty(value="ReferenceDate")
    private String referenceDate;
    @JsonProperty(value="ValidationErrors")
    private List<ValidationError> validationErrors = new ArrayList<ValidationError>();

    public PayrollCalendar name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="Fortnightly Calendar", value="Name of the Payroll Calendar")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PayrollCalendar calendarType(CalendarType calendarType) {
        this.calendarType = calendarType;
        return this;
    }

    @ApiModelProperty(value="")
    public CalendarType getCalendarType() {
        return this.calendarType;
    }

    public void setCalendarType(CalendarType calendarType) {
        this.calendarType = calendarType;
    }

    public PayrollCalendar startDate(String startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(example="/Date(322560000000+0000)/", value="The start date of the upcoming pay period. The end date will be calculated based upon this date, and the calendar type selected (YYYY-MM-DD)")
    public String getStartDate() {
        return this.startDate;
    }

    public LocalDate getStartDateAsDate() {
        if (this.startDate != null) {
            try {
                return this.util.convertStringToDate(this.startDate);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public void setStartDate(LocalDate startDate) {
        Instant instant = startDate.atStartOfDay(ZoneId.of((String)"UTC").normalized()).toInstant();
        long timeInMillis = instant.toEpochMilli();
        this.startDate = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
    }

    public PayrollCalendar paymentDate(String paymentDate) {
        this.paymentDate = paymentDate;
        return this;
    }

    @ApiModelProperty(example="/Date(322560000000+0000)/", value="The date on which employees will be paid for the upcoming pay period (YYYY-MM-DD)")
    public String getPaymentDate() {
        return this.paymentDate;
    }

    public LocalDate getPaymentDateAsDate() {
        if (this.paymentDate != null) {
            try {
                return this.util.convertStringToDate(this.paymentDate);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setPaymentDate(String paymentDate) {
        this.paymentDate = paymentDate;
    }

    public void setPaymentDate(LocalDate paymentDate) {
        Instant instant = paymentDate.atStartOfDay(ZoneId.of((String)"UTC").normalized()).toInstant();
        long timeInMillis = instant.toEpochMilli();
        this.paymentDate = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
    }

    public PayrollCalendar payrollCalendarID(UUID payrollCalendarID) {
        this.payrollCalendarID = payrollCalendarID;
        return this;
    }

    @ApiModelProperty(example="e0eb6747-7c17-4075-b804-989f8d4e5d39", value="Xero identifier")
    public UUID getPayrollCalendarID() {
        return this.payrollCalendarID;
    }

    public void setPayrollCalendarID(UUID payrollCalendarID) {
        this.payrollCalendarID = payrollCalendarID;
    }

    @ApiModelProperty(example="/Date(1583967733054+0000)/", value="Last modified timestamp")
    public String getUpdatedDateUTC() {
        return this.updatedDateUTC;
    }

    public OffsetDateTime getUpdatedDateUTCAsDate() {
        if (this.updatedDateUTC != null) {
            try {
                return this.util.convertStringToOffsetDateTime(this.updatedDateUTC);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public PayrollCalendar referenceDate(String referenceDate) {
        this.referenceDate = referenceDate;
        return this;
    }

    @ApiModelProperty(example="/Date(322560000000+0000)/", value="Reference Date (YYYY-MM-DD)")
    public String getReferenceDate() {
        return this.referenceDate;
    }

    public LocalDate getReferenceDateAsDate() {
        if (this.referenceDate != null) {
            try {
                return this.util.convertStringToDate(this.referenceDate);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setReferenceDate(String referenceDate) {
        this.referenceDate = referenceDate;
    }

    public void setReferenceDate(LocalDate referenceDate) {
        Instant instant = referenceDate.atStartOfDay(ZoneId.of((String)"UTC").normalized()).toInstant();
        long timeInMillis = instant.toEpochMilli();
        this.referenceDate = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
    }

    public PayrollCalendar validationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
        return this;
    }

    public PayrollCalendar addValidationErrorsItem(ValidationError validationErrorsItem) {
        if (this.validationErrors == null) {
            this.validationErrors = new ArrayList<ValidationError>();
        }
        this.validationErrors.add(validationErrorsItem);
        return this;
    }

    @ApiModelProperty(value="Displays array of validation error messages from the API")
    public List<ValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    public void setValidationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayrollCalendar payrollCalendar = (PayrollCalendar)o;
        return Objects.equals(this.name, payrollCalendar.name) && Objects.equals((Object)this.calendarType, (Object)payrollCalendar.calendarType) && Objects.equals(this.startDate, payrollCalendar.startDate) && Objects.equals(this.paymentDate, payrollCalendar.paymentDate) && Objects.equals(this.payrollCalendarID, payrollCalendar.payrollCalendarID) && Objects.equals(this.updatedDateUTC, payrollCalendar.updatedDateUTC) && Objects.equals(this.referenceDate, payrollCalendar.referenceDate) && Objects.equals(this.validationErrors, payrollCalendar.validationErrors);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.calendarType, this.startDate, this.paymentDate, this.payrollCalendarID, this.updatedDateUTC, this.referenceDate, this.validationErrors});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayrollCalendar {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    calendarType: ").append(this.toIndentedString((Object)this.calendarType)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    paymentDate: ").append(this.toIndentedString(this.paymentDate)).append("\n");
        sb.append("    payrollCalendarID: ").append(this.toIndentedString(this.payrollCalendarID)).append("\n");
        sb.append("    updatedDateUTC: ").append(this.toIndentedString(this.updatedDateUTC)).append("\n");
        sb.append("    referenceDate: ").append(this.toIndentedString(this.referenceDate)).append("\n");
        sb.append("    validationErrors: ").append(this.toIndentedString(this.validationErrors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

