/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrollau;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;

public class ReimbursementLine {
    StringUtil util = new StringUtil();
    @JsonProperty(value="ReimbursementTypeID")
    private UUID reimbursementTypeID;
    @JsonProperty(value="Amount")
    private Double amount;
    @JsonProperty(value="Description")
    private String description;
    @JsonProperty(value="ExpenseAccount")
    private String expenseAccount;

    public ReimbursementLine reimbursementTypeID(UUID reimbursementTypeID) {
        this.reimbursementTypeID = reimbursementTypeID;
        return this;
    }

    @ApiModelProperty(example="bd246b96-c637-4767-81cf-851ba8fa93c2", value="Xero reimbursement type identifier")
    public UUID getReimbursementTypeID() {
        return this.reimbursementTypeID;
    }

    public void setReimbursementTypeID(UUID reimbursementTypeID) {
        this.reimbursementTypeID = reimbursementTypeID;
    }

    public ReimbursementLine amount(Double amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(example="10.0", value="Reimbursement type amount")
    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public ReimbursementLine description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="For the taxi", value="Reimbursement lines description (max length 50)")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ReimbursementLine expenseAccount(String expenseAccount) {
        this.expenseAccount = expenseAccount;
        return this;
    }

    @ApiModelProperty(example="420", value="Reimbursement expense account. For posted pay run you should be able to see expense account code.")
    public String getExpenseAccount() {
        return this.expenseAccount;
    }

    public void setExpenseAccount(String expenseAccount) {
        this.expenseAccount = expenseAccount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReimbursementLine reimbursementLine = (ReimbursementLine)o;
        return Objects.equals(this.reimbursementTypeID, reimbursementLine.reimbursementTypeID) && Objects.equals(this.amount, reimbursementLine.amount) && Objects.equals(this.description, reimbursementLine.description) && Objects.equals(this.expenseAccount, reimbursementLine.expenseAccount);
    }

    public int hashCode() {
        return Objects.hash(this.reimbursementTypeID, this.amount, this.description, this.expenseAccount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReimbursementLine {\n");
        sb.append("    reimbursementTypeID: ").append(this.toIndentedString(this.reimbursementTypeID)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    expenseAccount: ").append(this.toIndentedString(this.expenseAccount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

