/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrollau;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import com.xero.models.payrollau.Account;
import com.xero.models.payrollau.SettingsTrackingCategories;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Settings {
    StringUtil util = new StringUtil();
    @JsonProperty(value="Accounts")
    private List<Account> accounts = new ArrayList<Account>();
    @JsonProperty(value="TrackingCategories")
    private SettingsTrackingCategories trackingCategories;
    @JsonProperty(value="DaysInPayrollYear")
    private Integer daysInPayrollYear;

    public Settings accounts(List<Account> accounts) {
        this.accounts = accounts;
        return this;
    }

    public Settings addAccountsItem(Account accountsItem) {
        if (this.accounts == null) {
            this.accounts = new ArrayList<Account>();
        }
        this.accounts.add(accountsItem);
        return this;
    }

    @ApiModelProperty(value="Payroll Account details for SuperExpense, SuperLiabilty, WagesExpense, PAYGLiability & WagesPayable.")
    public List<Account> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(List<Account> accounts) {
        this.accounts = accounts;
    }

    public Settings trackingCategories(SettingsTrackingCategories trackingCategories) {
        this.trackingCategories = trackingCategories;
        return this;
    }

    @ApiModelProperty(value="")
    public SettingsTrackingCategories getTrackingCategories() {
        return this.trackingCategories;
    }

    public void setTrackingCategories(SettingsTrackingCategories trackingCategories) {
        this.trackingCategories = trackingCategories;
    }

    public Settings daysInPayrollYear(Integer daysInPayrollYear) {
        this.daysInPayrollYear = daysInPayrollYear;
        return this;
    }

    @ApiModelProperty(example="365", value="Number of days in the Payroll year")
    public Integer getDaysInPayrollYear() {
        return this.daysInPayrollYear;
    }

    public void setDaysInPayrollYear(Integer daysInPayrollYear) {
        this.daysInPayrollYear = daysInPayrollYear;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Settings settings = (Settings)o;
        return Objects.equals(this.accounts, settings.accounts) && Objects.equals(this.trackingCategories, settings.trackingCategories) && Objects.equals(this.daysInPayrollYear, settings.daysInPayrollYear);
    }

    public int hashCode() {
        return Objects.hash(this.accounts, this.trackingCategories, this.daysInPayrollYear);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Settings {\n");
        sb.append("    accounts: ").append(this.toIndentedString(this.accounts)).append("\n");
        sb.append("    trackingCategories: ").append(this.toIndentedString(this.trackingCategories)).append("\n");
        sb.append("    daysInPayrollYear: ").append(this.toIndentedString(this.daysInPayrollYear)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

