/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrollau;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import com.xero.models.payrollau.SuperFundType;
import com.xero.models.payrollau.ValidationError;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.OffsetDateTime;

public class SuperFund {
    StringUtil util = new StringUtil();
    @JsonProperty(value="SuperFundID")
    private UUID superFundID;
    @JsonProperty(value="Type")
    private SuperFundType type;
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="ABN")
    private String ABN;
    @JsonProperty(value="BSB")
    private String BSB;
    @JsonProperty(value="AccountNumber")
    private String accountNumber;
    @JsonProperty(value="AccountName")
    private String accountName;
    @JsonProperty(value="ElectronicServiceAddress")
    private String electronicServiceAddress;
    @JsonProperty(value="EmployerNumber")
    private String employerNumber;
    @JsonProperty(value="SPIN")
    private String SPIN;
    @JsonProperty(value="USI")
    private String USI;
    @JsonProperty(value="UpdatedDateUTC")
    private String updatedDateUTC;
    @JsonProperty(value="ValidationErrors")
    private List<ValidationError> validationErrors = new ArrayList<ValidationError>();

    public SuperFund superFundID(UUID superFundID) {
        this.superFundID = superFundID;
        return this;
    }

    @ApiModelProperty(example="bfac31bd-ea62-4fc8-a5e7-7965d9504b15", value="Xero identifier for a super fund")
    public UUID getSuperFundID() {
        return this.superFundID;
    }

    public void setSuperFundID(UUID superFundID) {
        this.superFundID = superFundID;
    }

    public SuperFund type(SuperFundType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public SuperFundType getType() {
        return this.type;
    }

    public void setType(SuperFundType type) {
        this.type = type;
    }

    public SuperFund name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="MLC Navigator Retirement Plan - Superannuation Service (including Series 2) (MLC Superannuation Fund)", value="Name of the super fund")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SuperFund ABN(String ABN) {
        this.ABN = ABN;
        return this;
    }

    @ApiModelProperty(example="40022701955", value="ABN of the self managed super fund")
    public String getABN() {
        return this.ABN;
    }

    public void setABN(String ABN) {
        this.ABN = ABN;
    }

    public SuperFund BSB(String BSB) {
        this.BSB = BSB;
        return this;
    }

    @ApiModelProperty(example="234324", value="BSB of the self managed super fund")
    public String getBSB() {
        return this.BSB;
    }

    public void setBSB(String BSB) {
        this.BSB = BSB;
    }

    public SuperFund accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @ApiModelProperty(example="234234234", value="The account number for the self managed super fund.")
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public SuperFund accountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    @ApiModelProperty(example="Money account", value="The account name for the self managed super fund.")
    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public SuperFund electronicServiceAddress(String electronicServiceAddress) {
        this.electronicServiceAddress = electronicServiceAddress;
        return this;
    }

    @ApiModelProperty(example="12345678", value="The electronic service address for the self managed super fund.")
    public String getElectronicServiceAddress() {
        return this.electronicServiceAddress;
    }

    public void setElectronicServiceAddress(String electronicServiceAddress) {
        this.electronicServiceAddress = electronicServiceAddress;
    }

    public SuperFund employerNumber(String employerNumber) {
        this.employerNumber = employerNumber;
        return this;
    }

    @ApiModelProperty(example="324324", value="Some funds assign a unique number to each employer")
    public String getEmployerNumber() {
        return this.employerNumber;
    }

    public void setEmployerNumber(String employerNumber) {
        this.employerNumber = employerNumber;
    }

    public SuperFund SPIN(String SPIN) {
        this.SPIN = SPIN;
        return this;
    }

    @ApiModelProperty(example="4545445454", value="The SPIN of the Regulated SuperFund. This field has been deprecated. It will only be present for legacy superfunds. New superfunds will not have a SPIN value. The USI field should be used instead of SPIN.")
    public String getSPIN() {
        return this.SPIN;
    }

    public void setSPIN(String SPIN) {
        this.SPIN = SPIN;
    }

    public SuperFund USI(String USI) {
        this.USI = USI;
        return this;
    }

    @ApiModelProperty(example="40022701955001", value="The USI of the Regulated SuperFund")
    public String getUSI() {
        return this.USI;
    }

    public void setUSI(String USI) {
        this.USI = USI;
    }

    @ApiModelProperty(example="/Date(1583967733054+0000)/", value="Last modified timestamp")
    public String getUpdatedDateUTC() {
        return this.updatedDateUTC;
    }

    public OffsetDateTime getUpdatedDateUTCAsDate() {
        if (this.updatedDateUTC != null) {
            try {
                return this.util.convertStringToOffsetDateTime(this.updatedDateUTC);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public SuperFund validationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
        return this;
    }

    public SuperFund addValidationErrorsItem(ValidationError validationErrorsItem) {
        if (this.validationErrors == null) {
            this.validationErrors = new ArrayList<ValidationError>();
        }
        this.validationErrors.add(validationErrorsItem);
        return this;
    }

    @ApiModelProperty(value="Displays array of validation error messages from the API")
    public List<ValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    public void setValidationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SuperFund superFund = (SuperFund)o;
        return Objects.equals(this.superFundID, superFund.superFundID) && Objects.equals((Object)this.type, (Object)superFund.type) && Objects.equals(this.name, superFund.name) && Objects.equals(this.ABN, superFund.ABN) && Objects.equals(this.BSB, superFund.BSB) && Objects.equals(this.accountNumber, superFund.accountNumber) && Objects.equals(this.accountName, superFund.accountName) && Objects.equals(this.electronicServiceAddress, superFund.electronicServiceAddress) && Objects.equals(this.employerNumber, superFund.employerNumber) && Objects.equals(this.SPIN, superFund.SPIN) && Objects.equals(this.USI, superFund.USI) && Objects.equals(this.updatedDateUTC, superFund.updatedDateUTC) && Objects.equals(this.validationErrors, superFund.validationErrors);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.superFundID, this.type, this.name, this.ABN, this.BSB, this.accountNumber, this.accountName, this.electronicServiceAddress, this.employerNumber, this.SPIN, this.USI, this.updatedDateUTC, this.validationErrors});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SuperFund {\n");
        sb.append("    superFundID: ").append(this.toIndentedString(this.superFundID)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    ABN: ").append(this.toIndentedString(this.ABN)).append("\n");
        sb.append("    BSB: ").append(this.toIndentedString(this.BSB)).append("\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    accountName: ").append(this.toIndentedString(this.accountName)).append("\n");
        sb.append("    electronicServiceAddress: ").append(this.toIndentedString(this.electronicServiceAddress)).append("\n");
        sb.append("    employerNumber: ").append(this.toIndentedString(this.employerNumber)).append("\n");
        sb.append("    SPIN: ").append(this.toIndentedString(this.SPIN)).append("\n");
        sb.append("    USI: ").append(this.toIndentedString(this.USI)).append("\n");
        sb.append("    updatedDateUTC: ").append(this.toIndentedString(this.updatedDateUTC)).append("\n");
        sb.append("    validationErrors: ").append(this.toIndentedString(this.validationErrors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

