/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrollau;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import com.xero.models.payrollau.SuperannuationCalculationType;
import com.xero.models.payrollau.SuperannuationContributionType;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.ZoneId;

public class SuperannuationLine {
    StringUtil util = new StringUtil();
    @JsonProperty(value="SuperMembershipID")
    private UUID superMembershipID;
    @JsonProperty(value="ContributionType")
    private SuperannuationContributionType contributionType;
    @JsonProperty(value="CalculationType")
    private SuperannuationCalculationType calculationType;
    @JsonProperty(value="MinimumMonthlyEarnings")
    private Double minimumMonthlyEarnings;
    @JsonProperty(value="ExpenseAccountCode")
    private String expenseAccountCode;
    @JsonProperty(value="LiabilityAccountCode")
    private String liabilityAccountCode;
    @JsonProperty(value="PaymentDateForThisPeriod")
    private String paymentDateForThisPeriod;
    @JsonProperty(value="Percentage")
    private Double percentage;
    @JsonProperty(value="Amount")
    private Double amount;

    public SuperannuationLine superMembershipID(UUID superMembershipID) {
        this.superMembershipID = superMembershipID;
        return this;
    }

    @ApiModelProperty(example="e0eb6747-7c17-4075-b804-989f8d4e5d39", value="Xero identifier for payroll super fund membership ID.")
    public UUID getSuperMembershipID() {
        return this.superMembershipID;
    }

    public void setSuperMembershipID(UUID superMembershipID) {
        this.superMembershipID = superMembershipID;
    }

    public SuperannuationLine contributionType(SuperannuationContributionType contributionType) {
        this.contributionType = contributionType;
        return this;
    }

    @ApiModelProperty(value="")
    public SuperannuationContributionType getContributionType() {
        return this.contributionType;
    }

    public void setContributionType(SuperannuationContributionType contributionType) {
        this.contributionType = contributionType;
    }

    public SuperannuationLine calculationType(SuperannuationCalculationType calculationType) {
        this.calculationType = calculationType;
        return this;
    }

    @ApiModelProperty(value="")
    public SuperannuationCalculationType getCalculationType() {
        return this.calculationType;
    }

    public void setCalculationType(SuperannuationCalculationType calculationType) {
        this.calculationType = calculationType;
    }

    public SuperannuationLine minimumMonthlyEarnings(Double minimumMonthlyEarnings) {
        this.minimumMonthlyEarnings = minimumMonthlyEarnings;
        return this;
    }

    @ApiModelProperty(example="100.5", value="Superannuation minimum monthly earnings.")
    public Double getMinimumMonthlyEarnings() {
        return this.minimumMonthlyEarnings;
    }

    public void setMinimumMonthlyEarnings(Double minimumMonthlyEarnings) {
        this.minimumMonthlyEarnings = minimumMonthlyEarnings;
    }

    public SuperannuationLine expenseAccountCode(String expenseAccountCode) {
        this.expenseAccountCode = expenseAccountCode;
        return this;
    }

    @ApiModelProperty(example="450", value="Superannuation expense account code.")
    public String getExpenseAccountCode() {
        return this.expenseAccountCode;
    }

    public void setExpenseAccountCode(String expenseAccountCode) {
        this.expenseAccountCode = expenseAccountCode;
    }

    public SuperannuationLine liabilityAccountCode(String liabilityAccountCode) {
        this.liabilityAccountCode = liabilityAccountCode;
        return this;
    }

    @ApiModelProperty(example="650", value="Superannuation liability account code")
    public String getLiabilityAccountCode() {
        return this.liabilityAccountCode;
    }

    public void setLiabilityAccountCode(String liabilityAccountCode) {
        this.liabilityAccountCode = liabilityAccountCode;
    }

    public SuperannuationLine paymentDateForThisPeriod(String paymentDateForThisPeriod) {
        this.paymentDateForThisPeriod = paymentDateForThisPeriod;
        return this;
    }

    @ApiModelProperty(example="/Date(322560000000+0000)/", value="Superannuation payment date for the current period (YYYY-MM-DD)")
    public String getPaymentDateForThisPeriod() {
        return this.paymentDateForThisPeriod;
    }

    public LocalDate getPaymentDateForThisPeriodAsDate() {
        if (this.paymentDateForThisPeriod != null) {
            try {
                return this.util.convertStringToDate(this.paymentDateForThisPeriod);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setPaymentDateForThisPeriod(String paymentDateForThisPeriod) {
        this.paymentDateForThisPeriod = paymentDateForThisPeriod;
    }

    public void setPaymentDateForThisPeriod(LocalDate paymentDateForThisPeriod) {
        Instant instant = paymentDateForThisPeriod.atStartOfDay(ZoneId.of((String)"UTC").normalized()).toInstant();
        long timeInMillis = instant.toEpochMilli();
        this.paymentDateForThisPeriod = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
    }

    public SuperannuationLine percentage(Double percentage) {
        this.percentage = percentage;
        return this;
    }

    @ApiModelProperty(example="4.0", value="Superannuation percentage")
    public Double getPercentage() {
        return this.percentage;
    }

    public void setPercentage(Double percentage) {
        this.percentage = percentage;
    }

    public SuperannuationLine amount(Double amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(example="10.5", value="Superannuation amount")
    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SuperannuationLine superannuationLine = (SuperannuationLine)o;
        return Objects.equals(this.superMembershipID, superannuationLine.superMembershipID) && Objects.equals((Object)this.contributionType, (Object)superannuationLine.contributionType) && Objects.equals((Object)this.calculationType, (Object)superannuationLine.calculationType) && Objects.equals(this.minimumMonthlyEarnings, superannuationLine.minimumMonthlyEarnings) && Objects.equals(this.expenseAccountCode, superannuationLine.expenseAccountCode) && Objects.equals(this.liabilityAccountCode, superannuationLine.liabilityAccountCode) && Objects.equals(this.paymentDateForThisPeriod, superannuationLine.paymentDateForThisPeriod) && Objects.equals(this.percentage, superannuationLine.percentage) && Objects.equals(this.amount, superannuationLine.amount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.superMembershipID, this.contributionType, this.calculationType, this.minimumMonthlyEarnings, this.expenseAccountCode, this.liabilityAccountCode, this.paymentDateForThisPeriod, this.percentage, this.amount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SuperannuationLine {\n");
        sb.append("    superMembershipID: ").append(this.toIndentedString(this.superMembershipID)).append("\n");
        sb.append("    contributionType: ").append(this.toIndentedString((Object)this.contributionType)).append("\n");
        sb.append("    calculationType: ").append(this.toIndentedString((Object)this.calculationType)).append("\n");
        sb.append("    minimumMonthlyEarnings: ").append(this.toIndentedString(this.minimumMonthlyEarnings)).append("\n");
        sb.append("    expenseAccountCode: ").append(this.toIndentedString(this.expenseAccountCode)).append("\n");
        sb.append("    liabilityAccountCode: ").append(this.toIndentedString(this.liabilityAccountCode)).append("\n");
        sb.append("    paymentDateForThisPeriod: ").append(this.toIndentedString(this.paymentDateForThisPeriod)).append("\n");
        sb.append("    percentage: ").append(this.toIndentedString(this.percentage)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

