/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrollau;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.OffsetDateTime;

public class TimesheetLine {
    StringUtil util = new StringUtil();
    @JsonProperty(value="EarningsRateID")
    private UUID earningsRateID;
    @JsonProperty(value="TrackingItemID")
    private UUID trackingItemID;
    @JsonProperty(value="NumberOfUnits")
    private List<Double> numberOfUnits = new ArrayList<Double>();
    @JsonProperty(value="UpdatedDateUTC")
    private String updatedDateUTC;

    public TimesheetLine earningsRateID(UUID earningsRateID) {
        this.earningsRateID = earningsRateID;
        return this;
    }

    @ApiModelProperty(example="966c5c77-2ef0-4320-b6a9-6c27b080ecc5", value="The Xero identifier for an Earnings Rate")
    public UUID getEarningsRateID() {
        return this.earningsRateID;
    }

    public void setEarningsRateID(UUID earningsRateID) {
        this.earningsRateID = earningsRateID;
    }

    public TimesheetLine trackingItemID(UUID trackingItemID) {
        this.trackingItemID = trackingItemID;
        return this;
    }

    @ApiModelProperty(example="ae777a87-5ef3-4fa0-a4f0-d10e1f13073a", value="The Xero identifier for a Tracking Category. The TrackingOptionID must belong to the TrackingCategory selected as TimesheetCategories under Payroll Settings.")
    public UUID getTrackingItemID() {
        return this.trackingItemID;
    }

    public void setTrackingItemID(UUID trackingItemID) {
        this.trackingItemID = trackingItemID;
    }

    public TimesheetLine numberOfUnits(List<Double> numberOfUnits) {
        this.numberOfUnits = numberOfUnits;
        return this;
    }

    public TimesheetLine addNumberOfUnitsItem(Double numberOfUnitsItem) {
        if (this.numberOfUnits == null) {
            this.numberOfUnits = new ArrayList<Double>();
        }
        this.numberOfUnits.add(numberOfUnitsItem);
        return this;
    }

    @ApiModelProperty(value="The number of units on a timesheet line")
    public List<Double> getNumberOfUnits() {
        return this.numberOfUnits;
    }

    public void setNumberOfUnits(List<Double> numberOfUnits) {
        this.numberOfUnits = numberOfUnits;
    }

    @ApiModelProperty(example="/Date(1583967733054+0000)/", value="Last modified timestamp")
    public String getUpdatedDateUTC() {
        return this.updatedDateUTC;
    }

    public OffsetDateTime getUpdatedDateUTCAsDate() {
        if (this.updatedDateUTC != null) {
            try {
                return this.util.convertStringToOffsetDateTime(this.updatedDateUTC);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimesheetLine timesheetLine = (TimesheetLine)o;
        return Objects.equals(this.earningsRateID, timesheetLine.earningsRateID) && Objects.equals(this.trackingItemID, timesheetLine.trackingItemID) && Objects.equals(this.numberOfUnits, timesheetLine.numberOfUnits) && Objects.equals(this.updatedDateUTC, timesheetLine.updatedDateUTC);
    }

    public int hashCode() {
        return Objects.hash(this.earningsRateID, this.trackingItemID, this.numberOfUnits, this.updatedDateUTC);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TimesheetLine {\n");
        sb.append("    earningsRateID: ").append(this.toIndentedString(this.earningsRateID)).append("\n");
        sb.append("    trackingItemID: ").append(this.toIndentedString(this.trackingItemID)).append("\n");
        sb.append("    numberOfUnits: ").append(this.toIndentedString(this.numberOfUnits)).append("\n");
        sb.append("    updatedDateUTC: ").append(this.toIndentedString(this.updatedDateUTC)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

