/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrollnz;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class BankAccount {
    StringUtil util = new StringUtil();
    @JsonProperty(value="accountName")
    private String accountName;
    @JsonProperty(value="accountNumber")
    private String accountNumber;
    @JsonProperty(value="sortCode")
    private String sortCode;
    @JsonProperty(value="particulars")
    private String particulars;
    @JsonProperty(value="code")
    private String code;
    @JsonProperty(value="dollarAmount")
    private Double dollarAmount;
    @JsonProperty(value="reference")
    private String reference;
    @JsonProperty(value="calculationType")
    private CalculationTypeEnum calculationType;

    public BankAccount accountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    @ApiModelProperty(required=true, value="Bank account name (max length = 32)")
    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public BankAccount accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="Bank account number (digits only; max length = 8)")
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public BankAccount sortCode(String sortCode) {
        this.sortCode = sortCode;
        return this;
    }

    @ApiModelProperty(required=true, value="Bank account sort code (6 digits)")
    public String getSortCode() {
        return this.sortCode;
    }

    public void setSortCode(String sortCode) {
        this.sortCode = sortCode;
    }

    public BankAccount particulars(String particulars) {
        this.particulars = particulars;
        return this;
    }

    @ApiModelProperty(value="Particulars that appear on the statement.")
    public String getParticulars() {
        return this.particulars;
    }

    public void setParticulars(String particulars) {
        this.particulars = particulars;
    }

    public BankAccount code(String code) {
        this.code = code;
        return this;
    }

    @ApiModelProperty(value="Code of a transaction that appear on the statement.")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public BankAccount dollarAmount(Double dollarAmount) {
        this.dollarAmount = dollarAmount;
        return this;
    }

    @ApiModelProperty(value="Dollar amount of a transaction.")
    public Double getDollarAmount() {
        return this.dollarAmount;
    }

    public void setDollarAmount(Double dollarAmount) {
        this.dollarAmount = dollarAmount;
    }

    public BankAccount reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Statement Text/reference for a transaction that appear on the statement.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public BankAccount calculationType(CalculationTypeEnum calculationType) {
        this.calculationType = calculationType;
        return this;
    }

    @ApiModelProperty(value="Calculation type for the transaction can be 'Fixed Amount' or 'Balance'")
    public CalculationTypeEnum getCalculationType() {
        return this.calculationType;
    }

    public void setCalculationType(CalculationTypeEnum calculationType) {
        this.calculationType = calculationType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankAccount bankAccount = (BankAccount)o;
        return Objects.equals(this.accountName, bankAccount.accountName) && Objects.equals(this.accountNumber, bankAccount.accountNumber) && Objects.equals(this.sortCode, bankAccount.sortCode) && Objects.equals(this.particulars, bankAccount.particulars) && Objects.equals(this.code, bankAccount.code) && Objects.equals(this.dollarAmount, bankAccount.dollarAmount) && Objects.equals(this.reference, bankAccount.reference) && Objects.equals((Object)this.calculationType, (Object)bankAccount.calculationType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountName, this.accountNumber, this.sortCode, this.particulars, this.code, this.dollarAmount, this.reference, this.calculationType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BankAccount {\n");
        sb.append("    accountName: ").append(this.toIndentedString(this.accountName)).append("\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    sortCode: ").append(this.toIndentedString(this.sortCode)).append("\n");
        sb.append("    particulars: ").append(this.toIndentedString(this.particulars)).append("\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    dollarAmount: ").append(this.toIndentedString(this.dollarAmount)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    calculationType: ").append(this.toIndentedString((Object)this.calculationType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CalculationTypeEnum {
        FIXEDAMOUNT("FixedAmount"),
        BALANCE("Balance");

        private String value;

        private CalculationTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CalculationTypeEnum fromValue(String value) {
            for (CalculationTypeEnum b : CalculationTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

