/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrollnz;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;

public class Benefit {
    StringUtil util = new StringUtil();
    @JsonProperty(value="id")
    private UUID id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="category")
    private CategoryEnum category;
    @JsonProperty(value="liabilityAccountId")
    private UUID liabilityAccountId;
    @JsonProperty(value="expenseAccountId")
    private UUID expenseAccountId;
    @JsonProperty(value="calculationTypeNZ")
    private CalculationTypeNZEnum calculationTypeNZ;
    @JsonProperty(value="standardAmount")
    private Double standardAmount;
    @JsonProperty(value="percentage")
    private Double percentage;
    @JsonProperty(value="companyMax")
    private Double companyMax;
    @JsonProperty(value="currentRecord")
    private Boolean currentRecord;

    public Benefit id(UUID id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The Xero identifier for superannuation")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public Benefit name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the superannuations")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Benefit category(CategoryEnum category) {
        this.category = category;
        return this;
    }

    @ApiModelProperty(required=true, value="Superannuations Category type")
    public CategoryEnum getCategory() {
        return this.category;
    }

    public void setCategory(CategoryEnum category) {
        this.category = category;
    }

    public Benefit liabilityAccountId(UUID liabilityAccountId) {
        this.liabilityAccountId = liabilityAccountId;
        return this;
    }

    @ApiModelProperty(required=true, value="Xero identifier for Liability Account")
    public UUID getLiabilityAccountId() {
        return this.liabilityAccountId;
    }

    public void setLiabilityAccountId(UUID liabilityAccountId) {
        this.liabilityAccountId = liabilityAccountId;
    }

    public Benefit expenseAccountId(UUID expenseAccountId) {
        this.expenseAccountId = expenseAccountId;
        return this;
    }

    @ApiModelProperty(required=true, value="Xero identifier for Expense Account")
    public UUID getExpenseAccountId() {
        return this.expenseAccountId;
    }

    public void setExpenseAccountId(UUID expenseAccountId) {
        this.expenseAccountId = expenseAccountId;
    }

    public Benefit calculationTypeNZ(CalculationTypeNZEnum calculationTypeNZ) {
        this.calculationTypeNZ = calculationTypeNZ;
        return this;
    }

    @ApiModelProperty(value="Calculation Type of the superannuation either FixedAmount or PercentageOfTaxableEarnings")
    public CalculationTypeNZEnum getCalculationTypeNZ() {
        return this.calculationTypeNZ;
    }

    public void setCalculationTypeNZ(CalculationTypeNZEnum calculationTypeNZ) {
        this.calculationTypeNZ = calculationTypeNZ;
    }

    public Benefit standardAmount(Double standardAmount) {
        this.standardAmount = standardAmount;
        return this;
    }

    @ApiModelProperty(value="Standard amount of the superannuation")
    public Double getStandardAmount() {
        return this.standardAmount;
    }

    public void setStandardAmount(Double standardAmount) {
        this.standardAmount = standardAmount;
    }

    public Benefit percentage(Double percentage) {
        this.percentage = percentage;
        return this;
    }

    @ApiModelProperty(value="Percentage of Taxable Earnings of the superannuation")
    public Double getPercentage() {
        return this.percentage;
    }

    public void setPercentage(Double percentage) {
        this.percentage = percentage;
    }

    public Benefit companyMax(Double companyMax) {
        this.companyMax = companyMax;
        return this;
    }

    @ApiModelProperty(value="Company Maximum amount of the superannuation")
    public Double getCompanyMax() {
        return this.companyMax;
    }

    public void setCompanyMax(Double companyMax) {
        this.companyMax = companyMax;
    }

    public Benefit currentRecord(Boolean currentRecord) {
        this.currentRecord = currentRecord;
        return this;
    }

    @ApiModelProperty(value="Identifier of a record is active or not.")
    public Boolean getCurrentRecord() {
        return this.currentRecord;
    }

    public void setCurrentRecord(Boolean currentRecord) {
        this.currentRecord = currentRecord;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Benefit benefit = (Benefit)o;
        return Objects.equals(this.id, benefit.id) && Objects.equals(this.name, benefit.name) && Objects.equals((Object)this.category, (Object)benefit.category) && Objects.equals(this.liabilityAccountId, benefit.liabilityAccountId) && Objects.equals(this.expenseAccountId, benefit.expenseAccountId) && Objects.equals((Object)this.calculationTypeNZ, (Object)benefit.calculationTypeNZ) && Objects.equals(this.standardAmount, benefit.standardAmount) && Objects.equals(this.percentage, benefit.percentage) && Objects.equals(this.companyMax, benefit.companyMax) && Objects.equals(this.currentRecord, benefit.currentRecord);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.category, this.liabilityAccountId, this.expenseAccountId, this.calculationTypeNZ, this.standardAmount, this.percentage, this.companyMax, this.currentRecord});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Benefit {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    liabilityAccountId: ").append(this.toIndentedString(this.liabilityAccountId)).append("\n");
        sb.append("    expenseAccountId: ").append(this.toIndentedString(this.expenseAccountId)).append("\n");
        sb.append("    calculationTypeNZ: ").append(this.toIndentedString((Object)this.calculationTypeNZ)).append("\n");
        sb.append("    standardAmount: ").append(this.toIndentedString(this.standardAmount)).append("\n");
        sb.append("    percentage: ").append(this.toIndentedString(this.percentage)).append("\n");
        sb.append("    companyMax: ").append(this.toIndentedString(this.companyMax)).append("\n");
        sb.append("    currentRecord: ").append(this.toIndentedString(this.currentRecord)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CalculationTypeNZEnum {
        FIXEDAMOUNT("FixedAmount"),
        PERCENTAGEOFTAXABLEEARNINGS("PercentageOfTaxableEarnings");

        private String value;

        private CalculationTypeNZEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CalculationTypeNZEnum fromValue(String value) {
            for (CalculationTypeNZEnum b : CalculationTypeNZEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum CategoryEnum {
        KIWISAVER("KiwiSaver"),
        COMPLYINGFUND("ComplyingFund"),
        OTHER("Other");

        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CategoryEnum fromValue(String value) {
            for (CategoryEnum b : CategoryEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

