/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrollnz;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class EmployeeLeaveSetup {
    StringUtil util = new StringUtil();
    @JsonProperty(value="includeHolidayPay")
    private Boolean includeHolidayPay;
    @JsonProperty(value="holidayPayOpeningBalance")
    private Double holidayPayOpeningBalance;
    @JsonProperty(value="annualLeaveOpeningBalance")
    private Double annualLeaveOpeningBalance;
    @JsonProperty(value="negativeAnnualLeaveBalancePaidAmount")
    private Double negativeAnnualLeaveBalancePaidAmount;
    @JsonProperty(value="sickLeaveHoursToAccrueAnnually")
    private Double sickLeaveHoursToAccrueAnnually;
    @JsonProperty(value="sickLeaveMaximumHoursToAccrue")
    private Double sickLeaveMaximumHoursToAccrue;
    @JsonProperty(value="sickLeaveOpeningBalance")
    private Double sickLeaveOpeningBalance;

    public EmployeeLeaveSetup includeHolidayPay(Boolean includeHolidayPay) {
        this.includeHolidayPay = includeHolidayPay;
        return this;
    }

    @ApiModelProperty(example="false", value="Identifier if holiday pay will be included in each payslip")
    public Boolean getIncludeHolidayPay() {
        return this.includeHolidayPay;
    }

    public void setIncludeHolidayPay(Boolean includeHolidayPay) {
        this.includeHolidayPay = includeHolidayPay;
    }

    public EmployeeLeaveSetup holidayPayOpeningBalance(Double holidayPayOpeningBalance) {
        this.holidayPayOpeningBalance = holidayPayOpeningBalance;
        return this;
    }

    @ApiModelProperty(example="10.5", value="Initial holiday pay balance. A percentage \u2014 usually 8% \u2014 of gross earnings since their last work anniversary.")
    public Double getHolidayPayOpeningBalance() {
        return this.holidayPayOpeningBalance;
    }

    public void setHolidayPayOpeningBalance(Double holidayPayOpeningBalance) {
        this.holidayPayOpeningBalance = holidayPayOpeningBalance;
    }

    public EmployeeLeaveSetup annualLeaveOpeningBalance(Double annualLeaveOpeningBalance) {
        this.annualLeaveOpeningBalance = annualLeaveOpeningBalance;
        return this;
    }

    @ApiModelProperty(example="25.89", value="Initial annual leave balance. The balance at their last anniversary, less any leave taken since then and excluding accrued annual leave.")
    public Double getAnnualLeaveOpeningBalance() {
        return this.annualLeaveOpeningBalance;
    }

    public void setAnnualLeaveOpeningBalance(Double annualLeaveOpeningBalance) {
        this.annualLeaveOpeningBalance = annualLeaveOpeningBalance;
    }

    public EmployeeLeaveSetup negativeAnnualLeaveBalancePaidAmount(Double negativeAnnualLeaveBalancePaidAmount) {
        this.negativeAnnualLeaveBalancePaidAmount = negativeAnnualLeaveBalancePaidAmount;
        return this;
    }

    @ApiModelProperty(example="10.0", value="The dollar value of annual leave opening balance if negative.")
    public Double getNegativeAnnualLeaveBalancePaidAmount() {
        return this.negativeAnnualLeaveBalancePaidAmount;
    }

    public void setNegativeAnnualLeaveBalancePaidAmount(Double negativeAnnualLeaveBalancePaidAmount) {
        this.negativeAnnualLeaveBalancePaidAmount = negativeAnnualLeaveBalancePaidAmount;
    }

    public EmployeeLeaveSetup sickLeaveHoursToAccrueAnnually(Double sickLeaveHoursToAccrueAnnually) {
        this.sickLeaveHoursToAccrueAnnually = sickLeaveHoursToAccrueAnnually;
        return this;
    }

    @ApiModelProperty(example="100.5", value="Number of hours accrued annually for sick leave. Multiply the number of days they're entitled to by the hours worked per day")
    public Double getSickLeaveHoursToAccrueAnnually() {
        return this.sickLeaveHoursToAccrueAnnually;
    }

    public void setSickLeaveHoursToAccrueAnnually(Double sickLeaveHoursToAccrueAnnually) {
        this.sickLeaveHoursToAccrueAnnually = sickLeaveHoursToAccrueAnnually;
    }

    public EmployeeLeaveSetup sickLeaveMaximumHoursToAccrue(Double sickLeaveMaximumHoursToAccrue) {
        this.sickLeaveMaximumHoursToAccrue = sickLeaveMaximumHoursToAccrue;
        return this;
    }

    @ApiModelProperty(example="200.5", value="Maximum number of hours accrued annually for sick leave. Multiply the maximum days they can accrue by the hours worked per day")
    public Double getSickLeaveMaximumHoursToAccrue() {
        return this.sickLeaveMaximumHoursToAccrue;
    }

    public void setSickLeaveMaximumHoursToAccrue(Double sickLeaveMaximumHoursToAccrue) {
        this.sickLeaveMaximumHoursToAccrue = sickLeaveMaximumHoursToAccrue;
    }

    public EmployeeLeaveSetup sickLeaveOpeningBalance(Double sickLeaveOpeningBalance) {
        this.sickLeaveOpeningBalance = sickLeaveOpeningBalance;
        return this;
    }

    @ApiModelProperty(example="10.5", value="Initial sick leave balance. This will be positive unless they've taken sick leave in advance")
    public Double getSickLeaveOpeningBalance() {
        return this.sickLeaveOpeningBalance;
    }

    public void setSickLeaveOpeningBalance(Double sickLeaveOpeningBalance) {
        this.sickLeaveOpeningBalance = sickLeaveOpeningBalance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmployeeLeaveSetup employeeLeaveSetup = (EmployeeLeaveSetup)o;
        return Objects.equals(this.includeHolidayPay, employeeLeaveSetup.includeHolidayPay) && Objects.equals(this.holidayPayOpeningBalance, employeeLeaveSetup.holidayPayOpeningBalance) && Objects.equals(this.annualLeaveOpeningBalance, employeeLeaveSetup.annualLeaveOpeningBalance) && Objects.equals(this.negativeAnnualLeaveBalancePaidAmount, employeeLeaveSetup.negativeAnnualLeaveBalancePaidAmount) && Objects.equals(this.sickLeaveHoursToAccrueAnnually, employeeLeaveSetup.sickLeaveHoursToAccrueAnnually) && Objects.equals(this.sickLeaveMaximumHoursToAccrue, employeeLeaveSetup.sickLeaveMaximumHoursToAccrue) && Objects.equals(this.sickLeaveOpeningBalance, employeeLeaveSetup.sickLeaveOpeningBalance);
    }

    public int hashCode() {
        return Objects.hash(this.includeHolidayPay, this.holidayPayOpeningBalance, this.annualLeaveOpeningBalance, this.negativeAnnualLeaveBalancePaidAmount, this.sickLeaveHoursToAccrueAnnually, this.sickLeaveMaximumHoursToAccrue, this.sickLeaveOpeningBalance);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmployeeLeaveSetup {\n");
        sb.append("    includeHolidayPay: ").append(this.toIndentedString(this.includeHolidayPay)).append("\n");
        sb.append("    holidayPayOpeningBalance: ").append(this.toIndentedString(this.holidayPayOpeningBalance)).append("\n");
        sb.append("    annualLeaveOpeningBalance: ").append(this.toIndentedString(this.annualLeaveOpeningBalance)).append("\n");
        sb.append("    negativeAnnualLeaveBalancePaidAmount: ").append(this.toIndentedString(this.negativeAnnualLeaveBalancePaidAmount)).append("\n");
        sb.append("    sickLeaveHoursToAccrueAnnually: ").append(this.toIndentedString(this.sickLeaveHoursToAccrueAnnually)).append("\n");
        sb.append("    sickLeaveMaximumHoursToAccrue: ").append(this.toIndentedString(this.sickLeaveMaximumHoursToAccrue)).append("\n");
        sb.append("    sickLeaveOpeningBalance: ").append(this.toIndentedString(this.sickLeaveOpeningBalance)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

