/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrollnz;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDate;

public class EmployeeStatutorySickLeave {
    StringUtil util = new StringUtil();
    @JsonProperty(value="statutoryLeaveID")
    private UUID statutoryLeaveID;
    @JsonProperty(value="employeeID")
    private UUID employeeID;
    @JsonProperty(value="leaveTypeID")
    private UUID leaveTypeID;
    @JsonProperty(value="startDate")
    private LocalDate startDate;
    @JsonProperty(value="endDate")
    private LocalDate endDate;
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="status")
    private String status;
    @JsonProperty(value="workPattern")
    private List<String> workPattern = new ArrayList<String>();
    @JsonProperty(value="isPregnancyRelated")
    private Boolean isPregnancyRelated;
    @JsonProperty(value="sufficientNotice")
    private Boolean sufficientNotice;
    @JsonProperty(value="isEntitled")
    private Boolean isEntitled;
    @JsonProperty(value="entitlementWeeksRequested")
    private Double entitlementWeeksRequested;
    @JsonProperty(value="entitlementWeeksQualified")
    private Double entitlementWeeksQualified;
    @JsonProperty(value="entitlementWeeksRemaining")
    private Double entitlementWeeksRemaining;
    @JsonProperty(value="overlapsWithOtherLeave")
    private Boolean overlapsWithOtherLeave;
    @JsonProperty(value="entitlementFailureReasons")
    private List<EntitlementFailureReasonsEnum> entitlementFailureReasons = new ArrayList<EntitlementFailureReasonsEnum>();

    public EmployeeStatutorySickLeave statutoryLeaveID(UUID statutoryLeaveID) {
        this.statutoryLeaveID = statutoryLeaveID;
        return this;
    }

    @ApiModelProperty(value="The unique identifier (guid) of a statutory leave")
    public UUID getStatutoryLeaveID() {
        return this.statutoryLeaveID;
    }

    public void setStatutoryLeaveID(UUID statutoryLeaveID) {
        this.statutoryLeaveID = statutoryLeaveID;
    }

    public EmployeeStatutorySickLeave employeeID(UUID employeeID) {
        this.employeeID = employeeID;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier (guid) of the employee")
    public UUID getEmployeeID() {
        return this.employeeID;
    }

    public void setEmployeeID(UUID employeeID) {
        this.employeeID = employeeID;
    }

    public EmployeeStatutorySickLeave leaveTypeID(UUID leaveTypeID) {
        this.leaveTypeID = leaveTypeID;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier (guid) of the \"Statutory Sick Leave (non-pensionable)\" pay item")
    public UUID getLeaveTypeID() {
        return this.leaveTypeID;
    }

    public void setLeaveTypeID(UUID leaveTypeID) {
        this.leaveTypeID = leaveTypeID;
    }

    public EmployeeStatutorySickLeave startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The date when the leave starts")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public EmployeeStatutorySickLeave endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The date when the leave ends")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public EmployeeStatutorySickLeave type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="Sick", value="the type of statutory leave")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public EmployeeStatutorySickLeave status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="Pending", value="the type of statutory leave")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public EmployeeStatutorySickLeave workPattern(List<String> workPattern) {
        this.workPattern = workPattern;
        return this;
    }

    public EmployeeStatutorySickLeave addWorkPatternItem(String workPatternItem) {
        this.workPattern.add(workPatternItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The days of the work week the employee is scheduled to work at the time the leave is taken")
    public List<String> getWorkPattern() {
        return this.workPattern;
    }

    public void setWorkPattern(List<String> workPattern) {
        this.workPattern = workPattern;
    }

    public EmployeeStatutorySickLeave isPregnancyRelated(Boolean isPregnancyRelated) {
        this.isPregnancyRelated = isPregnancyRelated;
        return this;
    }

    @ApiModelProperty(required=true, value="Whether the sick leave was pregnancy related")
    public Boolean getIsPregnancyRelated() {
        return this.isPregnancyRelated;
    }

    public void setIsPregnancyRelated(Boolean isPregnancyRelated) {
        this.isPregnancyRelated = isPregnancyRelated;
    }

    public EmployeeStatutorySickLeave sufficientNotice(Boolean sufficientNotice) {
        this.sufficientNotice = sufficientNotice;
        return this;
    }

    @ApiModelProperty(required=true, value="Whether the employee provided sufficient notice and documentation as required by the employer supporting the sick leave request")
    public Boolean getSufficientNotice() {
        return this.sufficientNotice;
    }

    public void setSufficientNotice(Boolean sufficientNotice) {
        this.sufficientNotice = sufficientNotice;
    }

    public EmployeeStatutorySickLeave isEntitled(Boolean isEntitled) {
        this.isEntitled = isEntitled;
        return this;
    }

    @ApiModelProperty(value="Whether the leave was entitled to receive payment")
    public Boolean getIsEntitled() {
        return this.isEntitled;
    }

    public void setIsEntitled(Boolean isEntitled) {
        this.isEntitled = isEntitled;
    }

    public EmployeeStatutorySickLeave entitlementWeeksRequested(Double entitlementWeeksRequested) {
        this.entitlementWeeksRequested = entitlementWeeksRequested;
        return this;
    }

    @ApiModelProperty(value="The amount of requested time (in weeks)")
    public Double getEntitlementWeeksRequested() {
        return this.entitlementWeeksRequested;
    }

    public void setEntitlementWeeksRequested(Double entitlementWeeksRequested) {
        this.entitlementWeeksRequested = entitlementWeeksRequested;
    }

    public EmployeeStatutorySickLeave entitlementWeeksQualified(Double entitlementWeeksQualified) {
        this.entitlementWeeksQualified = entitlementWeeksQualified;
        return this;
    }

    @ApiModelProperty(value="The amount of statutory sick leave time off (in weeks) that is available to take at the time the leave was requested")
    public Double getEntitlementWeeksQualified() {
        return this.entitlementWeeksQualified;
    }

    public void setEntitlementWeeksQualified(Double entitlementWeeksQualified) {
        this.entitlementWeeksQualified = entitlementWeeksQualified;
    }

    public EmployeeStatutorySickLeave entitlementWeeksRemaining(Double entitlementWeeksRemaining) {
        this.entitlementWeeksRemaining = entitlementWeeksRemaining;
        return this;
    }

    @ApiModelProperty(value="A calculated amount of time (in weeks) that remains for the statutory sick leave period")
    public Double getEntitlementWeeksRemaining() {
        return this.entitlementWeeksRemaining;
    }

    public void setEntitlementWeeksRemaining(Double entitlementWeeksRemaining) {
        this.entitlementWeeksRemaining = entitlementWeeksRemaining;
    }

    public EmployeeStatutorySickLeave overlapsWithOtherLeave(Boolean overlapsWithOtherLeave) {
        this.overlapsWithOtherLeave = overlapsWithOtherLeave;
        return this;
    }

    @ApiModelProperty(value="Whether another leave (Paternity, Shared Parental specifically) occurs during the requested leave's period. While this is allowed it could affect payment amounts")
    public Boolean getOverlapsWithOtherLeave() {
        return this.overlapsWithOtherLeave;
    }

    public void setOverlapsWithOtherLeave(Boolean overlapsWithOtherLeave) {
        this.overlapsWithOtherLeave = overlapsWithOtherLeave;
    }

    public EmployeeStatutorySickLeave entitlementFailureReasons(List<EntitlementFailureReasonsEnum> entitlementFailureReasons) {
        this.entitlementFailureReasons = entitlementFailureReasons;
        return this;
    }

    public EmployeeStatutorySickLeave addEntitlementFailureReasonsItem(EntitlementFailureReasonsEnum entitlementFailureReasonsItem) {
        if (this.entitlementFailureReasons == null) {
            this.entitlementFailureReasons = new ArrayList<EntitlementFailureReasonsEnum>();
        }
        this.entitlementFailureReasons.add(entitlementFailureReasonsItem);
        return this;
    }

    @ApiModelProperty(value="If the leave requested was considered \"not entitled\", the reasons why are listed here.")
    public List<EntitlementFailureReasonsEnum> getEntitlementFailureReasons() {
        return this.entitlementFailureReasons;
    }

    public void setEntitlementFailureReasons(List<EntitlementFailureReasonsEnum> entitlementFailureReasons) {
        this.entitlementFailureReasons = entitlementFailureReasons;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmployeeStatutorySickLeave employeeStatutorySickLeave = (EmployeeStatutorySickLeave)o;
        return Objects.equals(this.statutoryLeaveID, employeeStatutorySickLeave.statutoryLeaveID) && Objects.equals(this.employeeID, employeeStatutorySickLeave.employeeID) && Objects.equals(this.leaveTypeID, employeeStatutorySickLeave.leaveTypeID) && Objects.equals(this.startDate, employeeStatutorySickLeave.startDate) && Objects.equals(this.endDate, employeeStatutorySickLeave.endDate) && Objects.equals(this.type, employeeStatutorySickLeave.type) && Objects.equals(this.status, employeeStatutorySickLeave.status) && Objects.equals(this.workPattern, employeeStatutorySickLeave.workPattern) && Objects.equals(this.isPregnancyRelated, employeeStatutorySickLeave.isPregnancyRelated) && Objects.equals(this.sufficientNotice, employeeStatutorySickLeave.sufficientNotice) && Objects.equals(this.isEntitled, employeeStatutorySickLeave.isEntitled) && Objects.equals(this.entitlementWeeksRequested, employeeStatutorySickLeave.entitlementWeeksRequested) && Objects.equals(this.entitlementWeeksQualified, employeeStatutorySickLeave.entitlementWeeksQualified) && Objects.equals(this.entitlementWeeksRemaining, employeeStatutorySickLeave.entitlementWeeksRemaining) && Objects.equals(this.overlapsWithOtherLeave, employeeStatutorySickLeave.overlapsWithOtherLeave) && Objects.equals(this.entitlementFailureReasons, employeeStatutorySickLeave.entitlementFailureReasons);
    }

    public int hashCode() {
        return Objects.hash(this.statutoryLeaveID, this.employeeID, this.leaveTypeID, this.startDate, this.endDate, this.type, this.status, this.workPattern, this.isPregnancyRelated, this.sufficientNotice, this.isEntitled, this.entitlementWeeksRequested, this.entitlementWeeksQualified, this.entitlementWeeksRemaining, this.overlapsWithOtherLeave, this.entitlementFailureReasons);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmployeeStatutorySickLeave {\n");
        sb.append("    statutoryLeaveID: ").append(this.toIndentedString(this.statutoryLeaveID)).append("\n");
        sb.append("    employeeID: ").append(this.toIndentedString(this.employeeID)).append("\n");
        sb.append("    leaveTypeID: ").append(this.toIndentedString(this.leaveTypeID)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    workPattern: ").append(this.toIndentedString(this.workPattern)).append("\n");
        sb.append("    isPregnancyRelated: ").append(this.toIndentedString(this.isPregnancyRelated)).append("\n");
        sb.append("    sufficientNotice: ").append(this.toIndentedString(this.sufficientNotice)).append("\n");
        sb.append("    isEntitled: ").append(this.toIndentedString(this.isEntitled)).append("\n");
        sb.append("    entitlementWeeksRequested: ").append(this.toIndentedString(this.entitlementWeeksRequested)).append("\n");
        sb.append("    entitlementWeeksQualified: ").append(this.toIndentedString(this.entitlementWeeksQualified)).append("\n");
        sb.append("    entitlementWeeksRemaining: ").append(this.toIndentedString(this.entitlementWeeksRemaining)).append("\n");
        sb.append("    overlapsWithOtherLeave: ").append(this.toIndentedString(this.overlapsWithOtherLeave)).append("\n");
        sb.append("    entitlementFailureReasons: ").append(this.toIndentedString(this.entitlementFailureReasons)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum EntitlementFailureReasonsEnum {
        UNABLETOCALCULATEAWE("UnableToCalculateAwe"),
        AWELOWERTHANLEL("AweLowerThanLel"),
        NOTQUALIFIEDINPREVIOUSPIW("NotQualifiedInPreviousPiw"),
        EXCEEDEDMAXIMUMENTITLEMENTWEEKSOFSSP("ExceededMaximumEntitlementWeeksOfSsp"),
        EXCEEDEDMAXIMUMDURATIONOFPIW("ExceededMaximumDurationOfPiw"),
        SUFFICIENTNOTICENOTGIVEN("SufficientNoticeNotGiven");

        private String value;

        private EntitlementFailureReasonsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EntitlementFailureReasonsEnum fromValue(String value) {
            for (EntitlementFailureReasonsEnum b : EntitlementFailureReasonsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

