/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrollnz;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;

public class Reimbursement {
    StringUtil util = new StringUtil();
    @JsonProperty(value="reimbursementID")
    private UUID reimbursementID;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="accountID")
    private UUID accountID;
    @JsonProperty(value="currentRecord")
    private Boolean currentRecord;
    @JsonProperty(value="reimbursementCategory")
    private ReimbursementCategoryEnum reimbursementCategory;
    @JsonProperty(value="calculationType")
    private CalculationTypeEnum calculationType;
    @JsonProperty(value="standardAmount")
    private String standardAmount;
    @JsonProperty(value="standardTypeOfUnits")
    private StandardTypeOfUnitsEnum standardTypeOfUnits;
    @JsonProperty(value="standardRatePerUnit")
    private Double standardRatePerUnit;

    public Reimbursement reimbursementID(UUID reimbursementID) {
        this.reimbursementID = reimbursementID;
        return this;
    }

    @ApiModelProperty(value="Xero unique identifier for a reimbursement")
    public UUID getReimbursementID() {
        return this.reimbursementID;
    }

    public void setReimbursementID(UUID reimbursementID) {
        this.reimbursementID = reimbursementID;
    }

    public Reimbursement name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the reimbursement")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Reimbursement accountID(UUID accountID) {
        this.accountID = accountID;
        return this;
    }

    @ApiModelProperty(required=true, value="Xero unique identifier for the account used for the reimbursement")
    public UUID getAccountID() {
        return this.accountID;
    }

    public void setAccountID(UUID accountID) {
        this.accountID = accountID;
    }

    public Reimbursement currentRecord(Boolean currentRecord) {
        this.currentRecord = currentRecord;
        return this;
    }

    @ApiModelProperty(value="Indicates that whether the reimbursement is active")
    public Boolean getCurrentRecord() {
        return this.currentRecord;
    }

    public void setCurrentRecord(Boolean currentRecord) {
        this.currentRecord = currentRecord;
    }

    public Reimbursement reimbursementCategory(ReimbursementCategoryEnum reimbursementCategory) {
        this.reimbursementCategory = reimbursementCategory;
        return this;
    }

    @ApiModelProperty(value="See Reimbursement Categories")
    public ReimbursementCategoryEnum getReimbursementCategory() {
        return this.reimbursementCategory;
    }

    public void setReimbursementCategory(ReimbursementCategoryEnum reimbursementCategory) {
        this.reimbursementCategory = reimbursementCategory;
    }

    public Reimbursement calculationType(CalculationTypeEnum calculationType) {
        this.calculationType = calculationType;
        return this;
    }

    @ApiModelProperty(value="See Calculation Types")
    public CalculationTypeEnum getCalculationType() {
        return this.calculationType;
    }

    public void setCalculationType(CalculationTypeEnum calculationType) {
        this.calculationType = calculationType;
    }

    public Reimbursement standardAmount(String standardAmount) {
        this.standardAmount = standardAmount;
        return this;
    }

    @ApiModelProperty(value="Optional Fixed Rate Amount. Applicable when calculation type is Fixed Amount")
    public String getStandardAmount() {
        return this.standardAmount;
    }

    public void setStandardAmount(String standardAmount) {
        this.standardAmount = standardAmount;
    }

    public Reimbursement standardTypeOfUnits(StandardTypeOfUnitsEnum standardTypeOfUnits) {
        this.standardTypeOfUnits = standardTypeOfUnits;
        return this;
    }

    @ApiModelProperty(value="Optional Type Of Units. Applicable when calculation type is Rate Per Unit")
    public StandardTypeOfUnitsEnum getStandardTypeOfUnits() {
        return this.standardTypeOfUnits;
    }

    public void setStandardTypeOfUnits(StandardTypeOfUnitsEnum standardTypeOfUnits) {
        this.standardTypeOfUnits = standardTypeOfUnits;
    }

    public Reimbursement standardRatePerUnit(Double standardRatePerUnit) {
        this.standardRatePerUnit = standardRatePerUnit;
        return this;
    }

    @ApiModelProperty(value="Optional Rate Per Unit. Applicable when calculation type is Rate Per Unit")
    public Double getStandardRatePerUnit() {
        return this.standardRatePerUnit;
    }

    public void setStandardRatePerUnit(Double standardRatePerUnit) {
        this.standardRatePerUnit = standardRatePerUnit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Reimbursement reimbursement = (Reimbursement)o;
        return Objects.equals(this.reimbursementID, reimbursement.reimbursementID) && Objects.equals(this.name, reimbursement.name) && Objects.equals(this.accountID, reimbursement.accountID) && Objects.equals(this.currentRecord, reimbursement.currentRecord) && Objects.equals((Object)this.reimbursementCategory, (Object)reimbursement.reimbursementCategory) && Objects.equals((Object)this.calculationType, (Object)reimbursement.calculationType) && Objects.equals(this.standardAmount, reimbursement.standardAmount) && Objects.equals((Object)this.standardTypeOfUnits, (Object)reimbursement.standardTypeOfUnits) && Objects.equals(this.standardRatePerUnit, reimbursement.standardRatePerUnit);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.reimbursementID, this.name, this.accountID, this.currentRecord, this.reimbursementCategory, this.calculationType, this.standardAmount, this.standardTypeOfUnits, this.standardRatePerUnit});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Reimbursement {\n");
        sb.append("    reimbursementID: ").append(this.toIndentedString(this.reimbursementID)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    accountID: ").append(this.toIndentedString(this.accountID)).append("\n");
        sb.append("    currentRecord: ").append(this.toIndentedString(this.currentRecord)).append("\n");
        sb.append("    reimbursementCategory: ").append(this.toIndentedString((Object)this.reimbursementCategory)).append("\n");
        sb.append("    calculationType: ").append(this.toIndentedString((Object)this.calculationType)).append("\n");
        sb.append("    standardAmount: ").append(this.toIndentedString(this.standardAmount)).append("\n");
        sb.append("    standardTypeOfUnits: ").append(this.toIndentedString((Object)this.standardTypeOfUnits)).append("\n");
        sb.append("    standardRatePerUnit: ").append(this.toIndentedString(this.standardRatePerUnit)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StandardTypeOfUnitsEnum {
        HOURS("Hours"),
        KM("km");

        private String value;

        private StandardTypeOfUnitsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StandardTypeOfUnitsEnum fromValue(String value) {
            for (StandardTypeOfUnitsEnum b : StandardTypeOfUnitsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum CalculationTypeEnum {
        UNKNOWN("Unknown"),
        FIXEDAMOUNT("FixedAmount"),
        RATEPERUNIT("RatePerUnit");

        private String value;

        private CalculationTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CalculationTypeEnum fromValue(String value) {
            for (CalculationTypeEnum b : CalculationTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ReimbursementCategoryEnum {
        GST("GST"),
        NOGST("NoGST"),
        GSTINCLUSIVE("GSTInclusive");

        private String value;

        private ReimbursementCategoryEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ReimbursementCategoryEnum fromValue(String value) {
            for (ReimbursementCategoryEnum b : ReimbursementCategoryEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

