/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrolluk;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import com.xero.models.payrolluk.Address;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDate;
import org.threeten.bp.LocalDateTime;

public class Employee {
    StringUtil util = new StringUtil();
    @JsonProperty(value="employeeID")
    private UUID employeeID;
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="firstName")
    private String firstName;
    @JsonProperty(value="lastName")
    private String lastName;
    @JsonProperty(value="dateOfBirth")
    private LocalDate dateOfBirth;
    @JsonProperty(value="address")
    private Address address;
    @JsonProperty(value="email")
    private String email;
    @JsonProperty(value="gender")
    private GenderEnum gender;
    @JsonProperty(value="phoneNumber")
    private String phoneNumber;
    @JsonProperty(value="startDate")
    private LocalDate startDate;
    @JsonProperty(value="endDate")
    private LocalDate endDate;
    @JsonProperty(value="payrollCalendarID")
    private UUID payrollCalendarID;
    @JsonProperty(value="updatedDateUTC")
    private LocalDateTime updatedDateUTC;
    @JsonProperty(value="createdDateUTC")
    private LocalDateTime createdDateUTC;
    @JsonProperty(value="nationalInsuranceNumber")
    private String nationalInsuranceNumber;

    public Employee employeeID(UUID employeeID) {
        this.employeeID = employeeID;
        return this;
    }

    @ApiModelProperty(example="d90457c4-f1be-4f2e-b4e3-f766390a7e30", value="Xero unique identifier for the employee")
    public UUID getEmployeeID() {
        return this.employeeID;
    }

    public void setEmployeeID(UUID employeeID) {
        this.employeeID = employeeID;
    }

    public Employee title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(example="Mrs", value="Title of the employee")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Employee firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @ApiModelProperty(example="Karen", value="First name of employee")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public Employee lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @ApiModelProperty(example="Jones", value="Last name of employee")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public Employee dateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
        return this;
    }

    @ApiModelProperty(example="Wed Jan 02 00:00:00 GMT 2019", value="Date of birth of the employee (YYYY-MM-DD)")
    public LocalDate getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public Employee address(Address address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(value="")
    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public Employee email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(example="developer@me.com", value="The email address for the employee")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Employee gender(GenderEnum gender) {
        this.gender = gender;
        return this;
    }

    @ApiModelProperty(example="F", value="The employee\u2019s gender")
    public GenderEnum getGender() {
        return this.gender;
    }

    public void setGender(GenderEnum gender) {
        this.gender = gender;
    }

    public Employee phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @ApiModelProperty(example="415-555-1212", value="Employee phone number")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public Employee startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(example="Sun Jan 19 00:00:00 GMT 2020", value="Employment start date of the employee at the time it was requested")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public Employee endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @ApiModelProperty(example="Sun Jan 19 00:00:00 GMT 2020", value="Employment end date of the employee at the time it was requested")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public Employee payrollCalendarID(UUID payrollCalendarID) {
        this.payrollCalendarID = payrollCalendarID;
        return this;
    }

    @ApiModelProperty(value="Xero unique identifier for the payroll calendar of the employee")
    public UUID getPayrollCalendarID() {
        return this.payrollCalendarID;
    }

    public void setPayrollCalendarID(UUID payrollCalendarID) {
        this.payrollCalendarID = payrollCalendarID;
    }

    public Employee updatedDateUTC(LocalDateTime updatedDateUTC) {
        this.updatedDateUTC = updatedDateUTC;
        return this;
    }

    @ApiModelProperty(value="UTC timestamp of last update to the employee")
    public LocalDateTime getUpdatedDateUTC() {
        return this.updatedDateUTC;
    }

    public void setUpdatedDateUTC(LocalDateTime updatedDateUTC) {
        this.updatedDateUTC = updatedDateUTC;
    }

    public Employee createdDateUTC(LocalDateTime createdDateUTC) {
        this.createdDateUTC = createdDateUTC;
        return this;
    }

    @ApiModelProperty(value="UTC timestamp when the employee was created in Xero")
    public LocalDateTime getCreatedDateUTC() {
        return this.createdDateUTC;
    }

    public void setCreatedDateUTC(LocalDateTime createdDateUTC) {
        this.createdDateUTC = createdDateUTC;
    }

    public Employee nationalInsuranceNumber(String nationalInsuranceNumber) {
        this.nationalInsuranceNumber = nationalInsuranceNumber;
        return this;
    }

    @ApiModelProperty(example="AB123456C", value="National insurance number of the employee")
    public String getNationalInsuranceNumber() {
        return this.nationalInsuranceNumber;
    }

    public void setNationalInsuranceNumber(String nationalInsuranceNumber) {
        this.nationalInsuranceNumber = nationalInsuranceNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Employee employee = (Employee)o;
        return Objects.equals(this.employeeID, employee.employeeID) && Objects.equals(this.title, employee.title) && Objects.equals(this.firstName, employee.firstName) && Objects.equals(this.lastName, employee.lastName) && Objects.equals(this.dateOfBirth, employee.dateOfBirth) && Objects.equals(this.address, employee.address) && Objects.equals(this.email, employee.email) && Objects.equals((Object)this.gender, (Object)employee.gender) && Objects.equals(this.phoneNumber, employee.phoneNumber) && Objects.equals(this.startDate, employee.startDate) && Objects.equals(this.endDate, employee.endDate) && Objects.equals(this.payrollCalendarID, employee.payrollCalendarID) && Objects.equals(this.updatedDateUTC, employee.updatedDateUTC) && Objects.equals(this.createdDateUTC, employee.createdDateUTC) && Objects.equals(this.nationalInsuranceNumber, employee.nationalInsuranceNumber);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.employeeID, this.title, this.firstName, this.lastName, this.dateOfBirth, this.address, this.email, this.gender, this.phoneNumber, this.startDate, this.endDate, this.payrollCalendarID, this.updatedDateUTC, this.createdDateUTC, this.nationalInsuranceNumber});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Employee {\n");
        sb.append("    employeeID: ").append(this.toIndentedString(this.employeeID)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    dateOfBirth: ").append(this.toIndentedString(this.dateOfBirth)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    gender: ").append(this.toIndentedString((Object)this.gender)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    payrollCalendarID: ").append(this.toIndentedString(this.payrollCalendarID)).append("\n");
        sb.append("    updatedDateUTC: ").append(this.toIndentedString(this.updatedDateUTC)).append("\n");
        sb.append("    createdDateUTC: ").append(this.toIndentedString(this.createdDateUTC)).append("\n");
        sb.append("    nationalInsuranceNumber: ").append(this.toIndentedString(this.nationalInsuranceNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum GenderEnum {
        M("M"),
        F("F");

        private String value;

        private GenderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static GenderEnum fromValue(String value) {
            for (GenderEnum b : GenderEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

