/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrolluk;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.threeten.bp.LocalDate;

public class EmployeeTax {
    StringUtil util = new StringUtil();
    @JsonProperty(value="starterType")
    private String starterType;
    @JsonProperty(value="starterDeclaration")
    private String starterDeclaration;
    @JsonProperty(value="taxCode")
    private String taxCode;
    @JsonProperty(value="w1M1")
    private Boolean w1M1;
    @JsonProperty(value="previousTaxablePay")
    private Double previousTaxablePay;
    @JsonProperty(value="previousTaxPaid")
    private Double previousTaxPaid;
    @JsonProperty(value="studentLoanDeduction")
    private String studentLoanDeduction;
    @JsonProperty(value="hasPostGraduateLoans")
    private Boolean hasPostGraduateLoans;
    @JsonProperty(value="isDirector")
    private Boolean isDirector;
    @JsonProperty(value="directorshipStartDate")
    private LocalDate directorshipStartDate;
    @JsonProperty(value="nicCalculationMethod")
    private String nicCalculationMethod;

    public EmployeeTax starterType(String starterType) {
        this.starterType = starterType;
        return this;
    }

    @ApiModelProperty(example="New Employee with P45", value="The Starter type.")
    public String getStarterType() {
        return this.starterType;
    }

    public void setStarterType(String starterType) {
        this.starterType = starterType;
    }

    public EmployeeTax starterDeclaration(String starterDeclaration) {
        this.starterDeclaration = starterDeclaration;
        return this;
    }

    @ApiModelProperty(example="B.) This is currently their only job", value="Starter declaration.")
    public String getStarterDeclaration() {
        return this.starterDeclaration;
    }

    public void setStarterDeclaration(String starterDeclaration) {
        this.starterDeclaration = starterDeclaration;
    }

    public EmployeeTax taxCode(String taxCode) {
        this.taxCode = taxCode;
        return this;
    }

    @ApiModelProperty(example="1185L", value="The Tax code.")
    public String getTaxCode() {
        return this.taxCode;
    }

    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode;
    }

    public EmployeeTax w1M1(Boolean w1M1) {
        this.w1M1 = w1M1;
        return this;
    }

    @ApiModelProperty(value="Describes whether the tax settings is W1M1")
    public Boolean getW1M1() {
        return this.w1M1;
    }

    public void setW1M1(Boolean w1M1) {
        this.w1M1 = w1M1;
    }

    public EmployeeTax previousTaxablePay(Double previousTaxablePay) {
        this.previousTaxablePay = previousTaxablePay;
        return this;
    }

    @ApiModelProperty(value="The previous taxable pay")
    public Double getPreviousTaxablePay() {
        return this.previousTaxablePay;
    }

    public void setPreviousTaxablePay(Double previousTaxablePay) {
        this.previousTaxablePay = previousTaxablePay;
    }

    public EmployeeTax previousTaxPaid(Double previousTaxPaid) {
        this.previousTaxPaid = previousTaxPaid;
        return this;
    }

    @ApiModelProperty(value="The tax amount previously paid")
    public Double getPreviousTaxPaid() {
        return this.previousTaxPaid;
    }

    public void setPreviousTaxPaid(Double previousTaxPaid) {
        this.previousTaxPaid = previousTaxPaid;
    }

    public EmployeeTax studentLoanDeduction(String studentLoanDeduction) {
        this.studentLoanDeduction = studentLoanDeduction;
        return this;
    }

    @ApiModelProperty(example="Plan Type 2", value="The employee's student loan deduction type")
    public String getStudentLoanDeduction() {
        return this.studentLoanDeduction;
    }

    public void setStudentLoanDeduction(String studentLoanDeduction) {
        this.studentLoanDeduction = studentLoanDeduction;
    }

    public EmployeeTax hasPostGraduateLoans(Boolean hasPostGraduateLoans) {
        this.hasPostGraduateLoans = hasPostGraduateLoans;
        return this;
    }

    @ApiModelProperty(value="Describes whether the employee has post graduate loans")
    public Boolean getHasPostGraduateLoans() {
        return this.hasPostGraduateLoans;
    }

    public void setHasPostGraduateLoans(Boolean hasPostGraduateLoans) {
        this.hasPostGraduateLoans = hasPostGraduateLoans;
    }

    public EmployeeTax isDirector(Boolean isDirector) {
        this.isDirector = isDirector;
        return this;
    }

    @ApiModelProperty(value="Describes whether the employee is director")
    public Boolean getIsDirector() {
        return this.isDirector;
    }

    public void setIsDirector(Boolean isDirector) {
        this.isDirector = isDirector;
    }

    public EmployeeTax directorshipStartDate(LocalDate directorshipStartDate) {
        this.directorshipStartDate = directorshipStartDate;
        return this;
    }

    @ApiModelProperty(value="The directorship start date")
    public LocalDate getDirectorshipStartDate() {
        return this.directorshipStartDate;
    }

    public void setDirectorshipStartDate(LocalDate directorshipStartDate) {
        this.directorshipStartDate = directorshipStartDate;
    }

    public EmployeeTax nicCalculationMethod(String nicCalculationMethod) {
        this.nicCalculationMethod = nicCalculationMethod;
        return this;
    }

    @ApiModelProperty(example="Annualized", value="NICs calculation method")
    public String getNicCalculationMethod() {
        return this.nicCalculationMethod;
    }

    public void setNicCalculationMethod(String nicCalculationMethod) {
        this.nicCalculationMethod = nicCalculationMethod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmployeeTax employeeTax = (EmployeeTax)o;
        return Objects.equals(this.starterType, employeeTax.starterType) && Objects.equals(this.starterDeclaration, employeeTax.starterDeclaration) && Objects.equals(this.taxCode, employeeTax.taxCode) && Objects.equals(this.w1M1, employeeTax.w1M1) && Objects.equals(this.previousTaxablePay, employeeTax.previousTaxablePay) && Objects.equals(this.previousTaxPaid, employeeTax.previousTaxPaid) && Objects.equals(this.studentLoanDeduction, employeeTax.studentLoanDeduction) && Objects.equals(this.hasPostGraduateLoans, employeeTax.hasPostGraduateLoans) && Objects.equals(this.isDirector, employeeTax.isDirector) && Objects.equals(this.directorshipStartDate, employeeTax.directorshipStartDate) && Objects.equals(this.nicCalculationMethod, employeeTax.nicCalculationMethod);
    }

    public int hashCode() {
        return Objects.hash(this.starterType, this.starterDeclaration, this.taxCode, this.w1M1, this.previousTaxablePay, this.previousTaxPaid, this.studentLoanDeduction, this.hasPostGraduateLoans, this.isDirector, this.directorshipStartDate, this.nicCalculationMethod);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmployeeTax {\n");
        sb.append("    starterType: ").append(this.toIndentedString(this.starterType)).append("\n");
        sb.append("    starterDeclaration: ").append(this.toIndentedString(this.starterDeclaration)).append("\n");
        sb.append("    taxCode: ").append(this.toIndentedString(this.taxCode)).append("\n");
        sb.append("    w1M1: ").append(this.toIndentedString(this.w1M1)).append("\n");
        sb.append("    previousTaxablePay: ").append(this.toIndentedString(this.previousTaxablePay)).append("\n");
        sb.append("    previousTaxPaid: ").append(this.toIndentedString(this.previousTaxPaid)).append("\n");
        sb.append("    studentLoanDeduction: ").append(this.toIndentedString(this.studentLoanDeduction)).append("\n");
        sb.append("    hasPostGraduateLoans: ").append(this.toIndentedString(this.hasPostGraduateLoans)).append("\n");
        sb.append("    isDirector: ").append(this.toIndentedString(this.isDirector)).append("\n");
        sb.append("    directorshipStartDate: ").append(this.toIndentedString(this.directorshipStartDate)).append("\n");
        sb.append("    nicCalculationMethod: ").append(this.toIndentedString(this.nicCalculationMethod)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

