/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrolluk;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import com.xero.models.payrolluk.Payslip;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDate;

public class PayRun {
    StringUtil util = new StringUtil();
    @JsonProperty(value="payRunID")
    private UUID payRunID;
    @JsonProperty(value="payrollCalendarID")
    private UUID payrollCalendarID;
    @JsonProperty(value="periodStartDate")
    private LocalDate periodStartDate;
    @JsonProperty(value="periodEndDate")
    private LocalDate periodEndDate;
    @JsonProperty(value="paymentDate")
    private LocalDate paymentDate;
    @JsonProperty(value="totalCost")
    private Double totalCost;
    @JsonProperty(value="totalPay")
    private Double totalPay;
    @JsonProperty(value="payRunStatus")
    private PayRunStatusEnum payRunStatus;
    @JsonProperty(value="payRunType")
    private PayRunTypeEnum payRunType;
    @JsonProperty(value="calendarType")
    private CalendarTypeEnum calendarType;
    @JsonProperty(value="postedDateTime")
    private LocalDate postedDateTime;
    @JsonProperty(value="paySlips")
    private List<Payslip> paySlips = new ArrayList<Payslip>();

    public PayRun payRunID(UUID payRunID) {
        this.payRunID = payRunID;
        return this;
    }

    @ApiModelProperty(value="Xero unique identifier for the pay run")
    public UUID getPayRunID() {
        return this.payRunID;
    }

    public void setPayRunID(UUID payRunID) {
        this.payRunID = payRunID;
    }

    public PayRun payrollCalendarID(UUID payrollCalendarID) {
        this.payrollCalendarID = payrollCalendarID;
        return this;
    }

    @ApiModelProperty(value="Xero unique identifier for the payroll calendar")
    public UUID getPayrollCalendarID() {
        return this.payrollCalendarID;
    }

    public void setPayrollCalendarID(UUID payrollCalendarID) {
        this.payrollCalendarID = payrollCalendarID;
    }

    public PayRun periodStartDate(LocalDate periodStartDate) {
        this.periodStartDate = periodStartDate;
        return this;
    }

    @ApiModelProperty(value="Period start date of the payroll calendar")
    public LocalDate getPeriodStartDate() {
        return this.periodStartDate;
    }

    public void setPeriodStartDate(LocalDate periodStartDate) {
        this.periodStartDate = periodStartDate;
    }

    public PayRun periodEndDate(LocalDate periodEndDate) {
        this.periodEndDate = periodEndDate;
        return this;
    }

    @ApiModelProperty(value="Period end date of the payroll calendar")
    public LocalDate getPeriodEndDate() {
        return this.periodEndDate;
    }

    public void setPeriodEndDate(LocalDate periodEndDate) {
        this.periodEndDate = periodEndDate;
    }

    public PayRun paymentDate(LocalDate paymentDate) {
        this.paymentDate = paymentDate;
        return this;
    }

    @ApiModelProperty(value="Payment date of the pay run")
    public LocalDate getPaymentDate() {
        return this.paymentDate;
    }

    public void setPaymentDate(LocalDate paymentDate) {
        this.paymentDate = paymentDate;
    }

    public PayRun totalCost(Double totalCost) {
        this.totalCost = totalCost;
        return this;
    }

    @ApiModelProperty(value="Total cost of the pay run")
    public Double getTotalCost() {
        return this.totalCost;
    }

    public void setTotalCost(Double totalCost) {
        this.totalCost = totalCost;
    }

    public PayRun totalPay(Double totalPay) {
        this.totalPay = totalPay;
        return this;
    }

    @ApiModelProperty(value="Total pay of the pay run")
    public Double getTotalPay() {
        return this.totalPay;
    }

    public void setTotalPay(Double totalPay) {
        this.totalPay = totalPay;
    }

    public PayRun payRunStatus(PayRunStatusEnum payRunStatus) {
        this.payRunStatus = payRunStatus;
        return this;
    }

    @ApiModelProperty(value="Pay run status")
    public PayRunStatusEnum getPayRunStatus() {
        return this.payRunStatus;
    }

    public void setPayRunStatus(PayRunStatusEnum payRunStatus) {
        this.payRunStatus = payRunStatus;
    }

    public PayRun payRunType(PayRunTypeEnum payRunType) {
        this.payRunType = payRunType;
        return this;
    }

    @ApiModelProperty(value="Pay run type")
    public PayRunTypeEnum getPayRunType() {
        return this.payRunType;
    }

    public void setPayRunType(PayRunTypeEnum payRunType) {
        this.payRunType = payRunType;
    }

    public PayRun calendarType(CalendarTypeEnum calendarType) {
        this.calendarType = calendarType;
        return this;
    }

    @ApiModelProperty(value="Calendar type of the pay run")
    public CalendarTypeEnum getCalendarType() {
        return this.calendarType;
    }

    public void setCalendarType(CalendarTypeEnum calendarType) {
        this.calendarType = calendarType;
    }

    public PayRun postedDateTime(LocalDate postedDateTime) {
        this.postedDateTime = postedDateTime;
        return this;
    }

    @ApiModelProperty(value="Posted date time of the pay run")
    public LocalDate getPostedDateTime() {
        return this.postedDateTime;
    }

    public void setPostedDateTime(LocalDate postedDateTime) {
        this.postedDateTime = postedDateTime;
    }

    public PayRun paySlips(List<Payslip> paySlips) {
        this.paySlips = paySlips;
        return this;
    }

    public PayRun addPaySlipsItem(Payslip paySlipsItem) {
        if (this.paySlips == null) {
            this.paySlips = new ArrayList<Payslip>();
        }
        this.paySlips.add(paySlipsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<Payslip> getPaySlips() {
        return this.paySlips;
    }

    public void setPaySlips(List<Payslip> paySlips) {
        this.paySlips = paySlips;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayRun payRun = (PayRun)o;
        return Objects.equals(this.payRunID, payRun.payRunID) && Objects.equals(this.payrollCalendarID, payRun.payrollCalendarID) && Objects.equals(this.periodStartDate, payRun.periodStartDate) && Objects.equals(this.periodEndDate, payRun.periodEndDate) && Objects.equals(this.paymentDate, payRun.paymentDate) && Objects.equals(this.totalCost, payRun.totalCost) && Objects.equals(this.totalPay, payRun.totalPay) && Objects.equals((Object)this.payRunStatus, (Object)payRun.payRunStatus) && Objects.equals((Object)this.payRunType, (Object)payRun.payRunType) && Objects.equals((Object)this.calendarType, (Object)payRun.calendarType) && Objects.equals(this.postedDateTime, payRun.postedDateTime) && Objects.equals(this.paySlips, payRun.paySlips);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.payRunID, this.payrollCalendarID, this.periodStartDate, this.periodEndDate, this.paymentDate, this.totalCost, this.totalPay, this.payRunStatus, this.payRunType, this.calendarType, this.postedDateTime, this.paySlips});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayRun {\n");
        sb.append("    payRunID: ").append(this.toIndentedString(this.payRunID)).append("\n");
        sb.append("    payrollCalendarID: ").append(this.toIndentedString(this.payrollCalendarID)).append("\n");
        sb.append("    periodStartDate: ").append(this.toIndentedString(this.periodStartDate)).append("\n");
        sb.append("    periodEndDate: ").append(this.toIndentedString(this.periodEndDate)).append("\n");
        sb.append("    paymentDate: ").append(this.toIndentedString(this.paymentDate)).append("\n");
        sb.append("    totalCost: ").append(this.toIndentedString(this.totalCost)).append("\n");
        sb.append("    totalPay: ").append(this.toIndentedString(this.totalPay)).append("\n");
        sb.append("    payRunStatus: ").append(this.toIndentedString((Object)this.payRunStatus)).append("\n");
        sb.append("    payRunType: ").append(this.toIndentedString((Object)this.payRunType)).append("\n");
        sb.append("    calendarType: ").append(this.toIndentedString((Object)this.calendarType)).append("\n");
        sb.append("    postedDateTime: ").append(this.toIndentedString(this.postedDateTime)).append("\n");
        sb.append("    paySlips: ").append(this.toIndentedString(this.paySlips)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CalendarTypeEnum {
        WEEKLY("Weekly"),
        FORTNIGHTLY("Fortnightly"),
        FOURWEEKLY("FourWeekly"),
        MONTHLY("Monthly"),
        ANNUAL("Annual"),
        QUARTERLY("Quarterly");

        private String value;

        private CalendarTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CalendarTypeEnum fromValue(String value) {
            for (CalendarTypeEnum b : CalendarTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PayRunTypeEnum {
        SCHEDULED("Scheduled"),
        UNSCHEDULED("Unscheduled"),
        EARLIERYEARUPDATE("EarlierYearUpdate");

        private String value;

        private PayRunTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PayRunTypeEnum fromValue(String value) {
            for (PayRunTypeEnum b : PayRunTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PayRunStatusEnum {
        DRAFT("Draft"),
        POSTED("Posted");

        private String value;

        private PayRunStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PayRunStatusEnum fromValue(String value) {
            for (PayRunStatusEnum b : PayRunStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

