/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrolluk;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;

public class TaxLine {
    StringUtil util = new StringUtil();
    @JsonProperty(value="taxLineID")
    private UUID taxLineID;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="isEmployerTax")
    private Boolean isEmployerTax;
    @JsonProperty(value="amount")
    private Double amount;
    @JsonProperty(value="globalTaxTypeID")
    private String globalTaxTypeID;
    @JsonProperty(value="manualAdjustment")
    private Boolean manualAdjustment;

    public TaxLine taxLineID(UUID taxLineID) {
        this.taxLineID = taxLineID;
        return this;
    }

    @ApiModelProperty(value="Xero identifier for payroll tax line")
    public UUID getTaxLineID() {
        return this.taxLineID;
    }

    public void setTaxLineID(UUID taxLineID) {
        this.taxLineID = taxLineID;
    }

    public TaxLine description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Tax line description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TaxLine isEmployerTax(Boolean isEmployerTax) {
        this.isEmployerTax = isEmployerTax;
        return this;
    }

    @ApiModelProperty(value="Identifies if the amount is paid for by the employee or employer. True if employer pays the tax")
    public Boolean getIsEmployerTax() {
        return this.isEmployerTax;
    }

    public void setIsEmployerTax(Boolean isEmployerTax) {
        this.isEmployerTax = isEmployerTax;
    }

    public TaxLine amount(Double amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="The amount of the tax line")
    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public TaxLine globalTaxTypeID(String globalTaxTypeID) {
        this.globalTaxTypeID = globalTaxTypeID;
        return this;
    }

    @ApiModelProperty(value="Tax type ID")
    public String getGlobalTaxTypeID() {
        return this.globalTaxTypeID;
    }

    public void setGlobalTaxTypeID(String globalTaxTypeID) {
        this.globalTaxTypeID = globalTaxTypeID;
    }

    public TaxLine manualAdjustment(Boolean manualAdjustment) {
        this.manualAdjustment = manualAdjustment;
        return this;
    }

    @ApiModelProperty(value="Identifies if the tax line is a manual adjustment")
    public Boolean getManualAdjustment() {
        return this.manualAdjustment;
    }

    public void setManualAdjustment(Boolean manualAdjustment) {
        this.manualAdjustment = manualAdjustment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaxLine taxLine = (TaxLine)o;
        return Objects.equals(this.taxLineID, taxLine.taxLineID) && Objects.equals(this.description, taxLine.description) && Objects.equals(this.isEmployerTax, taxLine.isEmployerTax) && Objects.equals(this.amount, taxLine.amount) && Objects.equals(this.globalTaxTypeID, taxLine.globalTaxTypeID) && Objects.equals(this.manualAdjustment, taxLine.manualAdjustment);
    }

    public int hashCode() {
        return Objects.hash(this.taxLineID, this.description, this.isEmployerTax, this.amount, this.globalTaxTypeID, this.manualAdjustment);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaxLine {\n");
        sb.append("    taxLineID: ").append(this.toIndentedString(this.taxLineID)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    isEmployerTax: ").append(this.toIndentedString(this.isEmployerTax)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    globalTaxTypeID: ").append(this.toIndentedString(this.globalTaxTypeID)).append("\n");
        sb.append("    manualAdjustment: ").append(this.toIndentedString(this.manualAdjustment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

