/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.project;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import com.xero.models.project.Amount;
import com.xero.models.project.CurrencyCode;
import com.xero.models.project.ProjectStatus;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.OffsetDateTime;

public class Project {
    StringUtil util = new StringUtil();
    @JsonProperty(value="projectId")
    private UUID projectId;
    @JsonProperty(value="contactId")
    private UUID contactId;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="currencyCode")
    private CurrencyCode currencyCode;
    @JsonProperty(value="minutesLogged")
    private Integer minutesLogged;
    @JsonProperty(value="totalTaskAmount")
    private Amount totalTaskAmount;
    @JsonProperty(value="totalExpenseAmount")
    private Amount totalExpenseAmount;
    @JsonProperty(value="estimateAmount")
    private Amount estimateAmount;
    @JsonProperty(value="minutesToBeInvoiced")
    private Integer minutesToBeInvoiced;
    @JsonProperty(value="taskAmountToBeInvoiced")
    private Amount taskAmountToBeInvoiced;
    @JsonProperty(value="taskAmountInvoiced")
    private Amount taskAmountInvoiced;
    @JsonProperty(value="expenseAmountToBeInvoiced")
    private Amount expenseAmountToBeInvoiced;
    @JsonProperty(value="expenseAmountInvoiced")
    private Amount expenseAmountInvoiced;
    @JsonProperty(value="projectAmountInvoiced")
    private Amount projectAmountInvoiced;
    @JsonProperty(value="deposit")
    private Amount deposit;
    @JsonProperty(value="depositApplied")
    private Amount depositApplied;
    @JsonProperty(value="creditNoteAmount")
    private Amount creditNoteAmount;
    @JsonProperty(value="deadlineUtc")
    private OffsetDateTime deadlineUtc;
    @JsonProperty(value="totalInvoiced")
    private Amount totalInvoiced;
    @JsonProperty(value="totalToBeInvoiced")
    private Amount totalToBeInvoiced;
    @JsonProperty(value="estimate")
    private Amount estimate;
    @JsonProperty(value="status")
    private ProjectStatus status;

    public Project projectId(UUID projectId) {
        this.projectId = projectId;
        return this;
    }

    @ApiModelProperty(example="254553fa-2be8-4991-bd5e-70a97ea12ef8", value="Identifier of the project.")
    public UUID getProjectId() {
        return this.projectId;
    }

    public void setProjectId(UUID projectId) {
        this.projectId = projectId;
    }

    public Project contactId(UUID contactId) {
        this.contactId = contactId;
        return this;
    }

    @ApiModelProperty(example="01234567-89ab-cdef-0123-456789abcdef", value="Identifier of the contact this project was created for.")
    public UUID getContactId() {
        return this.contactId;
    }

    public void setContactId(UUID contactId) {
        this.contactId = contactId;
    }

    public Project name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="New Kitchen", required=true, value="Name of the project.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Project currencyCode(CurrencyCode currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @ApiModelProperty(value="")
    public CurrencyCode getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(CurrencyCode currencyCode) {
        this.currencyCode = currencyCode;
    }

    public Project minutesLogged(Integer minutesLogged) {
        this.minutesLogged = minutesLogged;
        return this;
    }

    @ApiModelProperty(example="0", value="A total of minutes logged against all tasks on the Project.")
    public Integer getMinutesLogged() {
        return this.minutesLogged;
    }

    public void setMinutesLogged(Integer minutesLogged) {
        this.minutesLogged = minutesLogged;
    }

    public Project totalTaskAmount(Amount totalTaskAmount) {
        this.totalTaskAmount = totalTaskAmount;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getTotalTaskAmount() {
        return this.totalTaskAmount;
    }

    public void setTotalTaskAmount(Amount totalTaskAmount) {
        this.totalTaskAmount = totalTaskAmount;
    }

    public Project totalExpenseAmount(Amount totalExpenseAmount) {
        this.totalExpenseAmount = totalExpenseAmount;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getTotalExpenseAmount() {
        return this.totalExpenseAmount;
    }

    public void setTotalExpenseAmount(Amount totalExpenseAmount) {
        this.totalExpenseAmount = totalExpenseAmount;
    }

    public Project estimateAmount(Amount estimateAmount) {
        this.estimateAmount = estimateAmount;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getEstimateAmount() {
        return this.estimateAmount;
    }

    public void setEstimateAmount(Amount estimateAmount) {
        this.estimateAmount = estimateAmount;
    }

    public Project minutesToBeInvoiced(Integer minutesToBeInvoiced) {
        this.minutesToBeInvoiced = minutesToBeInvoiced;
        return this;
    }

    @ApiModelProperty(example="0", value="Minutes which have not been invoiced across all chargeable tasks in the project.")
    public Integer getMinutesToBeInvoiced() {
        return this.minutesToBeInvoiced;
    }

    public void setMinutesToBeInvoiced(Integer minutesToBeInvoiced) {
        this.minutesToBeInvoiced = minutesToBeInvoiced;
    }

    public Project taskAmountToBeInvoiced(Amount taskAmountToBeInvoiced) {
        this.taskAmountToBeInvoiced = taskAmountToBeInvoiced;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getTaskAmountToBeInvoiced() {
        return this.taskAmountToBeInvoiced;
    }

    public void setTaskAmountToBeInvoiced(Amount taskAmountToBeInvoiced) {
        this.taskAmountToBeInvoiced = taskAmountToBeInvoiced;
    }

    public Project taskAmountInvoiced(Amount taskAmountInvoiced) {
        this.taskAmountInvoiced = taskAmountInvoiced;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getTaskAmountInvoiced() {
        return this.taskAmountInvoiced;
    }

    public void setTaskAmountInvoiced(Amount taskAmountInvoiced) {
        this.taskAmountInvoiced = taskAmountInvoiced;
    }

    public Project expenseAmountToBeInvoiced(Amount expenseAmountToBeInvoiced) {
        this.expenseAmountToBeInvoiced = expenseAmountToBeInvoiced;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getExpenseAmountToBeInvoiced() {
        return this.expenseAmountToBeInvoiced;
    }

    public void setExpenseAmountToBeInvoiced(Amount expenseAmountToBeInvoiced) {
        this.expenseAmountToBeInvoiced = expenseAmountToBeInvoiced;
    }

    public Project expenseAmountInvoiced(Amount expenseAmountInvoiced) {
        this.expenseAmountInvoiced = expenseAmountInvoiced;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getExpenseAmountInvoiced() {
        return this.expenseAmountInvoiced;
    }

    public void setExpenseAmountInvoiced(Amount expenseAmountInvoiced) {
        this.expenseAmountInvoiced = expenseAmountInvoiced;
    }

    public Project projectAmountInvoiced(Amount projectAmountInvoiced) {
        this.projectAmountInvoiced = projectAmountInvoiced;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getProjectAmountInvoiced() {
        return this.projectAmountInvoiced;
    }

    public void setProjectAmountInvoiced(Amount projectAmountInvoiced) {
        this.projectAmountInvoiced = projectAmountInvoiced;
    }

    public Project deposit(Amount deposit) {
        this.deposit = deposit;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getDeposit() {
        return this.deposit;
    }

    public void setDeposit(Amount deposit) {
        this.deposit = deposit;
    }

    public Project depositApplied(Amount depositApplied) {
        this.depositApplied = depositApplied;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getDepositApplied() {
        return this.depositApplied;
    }

    public void setDepositApplied(Amount depositApplied) {
        this.depositApplied = depositApplied;
    }

    public Project creditNoteAmount(Amount creditNoteAmount) {
        this.creditNoteAmount = creditNoteAmount;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getCreditNoteAmount() {
        return this.creditNoteAmount;
    }

    public void setCreditNoteAmount(Amount creditNoteAmount) {
        this.creditNoteAmount = creditNoteAmount;
    }

    public Project deadlineUtc(OffsetDateTime deadlineUtc) {
        this.deadlineUtc = deadlineUtc;
        return this;
    }

    @ApiModelProperty(example="2019-12-10T12:59:59Z", value="Deadline for the project. UTC Date Time in ISO-8601 format.")
    public OffsetDateTime getDeadlineUtc() {
        return this.deadlineUtc;
    }

    public void setDeadlineUtc(OffsetDateTime deadlineUtc) {
        this.deadlineUtc = deadlineUtc;
    }

    public Project totalInvoiced(Amount totalInvoiced) {
        this.totalInvoiced = totalInvoiced;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getTotalInvoiced() {
        return this.totalInvoiced;
    }

    public void setTotalInvoiced(Amount totalInvoiced) {
        this.totalInvoiced = totalInvoiced;
    }

    public Project totalToBeInvoiced(Amount totalToBeInvoiced) {
        this.totalToBeInvoiced = totalToBeInvoiced;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getTotalToBeInvoiced() {
        return this.totalToBeInvoiced;
    }

    public void setTotalToBeInvoiced(Amount totalToBeInvoiced) {
        this.totalToBeInvoiced = totalToBeInvoiced;
    }

    public Project estimate(Amount estimate) {
        this.estimate = estimate;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getEstimate() {
        return this.estimate;
    }

    public void setEstimate(Amount estimate) {
        this.estimate = estimate;
    }

    public Project status(ProjectStatus status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="")
    public ProjectStatus getStatus() {
        return this.status;
    }

    public void setStatus(ProjectStatus status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Project project = (Project)o;
        return Objects.equals(this.projectId, project.projectId) && Objects.equals(this.contactId, project.contactId) && Objects.equals(this.name, project.name) && Objects.equals((Object)this.currencyCode, (Object)project.currencyCode) && Objects.equals(this.minutesLogged, project.minutesLogged) && Objects.equals(this.totalTaskAmount, project.totalTaskAmount) && Objects.equals(this.totalExpenseAmount, project.totalExpenseAmount) && Objects.equals(this.estimateAmount, project.estimateAmount) && Objects.equals(this.minutesToBeInvoiced, project.minutesToBeInvoiced) && Objects.equals(this.taskAmountToBeInvoiced, project.taskAmountToBeInvoiced) && Objects.equals(this.taskAmountInvoiced, project.taskAmountInvoiced) && Objects.equals(this.expenseAmountToBeInvoiced, project.expenseAmountToBeInvoiced) && Objects.equals(this.expenseAmountInvoiced, project.expenseAmountInvoiced) && Objects.equals(this.projectAmountInvoiced, project.projectAmountInvoiced) && Objects.equals(this.deposit, project.deposit) && Objects.equals(this.depositApplied, project.depositApplied) && Objects.equals(this.creditNoteAmount, project.creditNoteAmount) && Objects.equals(this.deadlineUtc, project.deadlineUtc) && Objects.equals(this.totalInvoiced, project.totalInvoiced) && Objects.equals(this.totalToBeInvoiced, project.totalToBeInvoiced) && Objects.equals(this.estimate, project.estimate) && Objects.equals((Object)this.status, (Object)project.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.projectId, this.contactId, this.name, this.currencyCode, this.minutesLogged, this.totalTaskAmount, this.totalExpenseAmount, this.estimateAmount, this.minutesToBeInvoiced, this.taskAmountToBeInvoiced, this.taskAmountInvoiced, this.expenseAmountToBeInvoiced, this.expenseAmountInvoiced, this.projectAmountInvoiced, this.deposit, this.depositApplied, this.creditNoteAmount, this.deadlineUtc, this.totalInvoiced, this.totalToBeInvoiced, this.estimate, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Project {\n");
        sb.append("    projectId: ").append(this.toIndentedString(this.projectId)).append("\n");
        sb.append("    contactId: ").append(this.toIndentedString(this.contactId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString((Object)this.currencyCode)).append("\n");
        sb.append("    minutesLogged: ").append(this.toIndentedString(this.minutesLogged)).append("\n");
        sb.append("    totalTaskAmount: ").append(this.toIndentedString(this.totalTaskAmount)).append("\n");
        sb.append("    totalExpenseAmount: ").append(this.toIndentedString(this.totalExpenseAmount)).append("\n");
        sb.append("    estimateAmount: ").append(this.toIndentedString(this.estimateAmount)).append("\n");
        sb.append("    minutesToBeInvoiced: ").append(this.toIndentedString(this.minutesToBeInvoiced)).append("\n");
        sb.append("    taskAmountToBeInvoiced: ").append(this.toIndentedString(this.taskAmountToBeInvoiced)).append("\n");
        sb.append("    taskAmountInvoiced: ").append(this.toIndentedString(this.taskAmountInvoiced)).append("\n");
        sb.append("    expenseAmountToBeInvoiced: ").append(this.toIndentedString(this.expenseAmountToBeInvoiced)).append("\n");
        sb.append("    expenseAmountInvoiced: ").append(this.toIndentedString(this.expenseAmountInvoiced)).append("\n");
        sb.append("    projectAmountInvoiced: ").append(this.toIndentedString(this.projectAmountInvoiced)).append("\n");
        sb.append("    deposit: ").append(this.toIndentedString(this.deposit)).append("\n");
        sb.append("    depositApplied: ").append(this.toIndentedString(this.depositApplied)).append("\n");
        sb.append("    creditNoteAmount: ").append(this.toIndentedString(this.creditNoteAmount)).append("\n");
        sb.append("    deadlineUtc: ").append(this.toIndentedString(this.deadlineUtc)).append("\n");
        sb.append("    totalInvoiced: ").append(this.toIndentedString(this.totalInvoiced)).append("\n");
        sb.append("    totalToBeInvoiced: ").append(this.toIndentedString(this.totalToBeInvoiced)).append("\n");
        sb.append("    estimate: ").append(this.toIndentedString(this.estimate)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

