/*
 * Decompiled with CFR 0.152.
 */
package com.xero.api;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZoneOffset;

public class StringUtil {
    public static boolean containsIgnoreCase(String[] array, String value) {
        for (String str : array) {
            if (value == null && str == null) {
                return true;
            }
            if (value == null || !value.equalsIgnoreCase(str)) continue;
            return true;
        }
        return false;
    }

    public static String join(String[] array, String separator) {
        int len = array.length;
        if (len == 0) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        out.append(array[0]);
        for (int i = 1; i < len; ++i) {
            out.append(separator).append(array[i]);
        }
        return out.toString();
    }

    public LocalDate convertStringToDate(String date) throws IOException {
        LocalDate formattedDate;
        Pattern datePatt = Pattern.compile("^/Date\\((\\d+)([+-]\\d+)?\\)/$");
        Pattern datePattNeg = Pattern.compile("^/Date\\(-(\\d+)([+-]\\d+)?\\)/$");
        Matcher m = datePatt.matcher(date);
        Matcher matchNeg = datePattNeg.matcher(date);
        if (m != null && m.matches()) {
            Long l = Long.parseLong(m.group(1));
            formattedDate = Instant.ofEpochMilli((long)l).atZone((ZoneId)ZoneOffset.UTC).toLocalDate();
        } else if (matchNeg != null && matchNeg.matches()) {
            Long l = Long.parseLong(matchNeg.group(1));
            formattedDate = Instant.ofEpochMilli((long)(-l.longValue())).atZone((ZoneId)ZoneOffset.UTC).toLocalDate();
        } else {
            throw new IllegalArgumentException("Wrong date format");
        }
        return formattedDate;
    }

    public OffsetDateTime convertStringToOffsetDateTime(String date) throws IOException {
        OffsetDateTime formattedDate;
        Pattern datePatt = Pattern.compile("^/Date\\((\\d+)([+-]\\d+)?\\)/$");
        Matcher m = datePatt.matcher(date);
        Pattern datePattNeg = Pattern.compile("^/Date\\(-(\\d+)([+-]\\d+)?\\)/$");
        Matcher mNeg = datePattNeg.matcher(date);
        if (m != null && m.matches()) {
            Long l = Long.parseLong(m.group(1));
            formattedDate = Instant.ofEpochMilli((long)l).atZone((ZoneId)ZoneOffset.UTC).toOffsetDateTime();
        } else if (mNeg != null && mNeg.matches()) {
            Long l = Long.parseLong(mNeg.group(1));
            formattedDate = Instant.ofEpochMilli((long)(-l.longValue())).atZone((ZoneId)ZoneOffset.UTC).toOffsetDateTime();
        } else {
            throw new IllegalArgumentException("Wrong date format");
        }
        return formattedDate;
    }

    public LocalDateTime convertStringToLocalDateTime(String date) throws IOException {
        LocalDateTime formattedDate;
        Pattern datePatt = Pattern.compile("^/Date\\((\\d+)([+-]\\d+)?\\)/$");
        Matcher m = datePatt.matcher(date);
        Pattern datePattNeg = Pattern.compile("^/Date\\(-(\\d+)([+-]\\d+)?\\)/$");
        Matcher mNeg = datePattNeg.matcher(date);
        if (m != null && m.matches()) {
            Long l = Long.parseLong(m.group(1));
            formattedDate = Instant.ofEpochMilli((long)l).atZone((ZoneId)ZoneOffset.UTC).toLocalDateTime();
        } else if (mNeg != null && mNeg.matches()) {
            Long l = Long.parseLong(mNeg.group(1));
            formattedDate = Instant.ofEpochMilli((long)(-l.longValue())).atZone((ZoneId)ZoneOffset.UTC).toLocalDateTime();
        } else {
            throw new IllegalArgumentException("Wrong date format");
        }
        return formattedDate;
    }
}

