/*
 * Decompiled with CFR 0.152.
 */
package com.xero.api;

import com.xero.api.XeroException;
import com.xero.models.accounting.Element;
import com.xero.models.accounting.Error;
import com.xero.models.assets.FieldValidationErrorsElement;
import com.xero.models.bankfeeds.FeedConnection;
import com.xero.models.bankfeeds.FeedConnections;
import com.xero.models.bankfeeds.Statement;
import com.xero.models.bankfeeds.Statements;
import com.xero.models.payrollau.Employee;
import com.xero.models.payrollau.Employees;
import com.xero.models.payrollau.LeaveApplication;
import com.xero.models.payrollau.LeaveApplications;
import com.xero.models.payrollau.PayItem;
import com.xero.models.payrollau.PayItems;
import com.xero.models.payrollau.PayRun;
import com.xero.models.payrollau.PayRuns;
import com.xero.models.payrollau.PayrollCalendar;
import com.xero.models.payrollau.PayrollCalendars;
import com.xero.models.payrollau.SuperFund;
import com.xero.models.payrollau.SuperFunds;
import com.xero.models.payrollau.Timesheet;
import com.xero.models.payrollau.Timesheets;
import com.xero.models.payrollnz.Problem;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class XeroBadRequestException
extends XeroException {
    private static final long serialVersionUID = 1L;
    private Integer statusCode;
    private String type;
    private String message;
    private List<Element> elements = new ArrayList<Element>();
    private List<Statement> statementItems = new ArrayList<Statement>();
    private List<FeedConnection> feedConnectionItems = new ArrayList<FeedConnection>();
    private List<FieldValidationErrorsElement> fieldValidationErrorsElements = new ArrayList<FieldValidationErrorsElement>();
    private com.xero.models.payrolluk.Problem payrollUkProblem = new com.xero.models.payrolluk.Problem();
    private Problem payrollNzProblem = new Problem();
    private List<Employee> employeeItems = new ArrayList<Employee>();
    private List<LeaveApplication> leaveApplicationItems = new ArrayList<LeaveApplication>();
    private List<PayItem> payItemItems = new ArrayList<PayItem>();
    private List<PayrollCalendar> payrollCalendarItems = new ArrayList<PayrollCalendar>();
    private List<SuperFund> superFundItems = new ArrayList<SuperFund>();
    private List<Timesheet> timesheetItems = new ArrayList<Timesheet>();
    private List<PayRun> payRunItems = new ArrayList<PayRun>();

    public XeroBadRequestException(String objectType, Error error, Exception e) {
        super(e);
        this.statusCode = 400;
        this.type(objectType);
        this.elements(error.getElements());
    }

    public XeroBadRequestException(String objectType, com.xero.models.assets.Error error, Exception e) {
        super(e);
        this.statusCode = 400;
        this.type = objectType;
        this.fieldValidationErrorsElements = error.getFieldValidationErrors();
    }

    public XeroBadRequestException(String objectType, Statements error, Exception e) {
        super(e);
        this.statusCode = 400;
        this.type = objectType;
        this.statementItems = error.getItems();
    }

    public XeroBadRequestException(String objectType, FeedConnections error, Exception e) {
        super(e);
        this.statusCode = 400;
        this.type = objectType;
        this.feedConnectionItems = error.getItems();
    }

    public XeroBadRequestException(String objectType, com.xero.models.payrolluk.Problem problem, Exception e) {
        super(e);
        this.statusCode = 400;
        this.type = objectType;
        this.payrollUkProblem = problem;
    }

    public XeroBadRequestException(String objectType, Problem problem, Exception e) {
        super(e);
        this.statusCode = 400;
        this.type = objectType;
        this.payrollNzProblem = problem;
    }

    public XeroBadRequestException(String objectType, Employees employees, Exception e) {
        super(e);
        this.statusCode = 400;
        this.type = objectType;
        this.employeeItems = employees.getEmployees();
    }

    public XeroBadRequestException(String objectType, LeaveApplications leaveApplications, Exception e) {
        super(e);
        this.statusCode = 400;
        this.type = objectType;
        this.leaveApplicationItems = leaveApplications.getLeaveApplications();
    }

    public XeroBadRequestException(String objectType, PayItems payItems, Exception e) {
        super(e);
        this.statusCode = 400;
        this.type = objectType;
    }

    public XeroBadRequestException(String objectType, PayrollCalendars payrollCalendars, Exception e) {
        super(e);
        this.statusCode = 400;
        this.type = objectType;
        this.payrollCalendarItems = payrollCalendars.getPayrollCalendars();
    }

    public XeroBadRequestException(String objectType, SuperFunds superFunds, Exception e) {
        this.statusCode = 400;
        this.type = objectType;
        this.superFundItems = superFunds.getSuperFunds();
    }

    public XeroBadRequestException(String objectType, Timesheets timesheets, Exception e) {
        super(e);
        this.statusCode = 400;
        this.type = objectType;
        this.timesheetItems = timesheets.getTimesheets();
    }

    public XeroBadRequestException(String objectType, PayRuns payRuns, Exception e) {
        super(e);
        this.statusCode = 400;
        this.type = objectType;
        this.payRunItems = payRuns.getPayRuns();
    }

    public XeroBadRequestException(Integer statusCode, String message) {
        this.statusCode = statusCode;
        this.message = message;
    }

    public XeroBadRequestException(Integer statusCode, String message, Exception e) {
        super(message, e);
        this.statusCode = statusCode;
        this.message = message;
    }

    public XeroBadRequestException statusCode(Integer statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    @ApiModelProperty(value="Status Code")
    public Integer getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
    }

    public XeroBadRequestException type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="API set type")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public XeroBadRequestException message(String message) {
        this.message = message;
        return this;
    }

    @Override
    @ApiModelProperty(value="Exception message")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public XeroBadRequestException elements(List<Element> elements) {
        this.elements = elements;
        return this;
    }

    public XeroBadRequestException addElementsItem(Element elementsItem) {
        if (this.elements == null) {
            this.elements = new ArrayList<Element>();
        }
        this.elements.add(elementsItem);
        return this;
    }

    @ApiModelProperty(value="Array of Elements of validation Errors")
    public List<Element> getElements() {
        return this.elements;
    }

    public void setElements(List<Element> elements) {
        this.elements = elements;
    }

    public XeroBadRequestException statementItems(List<Statement> statementItems) {
        this.statementItems = statementItems;
        return this;
    }

    public XeroBadRequestException addStatementItem(Statement item) {
        if (this.statementItems == null) {
            this.statementItems = new ArrayList<Statement>();
        }
        this.statementItems.add(item);
        return this;
    }

    @ApiModelProperty(value="Array of Statement Items with Errors Array")
    public List<Statement> getStatementItems() {
        return this.statementItems;
    }

    public void setStatementItems(List<Statement> statementItems) {
        this.statementItems = statementItems;
    }

    public XeroBadRequestException feedConnectionItems(List<FeedConnection> feedConnectionItems) {
        this.feedConnectionItems = feedConnectionItems;
        return this;
    }

    public XeroBadRequestException addFeedConnectionItems(FeedConnection item) {
        if (this.feedConnectionItems == null) {
            this.feedConnectionItems = new ArrayList<FeedConnection>();
        }
        this.feedConnectionItems.add(item);
        return this;
    }

    @ApiModelProperty(value="Array of FeedConnection Items with Errors Array")
    public List<FeedConnection> getFeedConnectionItems() {
        return this.feedConnectionItems;
    }

    public void setFeedConnectionItems(List<FeedConnection> feedConnectionItems) {
        this.feedConnectionItems = feedConnectionItems;
    }

    public XeroBadRequestException fieldValidationErrorsElements(List<FieldValidationErrorsElement> fieldValidationErrorsElements) {
        this.fieldValidationErrorsElements = fieldValidationErrorsElements;
        return this;
    }

    public XeroBadRequestException addFieldValidationErrorsElement(FieldValidationErrorsElement element) {
        if (this.fieldValidationErrorsElements == null) {
            this.fieldValidationErrorsElements = new ArrayList<FieldValidationErrorsElement>();
        }
        this.fieldValidationErrorsElements.add(element);
        return this;
    }

    @ApiModelProperty(value="Array of FieldValidationErrorElement")
    public List<FieldValidationErrorsElement> getFieldValidationErrorsElements() {
        return this.fieldValidationErrorsElements;
    }

    public void setFieldValidationErrorsElements(List<FieldValidationErrorsElement> fieldValidationErrorsElements) {
        this.fieldValidationErrorsElements = fieldValidationErrorsElements;
    }

    public XeroBadRequestException payrollUkProblem(com.xero.models.payrolluk.Problem problem) {
        this.payrollUkProblem = problem;
        return this;
    }

    @ApiModelProperty(value="UK Payroll problem")
    public com.xero.models.payrolluk.Problem getPayrollUkProblem() {
        return this.payrollUkProblem;
    }

    public void setPayrollUkProblem(com.xero.models.payrolluk.Problem problem) {
        this.payrollUkProblem = problem;
    }

    public XeroBadRequestException payrollNzProblem(Problem problem) {
        this.payrollNzProblem = problem;
        return this;
    }

    @ApiModelProperty(value="NZ Payroll problem")
    public Problem getPayrollNzProblem() {
        return this.payrollNzProblem;
    }

    public void setPayrollNzProblem(Problem problem) {
        this.payrollNzProblem = problem;
    }

    public XeroBadRequestException employeeItemsItems(List<Employee> employeeItems) {
        this.employeeItems = employeeItems;
        return this;
    }

    public XeroBadRequestException addEmployeeItems(Employee item) {
        if (this.employeeItems == null) {
            this.employeeItems = new ArrayList<Employee>();
        }
        this.employeeItems.add(item);
        return this;
    }

    @ApiModelProperty(value="Array of FeedConnection Items with Errors Array")
    public List<Employee> getEmployeeItems() {
        return this.employeeItems;
    }

    public void setEmployeeItems(List<Employee> employeeItems) {
        this.employeeItems = employeeItems;
    }

    public XeroBadRequestException payItemItems(List<PayItem> payItemItems) {
        this.payItemItems = payItemItems;
        return this;
    }

    public XeroBadRequestException addPayItemItems(PayItem item) {
        if (this.payItemItems == null) {
            this.payItemItems = new ArrayList<PayItem>();
        }
        this.payItemItems.add(item);
        return this;
    }

    @ApiModelProperty(value="Array of PayItems with Validation Array")
    public List<PayItem> getPayItemItems() {
        return this.payItemItems;
    }

    public void setPayItemItems(List<PayItem> payItems) {
        this.payItemItems = payItems;
    }

    public XeroBadRequestException payRunItems(List<PayRun> payRunItems) {
        this.payRunItems = payRunItems;
        return this;
    }

    public XeroBadRequestException addPayRunItems(PayRun item) {
        if (this.payRunItems == null) {
            this.payRunItems = new ArrayList<PayRun>();
        }
        this.payRunItems.add(item);
        return this;
    }

    @ApiModelProperty(value="Array of PayRun with Validation Array")
    public List<PayRun> getPayRunItems() {
        return this.payRunItems;
    }

    public void setPayRunItems(List<PayRun> payRunItems) {
        this.payRunItems = payRunItems;
    }

    public XeroBadRequestException payrollCalendarItems(List<PayrollCalendar> payrollCalendarItems) {
        this.payrollCalendarItems = payrollCalendarItems;
        return this;
    }

    public XeroBadRequestException addPayrollCalendarItems(PayrollCalendar item) {
        if (this.payrollCalendarItems == null) {
            this.payrollCalendarItems = new ArrayList<PayrollCalendar>();
        }
        this.payrollCalendarItems.add(item);
        return this;
    }

    @ApiModelProperty(value="Array of PayrollCalendar with Validation Array")
    public List<PayrollCalendar> getPayrollCalendarItems() {
        return this.payrollCalendarItems;
    }

    public void setPayrollCalendarItems(List<PayrollCalendar> payrollCalendarItems) {
        this.payrollCalendarItems = payrollCalendarItems;
    }

    public XeroBadRequestException superFundItems(List<SuperFund> superFundItems) {
        this.superFundItems = superFundItems;
        return this;
    }

    public XeroBadRequestException addSuperFundItems(SuperFund item) {
        if (this.superFundItems == null) {
            this.superFundItems = new ArrayList<SuperFund>();
        }
        this.superFundItems.add(item);
        return this;
    }

    @ApiModelProperty(value="Array of SuperFund with Validation Array")
    public List<SuperFund> getSuperFundItems() {
        return this.superFundItems;
    }

    public void setSuperFundItems(List<SuperFund> superFundItems) {
        this.superFundItems = superFundItems;
    }

    public XeroBadRequestException timesheetItems(List<Timesheet> timesheetItems) {
        this.timesheetItems = timesheetItems;
        return this;
    }

    public XeroBadRequestException addTimesheetItems(Timesheet item) {
        if (this.timesheetItems == null) {
            this.timesheetItems = new ArrayList<Timesheet>();
        }
        this.timesheetItems.add(item);
        return this;
    }

    @ApiModelProperty(value="Array of Timesheet with Validation Array")
    public List<Timesheet> getTimesheetItems() {
        return this.timesheetItems;
    }

    public void setTimesheetItems(List<Timesheet> timesheetItems) {
        this.timesheetItems = timesheetItems;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XeroBadRequestException error = (XeroBadRequestException)o;
        return Objects.equals(this.statusCode, error.statusCode) && Objects.equals(this.type, error.type) && Objects.equals(this.message, error.message) && Objects.equals(this.elements, error.elements);
    }

    public int hashCode() {
        return Objects.hash(this.statusCode, this.type, this.message);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Error {\n");
        sb.append("    statusCode: ").append(this.toIndentedString(this.statusCode)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    elements: ").append(this.toIndentedString(this.elements)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

