/*
 * Decompiled with CFR 0.152.
 */
package com.xero.api.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.xero.api.ApiClient;
import com.xero.api.XeroApiExceptionHandler;
import com.xero.models.bankfeeds.FeedConnection;
import com.xero.models.bankfeeds.FeedConnections;
import com.xero.models.bankfeeds.Statement;
import com.xero.models.bankfeeds.Statements;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BankFeedsApi {
    private ApiClient apiClient;
    private static BankFeedsApi instance = null;
    private String userAgent = "Default";
    private String version = "4.29.1";
    static final Logger logger = LoggerFactory.getLogger(BankFeedsApi.class);

    public BankFeedsApi() {
        this(new ApiClient());
    }

    public static BankFeedsApi getInstance(ApiClient apiClient) {
        if (instance == null) {
            instance = new BankFeedsApi(apiClient);
        }
        return instance;
    }

    public BankFeedsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getUserAgent() {
        return this.userAgent + " [Xero-Java-" + this.version + "]";
    }

    public FeedConnections createFeedConnections(String accessToken, String xeroTenantId, FeedConnections feedConnections, String idempotencyKey) throws IOException {
        try {
            TypeReference<FeedConnections> typeRef = new TypeReference<FeedConnections>(){};
            HttpResponse response = this.createFeedConnectionsForHttpResponse(accessToken, xeroTenantId, feedConnections, idempotencyKey);
            return (FeedConnections)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createFeedConnections -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<FeedConnections> errorTypeRef = new TypeReference<FeedConnections>(){};
                FeedConnections bankFeedError = (FeedConnections)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError("FeedConnections", bankFeedError, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createFeedConnectionsForHttpResponse(String accessToken, String xeroTenantId, FeedConnections feedConnections, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createFeedConnections");
        }
        if (feedConnections == null) {
            throw new IllegalArgumentException("Missing the required parameter 'feedConnections' when calling createFeedConnections");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createFeedConnections");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/FeedConnections"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        content = apiClient.new ApiClient.JacksonJsonHttpContent(feedConnections);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Statements createStatements(String accessToken, String xeroTenantId, String idempotencyKey, Statements statements) throws IOException {
        try {
            TypeReference<Statements> typeRef = new TypeReference<Statements>(){};
            HttpResponse response = this.createStatementsForHttpResponse(accessToken, xeroTenantId, idempotencyKey, statements);
            return (Statements)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createStatements -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            if (e.getStatusCode() == 400) {
                TypeReference<Statements> errorTypeRef = new TypeReference<Statements>(){};
                Statements bankFeedError = (Statements)this.apiClient.getObjectMapper().readValue(e.getContent(), (TypeReference)errorTypeRef);
                handler.validationError("Statements", bankFeedError, (Exception)((Object)e));
            } else {
                handler.execute(e);
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createStatementsForHttpResponse(String accessToken, String xeroTenantId, String idempotencyKey, Statements statements) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createStatements");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createStatements");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/jsonapplication/problem+json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Statements"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        content = apiClient.new ApiClient.JacksonJsonHttpContent(statements);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public FeedConnections deleteFeedConnections(String accessToken, String xeroTenantId, FeedConnections feedConnections, String idempotencyKey) throws IOException {
        try {
            TypeReference<FeedConnections> typeRef = new TypeReference<FeedConnections>(){};
            HttpResponse response = this.deleteFeedConnectionsForHttpResponse(accessToken, xeroTenantId, feedConnections, idempotencyKey);
            return (FeedConnections)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : deleteFeedConnections -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse deleteFeedConnectionsForHttpResponse(String accessToken, String xeroTenantId, FeedConnections feedConnections, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling deleteFeedConnections");
        }
        if (feedConnections == null) {
            throw new IllegalArgumentException("Missing the required parameter 'feedConnections' when calling deleteFeedConnections");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling deleteFeedConnections");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/FeedConnections/DeleteRequests"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        content = apiClient.new ApiClient.JacksonJsonHttpContent(feedConnections);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public FeedConnection getFeedConnection(String accessToken, String xeroTenantId, UUID id) throws IOException {
        try {
            TypeReference<FeedConnection> typeRef = new TypeReference<FeedConnection>(){};
            HttpResponse response = this.getFeedConnectionForHttpResponse(accessToken, xeroTenantId, id);
            return (FeedConnection)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getFeedConnection -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getFeedConnectionForHttpResponse(String accessToken, String xeroTenantId, UUID id) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getFeedConnection");
        }
        if (id == null) {
            throw new IllegalArgumentException("Missing the required parameter 'id' when calling getFeedConnection");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getFeedConnection");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("id", id);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/FeedConnections/{id}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public FeedConnections getFeedConnections(String accessToken, String xeroTenantId, Integer page, Integer pageSize) throws IOException {
        try {
            TypeReference<FeedConnections> typeRef = new TypeReference<FeedConnections>(){};
            HttpResponse response = this.getFeedConnectionsForHttpResponse(accessToken, xeroTenantId, page, pageSize);
            return (FeedConnections)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getFeedConnections -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getFeedConnectionsForHttpResponse(String accessToken, String xeroTenantId, Integer page, Integer pageSize) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        Integer value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getFeedConnections");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getFeedConnections");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/FeedConnections"));
        if (page != null) {
            key = "page";
            value = page;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (pageSize != null) {
            key = "pageSize";
            value = pageSize;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Statement getStatement(String accessToken, String xeroTenantId, UUID statementId) throws IOException {
        try {
            TypeReference<Statement> typeRef = new TypeReference<Statement>(){};
            HttpResponse response = this.getStatementForHttpResponse(accessToken, xeroTenantId, statementId);
            return (Statement)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getStatement -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getStatementForHttpResponse(String accessToken, String xeroTenantId, UUID statementId) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getStatement");
        }
        if (statementId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'statementId' when calling getStatement");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getStatement");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("statementId", statementId);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Statements/{statementId}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Statements getStatements(String accessToken, String xeroTenantId, Integer page, Integer pageSize, String xeroApplicationId, String xeroUserId) throws IOException {
        try {
            TypeReference<Statements> typeRef = new TypeReference<Statements>(){};
            HttpResponse response = this.getStatementsForHttpResponse(accessToken, xeroTenantId, page, pageSize, xeroApplicationId, xeroUserId);
            return (Statements)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getStatements -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getStatementsForHttpResponse(String accessToken, String xeroTenantId, Integer page, Integer pageSize, String xeroApplicationId, String xeroUserId) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        Integer value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getStatements");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getStatements");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("Xero-Application-Id", (Object)xeroApplicationId);
        headers.set("Xero-User-Id", (Object)xeroUserId);
        headers.setAccept("application/jsonapplication/problem+json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Statements"));
        if (page != null) {
            key = "page";
            value = page;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (pageSize != null) {
            key = "pageSize";
            value = pageSize;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayInputStream convertInputToByteArray(InputStream is) throws IOException {
        byte[] bytes = IOUtils.toByteArray((InputStream)is);
        try {
            ByteArrayInputStream byteArrayInputStream;
            ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream = new ByteArrayInputStream(bytes);
            return byteArrayInputStream2;
        }
        finally {
            is.close();
        }
    }
}

