/*
 * Decompiled with CFR 0.152.
 */
package com.xero.api.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.xero.api.ApiClient;
import com.xero.api.XeroApiExceptionHandler;
import com.xero.models.finance.AccountUsageResponse;
import com.xero.models.finance.BalanceSheetResponse;
import com.xero.models.finance.BankStatementAccountingResponse;
import com.xero.models.finance.CashValidationResponse;
import com.xero.models.finance.CashflowResponse;
import com.xero.models.finance.IncomeByContactResponse;
import com.xero.models.finance.LockHistoryResponse;
import com.xero.models.finance.ProfitAndLossResponse;
import com.xero.models.finance.ReportHistoryResponse;
import com.xero.models.finance.TrialBalanceResponse;
import com.xero.models.finance.UserActivitiesResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinanceApi {
    private ApiClient apiClient;
    private static FinanceApi instance = null;
    private String userAgent = "Default";
    private String version = "4.29.1";
    static final Logger logger = LoggerFactory.getLogger(FinanceApi.class);

    public FinanceApi() {
        this(new ApiClient());
    }

    public static FinanceApi getInstance(ApiClient apiClient) {
        if (instance == null) {
            instance = new FinanceApi(apiClient);
        }
        return instance;
    }

    public FinanceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getUserAgent() {
        return this.userAgent + " [Xero-Java-" + this.version + "]";
    }

    public AccountUsageResponse getAccountingActivityAccountUsage(String accessToken, String xeroTenantId, String startMonth, String endMonth) throws IOException {
        try {
            TypeReference<AccountUsageResponse> typeRef = new TypeReference<AccountUsageResponse>(){};
            HttpResponse response = this.getAccountingActivityAccountUsageForHttpResponse(accessToken, xeroTenantId, startMonth, endMonth);
            return (AccountUsageResponse)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getAccountingActivityAccountUsage -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getAccountingActivityAccountUsageForHttpResponse(String accessToken, String xeroTenantId, String startMonth, String endMonth) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        String value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getAccountingActivityAccountUsage");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getAccountingActivityAccountUsage");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/AccountingActivities/AccountUsage"));
        if (startMonth != null) {
            key = "startMonth";
            value = startMonth;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (endMonth != null) {
            key = "endMonth";
            value = endMonth;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public LockHistoryResponse getAccountingActivityLockHistory(String accessToken, String xeroTenantId, String endDate) throws IOException {
        try {
            TypeReference<LockHistoryResponse> typeRef = new TypeReference<LockHistoryResponse>(){};
            HttpResponse response = this.getAccountingActivityLockHistoryForHttpResponse(accessToken, xeroTenantId, endDate);
            return (LockHistoryResponse)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getAccountingActivityLockHistory -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getAccountingActivityLockHistoryForHttpResponse(String accessToken, String xeroTenantId, String endDate) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getAccountingActivityLockHistory");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getAccountingActivityLockHistory");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/AccountingActivities/LockHistory"));
        if (endDate != null) {
            String key = "endDate";
            String value = endDate;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ReportHistoryResponse getAccountingActivityReportHistory(String accessToken, String xeroTenantId, String endDate) throws IOException {
        try {
            TypeReference<ReportHistoryResponse> typeRef = new TypeReference<ReportHistoryResponse>(){};
            HttpResponse response = this.getAccountingActivityReportHistoryForHttpResponse(accessToken, xeroTenantId, endDate);
            return (ReportHistoryResponse)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getAccountingActivityReportHistory -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getAccountingActivityReportHistoryForHttpResponse(String accessToken, String xeroTenantId, String endDate) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getAccountingActivityReportHistory");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getAccountingActivityReportHistory");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/AccountingActivities/ReportHistory"));
        if (endDate != null) {
            String key = "endDate";
            String value = endDate;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public UserActivitiesResponse getAccountingActivityUserActivities(String accessToken, String xeroTenantId, String dataMonth) throws IOException {
        try {
            TypeReference<UserActivitiesResponse> typeRef = new TypeReference<UserActivitiesResponse>(){};
            HttpResponse response = this.getAccountingActivityUserActivitiesForHttpResponse(accessToken, xeroTenantId, dataMonth);
            return (UserActivitiesResponse)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getAccountingActivityUserActivities -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getAccountingActivityUserActivitiesForHttpResponse(String accessToken, String xeroTenantId, String dataMonth) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getAccountingActivityUserActivities");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getAccountingActivityUserActivities");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/AccountingActivities/UserActivities"));
        if (dataMonth != null) {
            String key = "dataMonth";
            String value = dataMonth;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public BankStatementAccountingResponse getBankStatementAccounting(String accessToken, String xeroTenantId, UUID bankAccountID, String fromDate, String toDate, Boolean summaryOnly) throws IOException {
        try {
            TypeReference<BankStatementAccountingResponse> typeRef = new TypeReference<BankStatementAccountingResponse>(){};
            HttpResponse response = this.getBankStatementAccountingForHttpResponse(accessToken, xeroTenantId, bankAccountID, fromDate, toDate, summaryOnly);
            return (BankStatementAccountingResponse)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getBankStatementAccounting -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getBankStatementAccountingForHttpResponse(String accessToken, String xeroTenantId, UUID bankAccountID, String fromDate, String toDate, Boolean summaryOnly) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        Object value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getBankStatementAccounting");
        }
        if (bankAccountID == null) {
            throw new IllegalArgumentException("Missing the required parameter 'bankAccountID' when calling getBankStatementAccounting");
        }
        if (fromDate == null) {
            throw new IllegalArgumentException("Missing the required parameter 'fromDate' when calling getBankStatementAccounting");
        }
        if (toDate == null) {
            throw new IllegalArgumentException("Missing the required parameter 'toDate' when calling getBankStatementAccounting");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getBankStatementAccounting");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/BankStatementsPlus/statements"));
        if (bankAccountID != null) {
            key = "BankAccountID";
            value = bankAccountID;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (fromDate != null) {
            key = "FromDate";
            value = fromDate;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (toDate != null) {
            key = "ToDate";
            value = toDate;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (summaryOnly != null) {
            key = "SummaryOnly";
            value = summaryOnly;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public List<CashValidationResponse> getCashValidation(String accessToken, String xeroTenantId, String balanceDate, String asAtSystemDate, String beginDate) throws IOException {
        try {
            TypeReference<List<CashValidationResponse>> typeRef = new TypeReference<List<CashValidationResponse>>(){};
            HttpResponse response = this.getCashValidationForHttpResponse(accessToken, xeroTenantId, balanceDate, asAtSystemDate, beginDate);
            return (List)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getCashValidation -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getCashValidationForHttpResponse(String accessToken, String xeroTenantId, String balanceDate, String asAtSystemDate, String beginDate) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        String value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getCashValidation");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getCashValidation");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/CashValidation"));
        if (balanceDate != null) {
            key = "balanceDate";
            value = balanceDate;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (asAtSystemDate != null) {
            key = "asAtSystemDate";
            value = asAtSystemDate;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (beginDate != null) {
            key = "beginDate";
            value = beginDate;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public BalanceSheetResponse getFinancialStatementBalanceSheet(String accessToken, String xeroTenantId, String balanceDate) throws IOException {
        try {
            TypeReference<BalanceSheetResponse> typeRef = new TypeReference<BalanceSheetResponse>(){};
            HttpResponse response = this.getFinancialStatementBalanceSheetForHttpResponse(accessToken, xeroTenantId, balanceDate);
            return (BalanceSheetResponse)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getFinancialStatementBalanceSheet -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getFinancialStatementBalanceSheetForHttpResponse(String accessToken, String xeroTenantId, String balanceDate) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getFinancialStatementBalanceSheet");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getFinancialStatementBalanceSheet");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/FinancialStatements/BalanceSheet"));
        if (balanceDate != null) {
            String key = "balanceDate";
            String value = balanceDate;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public CashflowResponse getFinancialStatementCashflow(String accessToken, String xeroTenantId, String startDate, String endDate) throws IOException {
        try {
            TypeReference<CashflowResponse> typeRef = new TypeReference<CashflowResponse>(){};
            HttpResponse response = this.getFinancialStatementCashflowForHttpResponse(accessToken, xeroTenantId, startDate, endDate);
            return (CashflowResponse)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getFinancialStatementCashflow -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getFinancialStatementCashflowForHttpResponse(String accessToken, String xeroTenantId, String startDate, String endDate) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        String value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getFinancialStatementCashflow");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getFinancialStatementCashflow");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/FinancialStatements/Cashflow"));
        if (startDate != null) {
            key = "startDate";
            value = startDate;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (endDate != null) {
            key = "endDate";
            value = endDate;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public IncomeByContactResponse getFinancialStatementContactsExpense(String accessToken, String xeroTenantId, List<UUID> contactIds, Boolean includeManualJournals, String startDate, String endDate) throws IOException {
        try {
            TypeReference<IncomeByContactResponse> typeRef = new TypeReference<IncomeByContactResponse>(){};
            HttpResponse response = this.getFinancialStatementContactsExpenseForHttpResponse(accessToken, xeroTenantId, contactIds, includeManualJournals, startDate, endDate);
            return (IncomeByContactResponse)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getFinancialStatementContactsExpense -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getFinancialStatementContactsExpenseForHttpResponse(String accessToken, String xeroTenantId, List<UUID> contactIds, Boolean includeManualJournals, String startDate, String endDate) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        Object value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getFinancialStatementContactsExpense");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getFinancialStatementContactsExpense");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/FinancialStatements/contacts/expense"));
        if (contactIds != null) {
            key = "contactIds";
            value = contactIds;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (includeManualJournals != null) {
            key = "includeManualJournals";
            value = includeManualJournals;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (startDate != null) {
            key = "startDate";
            value = startDate;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (endDate != null) {
            key = "endDate";
            value = endDate;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public IncomeByContactResponse getFinancialStatementContactsRevenue(String accessToken, String xeroTenantId, List<UUID> contactIds, Boolean includeManualJournals, String startDate, String endDate) throws IOException {
        try {
            TypeReference<IncomeByContactResponse> typeRef = new TypeReference<IncomeByContactResponse>(){};
            HttpResponse response = this.getFinancialStatementContactsRevenueForHttpResponse(accessToken, xeroTenantId, contactIds, includeManualJournals, startDate, endDate);
            return (IncomeByContactResponse)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getFinancialStatementContactsRevenue -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getFinancialStatementContactsRevenueForHttpResponse(String accessToken, String xeroTenantId, List<UUID> contactIds, Boolean includeManualJournals, String startDate, String endDate) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        Object value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getFinancialStatementContactsRevenue");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getFinancialStatementContactsRevenue");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/FinancialStatements/contacts/revenue"));
        if (contactIds != null) {
            key = "contactIds";
            value = contactIds;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (includeManualJournals != null) {
            key = "includeManualJournals";
            value = includeManualJournals;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (startDate != null) {
            key = "startDate";
            value = startDate;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (endDate != null) {
            key = "endDate";
            value = endDate;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ProfitAndLossResponse getFinancialStatementProfitAndLoss(String accessToken, String xeroTenantId, String startDate, String endDate) throws IOException {
        try {
            TypeReference<ProfitAndLossResponse> typeRef = new TypeReference<ProfitAndLossResponse>(){};
            HttpResponse response = this.getFinancialStatementProfitAndLossForHttpResponse(accessToken, xeroTenantId, startDate, endDate);
            return (ProfitAndLossResponse)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getFinancialStatementProfitAndLoss -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getFinancialStatementProfitAndLossForHttpResponse(String accessToken, String xeroTenantId, String startDate, String endDate) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        String value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getFinancialStatementProfitAndLoss");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getFinancialStatementProfitAndLoss");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/FinancialStatements/ProfitAndLoss"));
        if (startDate != null) {
            key = "startDate";
            value = startDate;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (endDate != null) {
            key = "endDate";
            value = endDate;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public TrialBalanceResponse getFinancialStatementTrialBalance(String accessToken, String xeroTenantId, String endDate) throws IOException {
        try {
            TypeReference<TrialBalanceResponse> typeRef = new TypeReference<TrialBalanceResponse>(){};
            HttpResponse response = this.getFinancialStatementTrialBalanceForHttpResponse(accessToken, xeroTenantId, endDate);
            return (TrialBalanceResponse)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getFinancialStatementTrialBalance -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getFinancialStatementTrialBalanceForHttpResponse(String accessToken, String xeroTenantId, String endDate) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getFinancialStatementTrialBalance");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getFinancialStatementTrialBalance");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("xero-tenant-id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/FinancialStatements/TrialBalance"));
        if (endDate != null) {
            String key = "endDate";
            String value = endDate;
            if (value instanceof Collection) {
                ArrayList valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayInputStream convertInputToByteArray(InputStream is) throws IOException {
        byte[] bytes = IOUtils.toByteArray((InputStream)is);
        try {
            ByteArrayInputStream byteArrayInputStream;
            ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream = new ByteArrayInputStream(bytes);
            return byteArrayInputStream2;
        }
        finally {
            is.close();
        }
    }
}

