/*
 * Decompiled with CFR 0.152.
 */
package com.xero.api.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.xero.api.ApiClient;
import com.xero.api.XeroApiExceptionHandler;
import com.xero.models.project.ChargeType;
import com.xero.models.project.Project;
import com.xero.models.project.ProjectCreateOrUpdate;
import com.xero.models.project.ProjectPatch;
import com.xero.models.project.ProjectUsers;
import com.xero.models.project.Projects;
import com.xero.models.project.Task;
import com.xero.models.project.TaskCreateOrUpdate;
import com.xero.models.project.Tasks;
import com.xero.models.project.TimeEntries;
import com.xero.models.project.TimeEntry;
import com.xero.models.project.TimeEntryCreateOrUpdate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.bp.OffsetDateTime;

public class ProjectApi {
    private ApiClient apiClient;
    private static ProjectApi instance = null;
    private String userAgent = "Default";
    private String version = "4.29.1";
    static final Logger logger = LoggerFactory.getLogger(ProjectApi.class);

    public ProjectApi() {
        this(new ApiClient());
    }

    public static ProjectApi getInstance(ApiClient apiClient) {
        if (instance == null) {
            instance = new ProjectApi(apiClient);
        }
        return instance;
    }

    public ProjectApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getUserAgent() {
        return this.userAgent + " [Xero-Java-" + this.version + "]";
    }

    public Project createProject(String accessToken, String xeroTenantId, ProjectCreateOrUpdate projectCreateOrUpdate, String idempotencyKey) throws IOException {
        try {
            TypeReference<Project> typeRef = new TypeReference<Project>(){};
            HttpResponse response = this.createProjectForHttpResponse(accessToken, xeroTenantId, projectCreateOrUpdate, idempotencyKey);
            return (Project)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createProject -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createProjectForHttpResponse(String accessToken, String xeroTenantId, ProjectCreateOrUpdate projectCreateOrUpdate, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createProject");
        }
        if (projectCreateOrUpdate == null) {
            throw new IllegalArgumentException("Missing the required parameter 'projectCreateOrUpdate' when calling createProject");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createProject");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Projects"));
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        content = apiClient.new ApiClient.JacksonJsonHttpContent(projectCreateOrUpdate);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Task createTask(String accessToken, String xeroTenantId, UUID projectId, TaskCreateOrUpdate taskCreateOrUpdate, String idempotencyKey) throws IOException {
        try {
            TypeReference<Task> typeRef = new TypeReference<Task>(){};
            HttpResponse response = this.createTaskForHttpResponse(accessToken, xeroTenantId, projectId, taskCreateOrUpdate, idempotencyKey);
            return (Task)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createTask -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createTaskForHttpResponse(String accessToken, String xeroTenantId, UUID projectId, TaskCreateOrUpdate taskCreateOrUpdate, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createTask");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'projectId' when calling createTask");
        }
        if (taskCreateOrUpdate == null) {
            throw new IllegalArgumentException("Missing the required parameter 'taskCreateOrUpdate' when calling createTask");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createTask");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("projectId", projectId);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Projects/{projectId}/Tasks"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        content = apiClient.new ApiClient.JacksonJsonHttpContent(taskCreateOrUpdate);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public TimeEntry createTimeEntry(String accessToken, String xeroTenantId, UUID projectId, TimeEntryCreateOrUpdate timeEntryCreateOrUpdate, String idempotencyKey) throws IOException {
        try {
            TypeReference<TimeEntry> typeRef = new TypeReference<TimeEntry>(){};
            HttpResponse response = this.createTimeEntryForHttpResponse(accessToken, xeroTenantId, projectId, timeEntryCreateOrUpdate, idempotencyKey);
            return (TimeEntry)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : createTimeEntry -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse createTimeEntryForHttpResponse(String accessToken, String xeroTenantId, UUID projectId, TimeEntryCreateOrUpdate timeEntryCreateOrUpdate, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling createTimeEntry");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'projectId' when calling createTimeEntry");
        }
        if (timeEntryCreateOrUpdate == null) {
            throw new IllegalArgumentException("Missing the required parameter 'timeEntryCreateOrUpdate' when calling createTimeEntry");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling createTimeEntry");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("projectId", projectId);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Projects/{projectId}/Time"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("POST " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        content = apiClient.new ApiClient.JacksonJsonHttpContent(timeEntryCreateOrUpdate);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("POST", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public void deleteTask(String accessToken, String xeroTenantId, UUID projectId, UUID taskId) throws IOException {
        try {
            this.deleteTaskForHttpResponse(accessToken, xeroTenantId, projectId, taskId);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : deleteTask -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
    }

    public HttpResponse deleteTaskForHttpResponse(String accessToken, String xeroTenantId, UUID projectId, UUID taskId) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling deleteTask");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'projectId' when calling deleteTask");
        }
        if (taskId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'taskId' when calling deleteTask");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling deleteTask");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("projectId", projectId);
        uriVariables.put("taskId", taskId);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Projects/{projectId}/Tasks/{taskId}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("DELETE " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("DELETE", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public void deleteTimeEntry(String accessToken, String xeroTenantId, UUID projectId, UUID timeEntryId) throws IOException {
        try {
            this.deleteTimeEntryForHttpResponse(accessToken, xeroTenantId, projectId, timeEntryId);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : deleteTimeEntry -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
    }

    public HttpResponse deleteTimeEntryForHttpResponse(String accessToken, String xeroTenantId, UUID projectId, UUID timeEntryId) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling deleteTimeEntry");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'projectId' when calling deleteTimeEntry");
        }
        if (timeEntryId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'timeEntryId' when calling deleteTimeEntry");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling deleteTimeEntry");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("projectId", projectId);
        uriVariables.put("timeEntryId", timeEntryId);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Projects/{projectId}/Time/{timeEntryId}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("DELETE " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("DELETE", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Project getProject(String accessToken, String xeroTenantId, UUID projectId) throws IOException {
        try {
            TypeReference<Project> typeRef = new TypeReference<Project>(){};
            HttpResponse response = this.getProjectForHttpResponse(accessToken, xeroTenantId, projectId);
            return (Project)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getProject -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getProjectForHttpResponse(String accessToken, String xeroTenantId, UUID projectId) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getProject");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'projectId' when calling getProject");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getProject");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("projectId", projectId);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Projects/{projectId}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public ProjectUsers getProjectUsers(String accessToken, String xeroTenantId, Integer page, Integer pageSize) throws IOException {
        try {
            TypeReference<ProjectUsers> typeRef = new TypeReference<ProjectUsers>(){};
            HttpResponse response = this.getProjectUsersForHttpResponse(accessToken, xeroTenantId, page, pageSize);
            return (ProjectUsers)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getProjectUsers -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getProjectUsersForHttpResponse(String accessToken, String xeroTenantId, Integer page, Integer pageSize) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        Integer value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getProjectUsers");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getProjectUsers");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/ProjectsUsers"));
        if (page != null) {
            key = "page";
            value = page;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (pageSize != null) {
            key = "pageSize";
            value = pageSize;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)((Object)value));
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Projects getProjects(String accessToken, String xeroTenantId, List<UUID> projectIds, UUID contactID, String states, Integer page, Integer pageSize) throws IOException {
        try {
            TypeReference<Projects> typeRef = new TypeReference<Projects>(){};
            HttpResponse response = this.getProjectsForHttpResponse(accessToken, xeroTenantId, projectIds, contactID, states, page, pageSize);
            return (Projects)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getProjects -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getProjectsForHttpResponse(String accessToken, String xeroTenantId, List<UUID> projectIds, UUID contactID, String states, Integer page, Integer pageSize) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        Object value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getProjects");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getProjects");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Projects"));
        if (projectIds != null) {
            key = "projectIds";
            value = projectIds;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (contactID != null) {
            key = "contactID";
            value = contactID;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (states != null) {
            key = "states";
            value = states;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (page != null) {
            key = "page";
            value = page;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (pageSize != null) {
            key = "pageSize";
            value = pageSize;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.build(new Object[0]).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Task getTask(String accessToken, String xeroTenantId, UUID projectId, UUID taskId) throws IOException {
        try {
            TypeReference<Task> typeRef = new TypeReference<Task>(){};
            HttpResponse response = this.getTaskForHttpResponse(accessToken, xeroTenantId, projectId, taskId);
            return (Task)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getTask -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getTaskForHttpResponse(String accessToken, String xeroTenantId, UUID projectId, UUID taskId) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getTask");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'projectId' when calling getTask");
        }
        if (taskId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'taskId' when calling getTask");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getTask");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("projectId", projectId);
        uriVariables.put("taskId", taskId);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Projects/{projectId}/Tasks/{taskId}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public Tasks getTasks(String accessToken, String xeroTenantId, UUID projectId, Integer page, Integer pageSize, String taskIds, ChargeType chargeType) throws IOException {
        try {
            TypeReference<Tasks> typeRef = new TypeReference<Tasks>(){};
            HttpResponse response = this.getTasksForHttpResponse(accessToken, xeroTenantId, projectId, page, pageSize, taskIds, chargeType);
            return (Tasks)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getTasks -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getTasksForHttpResponse(String accessToken, String xeroTenantId, UUID projectId, Integer page, Integer pageSize, String taskIds, ChargeType chargeType) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        Object value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getTasks");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'projectId' when calling getTasks");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getTasks");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("projectId", projectId);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Projects/{projectId}/Tasks"));
        if (page != null) {
            key = "page";
            value = page;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (pageSize != null) {
            key = "pageSize";
            value = pageSize;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (taskIds != null) {
            key = "taskIds";
            value = taskIds;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (chargeType != null) {
            key = "chargeType";
            value = chargeType;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public TimeEntries getTimeEntries(String accessToken, String xeroTenantId, UUID projectId, UUID userId, UUID taskId, UUID invoiceId, UUID contactId, Integer page, Integer pageSize, List<String> states, Boolean isChargeable, OffsetDateTime dateAfterUtc, OffsetDateTime dateBeforeUtc) throws IOException {
        try {
            TypeReference<TimeEntries> typeRef = new TypeReference<TimeEntries>(){};
            HttpResponse response = this.getTimeEntriesForHttpResponse(accessToken, xeroTenantId, projectId, userId, taskId, invoiceId, contactId, page, pageSize, states, isChargeable, dateAfterUtc, dateBeforeUtc);
            return (TimeEntries)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getTimeEntries -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getTimeEntriesForHttpResponse(String accessToken, String xeroTenantId, UUID projectId, UUID userId, UUID taskId, UUID invoiceId, UUID contactId, Integer page, Integer pageSize, List<String> states, Boolean isChargeable, OffsetDateTime dateAfterUtc, OffsetDateTime dateBeforeUtc) throws IOException {
        int i;
        ArrayList<String> list;
        ArrayList valueList;
        Object value;
        String key;
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getTimeEntries");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'projectId' when calling getTimeEntries");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getTimeEntries");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("projectId", projectId);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Projects/{projectId}/Time"));
        if (userId != null) {
            key = "userId";
            value = userId;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList<String>();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (taskId != null) {
            key = "taskId";
            value = taskId;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (invoiceId != null) {
            key = "invoiceId";
            value = invoiceId;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (contactId != null) {
            key = "contactId";
            value = contactId;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (page != null) {
            key = "page";
            value = page;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (pageSize != null) {
            key = "pageSize";
            value = pageSize;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (states != null) {
            key = "states";
            value = states;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (isChargeable != null) {
            key = "isChargeable";
            value = isChargeable;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (dateAfterUtc != null) {
            key = "dateAfterUtc";
            value = dateAfterUtc;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        if (dateBeforeUtc != null) {
            key = "dateBeforeUtc";
            value = dateBeforeUtc;
            if (value instanceof Collection) {
                valueList = new ArrayList((Collection)value);
                if (!valueList.isEmpty() && valueList.get(0) instanceof UUID) {
                    list = new ArrayList();
                    for (i = 0; i < valueList.size(); ++i) {
                        list.add(valueList.get(i).toString());
                    }
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", list)});
                } else {
                    uriBuilder = uriBuilder.queryParam(key, new Object[]{String.join((CharSequence)",", valueList)});
                }
            } else {
                uriBuilder = value instanceof Object[] ? uriBuilder.queryParam(key, (Object[])value) : uriBuilder.queryParam(key, new Object[]{value});
            }
        }
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public TimeEntry getTimeEntry(String accessToken, String xeroTenantId, UUID projectId, UUID timeEntryId) throws IOException {
        try {
            TypeReference<TimeEntry> typeRef = new TypeReference<TimeEntry>(){};
            HttpResponse response = this.getTimeEntryForHttpResponse(accessToken, xeroTenantId, projectId, timeEntryId);
            return (TimeEntry)this.apiClient.getObjectMapper().readValue(response.getContent(), (TypeReference)typeRef);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : getTimeEntry -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        return null;
    }

    public HttpResponse getTimeEntryForHttpResponse(String accessToken, String xeroTenantId, UUID projectId, UUID timeEntryId) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling getTimeEntry");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'projectId' when calling getTimeEntry");
        }
        if (timeEntryId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'timeEntryId' when calling getTimeEntry");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling getTimeEntry");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("projectId", projectId);
        uriVariables.put("timeEntryId", timeEntryId);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Projects/{projectId}/Time/{timeEntryId}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("GET " + genericUrl.toString());
        }
        HttpContent content = null;
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("GET", genericUrl, content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public void patchProject(String accessToken, String xeroTenantId, UUID projectId, ProjectPatch projectPatch, String idempotencyKey) throws IOException {
        try {
            this.patchProjectForHttpResponse(accessToken, xeroTenantId, projectId, projectPatch, idempotencyKey);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : patchProject -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
    }

    public HttpResponse patchProjectForHttpResponse(String accessToken, String xeroTenantId, UUID projectId, ProjectPatch projectPatch, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling patchProject");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'projectId' when calling patchProject");
        }
        if (projectPatch == null) {
            throw new IllegalArgumentException("Missing the required parameter 'projectPatch' when calling patchProject");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling patchProject");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("projectId", projectId);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Projects/{projectId}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PATCH " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        content = apiClient.new ApiClient.JacksonJsonHttpContent(projectPatch);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PATCH", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public void updateProject(String accessToken, String xeroTenantId, UUID projectId, ProjectCreateOrUpdate projectCreateOrUpdate, String idempotencyKey) throws IOException {
        try {
            this.updateProjectForHttpResponse(accessToken, xeroTenantId, projectId, projectCreateOrUpdate, idempotencyKey);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateProject -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
    }

    public HttpResponse updateProjectForHttpResponse(String accessToken, String xeroTenantId, UUID projectId, ProjectCreateOrUpdate projectCreateOrUpdate, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateProject");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'projectId' when calling updateProject");
        }
        if (projectCreateOrUpdate == null) {
            throw new IllegalArgumentException("Missing the required parameter 'projectCreateOrUpdate' when calling updateProject");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateProject");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("projectId", projectId);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Projects/{projectId}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        content = apiClient.new ApiClient.JacksonJsonHttpContent(projectCreateOrUpdate);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public void updateTask(String accessToken, String xeroTenantId, UUID projectId, UUID taskId, TaskCreateOrUpdate taskCreateOrUpdate, String idempotencyKey) throws IOException {
        try {
            this.updateTaskForHttpResponse(accessToken, xeroTenantId, projectId, taskId, taskCreateOrUpdate, idempotencyKey);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateTask -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
    }

    public HttpResponse updateTaskForHttpResponse(String accessToken, String xeroTenantId, UUID projectId, UUID taskId, TaskCreateOrUpdate taskCreateOrUpdate, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateTask");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'projectId' when calling updateTask");
        }
        if (taskId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'taskId' when calling updateTask");
        }
        if (taskCreateOrUpdate == null) {
            throw new IllegalArgumentException("Missing the required parameter 'taskCreateOrUpdate' when calling updateTask");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateTask");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("projectId", projectId);
        uriVariables.put("taskId", taskId);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Projects/{projectId}/Tasks/{taskId}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        content = apiClient.new ApiClient.JacksonJsonHttpContent(taskCreateOrUpdate);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    public void updateTimeEntry(String accessToken, String xeroTenantId, UUID projectId, UUID timeEntryId, TimeEntryCreateOrUpdate timeEntryCreateOrUpdate, String idempotencyKey) throws IOException {
        try {
            this.updateTimeEntryForHttpResponse(accessToken, xeroTenantId, projectId, timeEntryId, timeEntryCreateOrUpdate, idempotencyKey);
        }
        catch (HttpResponseException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("------------------ HttpResponseException " + e.getStatusCode() + " : updateTimeEntry -------------------");
                logger.debug(e.toString());
            }
            XeroApiExceptionHandler handler = new XeroApiExceptionHandler();
            handler.execute(e);
        }
        catch (IOException ioe) {
            throw ioe;
        }
    }

    public HttpResponse updateTimeEntryForHttpResponse(String accessToken, String xeroTenantId, UUID projectId, UUID timeEntryId, TimeEntryCreateOrUpdate timeEntryCreateOrUpdate, String idempotencyKey) throws IOException {
        if (xeroTenantId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'xeroTenantId' when calling updateTimeEntry");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'projectId' when calling updateTimeEntry");
        }
        if (timeEntryId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'timeEntryId' when calling updateTimeEntry");
        }
        if (timeEntryCreateOrUpdate == null) {
            throw new IllegalArgumentException("Missing the required parameter 'timeEntryCreateOrUpdate' when calling updateTimeEntry");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("Missing the required parameter 'accessToken' when calling updateTimeEntry");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("Xero-Tenant-Id", (Object)xeroTenantId);
        headers.set("Idempotency-Key", (Object)idempotencyKey);
        headers.setAccept("application/json");
        headers.setUserAgent(this.getUserAgent());
        HashMap<String, UUID> uriVariables = new HashMap<String, UUID>();
        uriVariables.put("projectId", projectId);
        uriVariables.put("timeEntryId", timeEntryId);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)(this.apiClient.getBasePath() + "/Projects/{projectId}/Time/{timeEntryId}"));
        String url = uriBuilder.buildFromMap(uriVariables).toString();
        GenericUrl genericUrl = new GenericUrl(url);
        if (logger.isDebugEnabled()) {
            logger.debug("PUT " + genericUrl.toString());
        }
        ApiClient.JacksonJsonHttpContent content = null;
        ApiClient apiClient = this.apiClient;
        apiClient.getClass();
        content = apiClient.new ApiClient.JacksonJsonHttpContent(timeEntryCreateOrUpdate);
        Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(accessToken);
        HttpTransport transport = this.apiClient.getHttpTransport();
        HttpRequestFactory requestFactory = transport.createRequestFactory((HttpRequestInitializer)credential);
        return requestFactory.buildRequest("PUT", genericUrl, (HttpContent)content).setHeaders(headers).setConnectTimeout(this.apiClient.getConnectionTimeout()).setReadTimeout(this.apiClient.getReadTimeout()).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayInputStream convertInputToByteArray(InputStream is) throws IOException {
        byte[] bytes = IOUtils.toByteArray((InputStream)is);
        try {
            ByteArrayInputStream byteArrayInputStream;
            ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream = new ByteArrayInputStream(bytes);
            return byteArrayInputStream2;
        }
        finally {
            is.close();
        }
    }
}

