/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import com.xero.models.accounting.CreditNote;
import com.xero.models.accounting.Invoice;
import com.xero.models.accounting.Overpayment;
import com.xero.models.accounting.Prepayment;
import com.xero.models.accounting.ValidationError;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.ZoneId;

public class Allocation {
    StringUtil util = new StringUtil();
    @JsonProperty(value="AllocationID")
    private UUID allocationID;
    @JsonProperty(value="Invoice")
    private Invoice invoice;
    @JsonProperty(value="Overpayment")
    private Overpayment overpayment;
    @JsonProperty(value="Prepayment")
    private Prepayment prepayment;
    @JsonProperty(value="CreditNote")
    private CreditNote creditNote;
    @JsonProperty(value="Amount")
    private Double amount;
    @JsonProperty(value="Date")
    private String date;
    @JsonProperty(value="IsDeleted")
    private Boolean isDeleted;
    @JsonProperty(value="StatusAttributeString")
    private String statusAttributeString;
    @JsonProperty(value="ValidationErrors")
    private List<ValidationError> validationErrors = new ArrayList<ValidationError>();

    public Allocation allocationID(UUID allocationID) {
        this.allocationID = allocationID;
        return this;
    }

    @ApiModelProperty(value="Xero generated unique identifier")
    public UUID getAllocationID() {
        return this.allocationID;
    }

    public void setAllocationID(UUID allocationID) {
        this.allocationID = allocationID;
    }

    public Allocation invoice(Invoice invoice) {
        this.invoice = invoice;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Invoice getInvoice() {
        return this.invoice;
    }

    public void setInvoice(Invoice invoice) {
        this.invoice = invoice;
    }

    public Allocation overpayment(Overpayment overpayment) {
        this.overpayment = overpayment;
        return this;
    }

    @ApiModelProperty(value="")
    public Overpayment getOverpayment() {
        return this.overpayment;
    }

    public void setOverpayment(Overpayment overpayment) {
        this.overpayment = overpayment;
    }

    public Allocation prepayment(Prepayment prepayment) {
        this.prepayment = prepayment;
        return this;
    }

    @ApiModelProperty(value="")
    public Prepayment getPrepayment() {
        return this.prepayment;
    }

    public void setPrepayment(Prepayment prepayment) {
        this.prepayment = prepayment;
    }

    public Allocation creditNote(CreditNote creditNote) {
        this.creditNote = creditNote;
        return this;
    }

    @ApiModelProperty(value="")
    public CreditNote getCreditNote() {
        return this.creditNote;
    }

    public void setCreditNote(CreditNote creditNote) {
        this.creditNote = creditNote;
    }

    public Allocation amount(Double amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="the amount being applied to the invoice")
    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public Allocation date(String date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(required=true, value="the date the allocation is applied YYYY-MM-DD.")
    public String getDate() {
        return this.date;
    }

    public LocalDate getDateAsDate() {
        if (this.date != null) {
            try {
                return this.util.convertStringToDate(this.date);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public void setDate(LocalDate date) {
        Instant instant = date.atStartOfDay(ZoneId.of((String)"UTC").normalized()).toInstant();
        long timeInMillis = instant.toEpochMilli();
        this.date = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
    }

    @ApiModelProperty(value="A flag that returns true when the allocation is succesfully deleted")
    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    public Allocation statusAttributeString(String statusAttributeString) {
        this.statusAttributeString = statusAttributeString;
        return this;
    }

    @ApiModelProperty(value="A string to indicate if a invoice status")
    public String getStatusAttributeString() {
        return this.statusAttributeString;
    }

    public void setStatusAttributeString(String statusAttributeString) {
        this.statusAttributeString = statusAttributeString;
    }

    public Allocation validationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
        return this;
    }

    public Allocation addValidationErrorsItem(ValidationError validationErrorsItem) {
        if (this.validationErrors == null) {
            this.validationErrors = new ArrayList<ValidationError>();
        }
        this.validationErrors.add(validationErrorsItem);
        return this;
    }

    @ApiModelProperty(value="Displays array of validation error messages from the API")
    public List<ValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    public void setValidationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Allocation allocation = (Allocation)o;
        return Objects.equals(this.allocationID, allocation.allocationID) && Objects.equals(this.invoice, allocation.invoice) && Objects.equals(this.overpayment, allocation.overpayment) && Objects.equals(this.prepayment, allocation.prepayment) && Objects.equals(this.creditNote, allocation.creditNote) && Objects.equals(this.amount, allocation.amount) && Objects.equals(this.date, allocation.date) && Objects.equals(this.isDeleted, allocation.isDeleted) && Objects.equals(this.statusAttributeString, allocation.statusAttributeString) && Objects.equals(this.validationErrors, allocation.validationErrors);
    }

    public int hashCode() {
        return Objects.hash(this.allocationID, this.invoice, this.overpayment, this.prepayment, this.creditNote, this.amount, this.date, this.isDeleted, this.statusAttributeString, this.validationErrors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Allocation {\n");
        sb.append("    allocationID: ").append(this.toIndentedString(this.allocationID)).append("\n");
        sb.append("    invoice: ").append(this.toIndentedString(this.invoice)).append("\n");
        sb.append("    overpayment: ").append(this.toIndentedString(this.overpayment)).append("\n");
        sb.append("    prepayment: ").append(this.toIndentedString(this.prepayment)).append("\n");
        sb.append("    creditNote: ").append(this.toIndentedString(this.creditNote)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    isDeleted: ").append(this.toIndentedString(this.isDeleted)).append("\n");
        sb.append("    statusAttributeString: ").append(this.toIndentedString(this.statusAttributeString)).append("\n");
        sb.append("    validationErrors: ").append(this.toIndentedString(this.validationErrors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

