/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="An array to specify multiple currency balances of an account")
public class BalanceDetails {
    StringUtil util = new StringUtil();
    @JsonProperty(value="Balance")
    private Double balance;
    @JsonProperty(value="CurrencyCode")
    private String currencyCode;
    @JsonProperty(value="CurrencyRate")
    private Double currencyRate;

    public BalanceDetails balance(Double balance) {
        this.balance = balance;
        return this;
    }

    @ApiModelProperty(value="The opening balances of the account. Debits are positive, credits are negative values")
    public Double getBalance() {
        return this.balance;
    }

    public void setBalance(Double balance) {
        this.balance = balance;
    }

    public BalanceDetails currencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @ApiModelProperty(value="The currency of the balance (Not required for base currency)")
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public BalanceDetails currencyRate(Double currencyRate) {
        this.currencyRate = currencyRate;
        return this;
    }

    @ApiModelProperty(value="(Optional) Exchange rate to base currency when money is spent or received. If not specified, XE rate for the day is applied")
    public Double getCurrencyRate() {
        return this.currencyRate;
    }

    public void setCurrencyRate(Double currencyRate) {
        this.currencyRate = currencyRate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BalanceDetails balanceDetails = (BalanceDetails)o;
        return Objects.equals(this.balance, balanceDetails.balance) && Objects.equals(this.currencyCode, balanceDetails.currencyCode) && Objects.equals(this.currencyRate, balanceDetails.currencyRate);
    }

    public int hashCode() {
        return Objects.hash(this.balance, this.currencyCode, this.currencyRate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BalanceDetails {\n");
        sb.append("    balance: ").append(this.toIndentedString(this.balance)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        sb.append("    currencyRate: ").append(this.toIndentedString(this.currencyRate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

