/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.OffsetDateTime;

public class BrandingTheme {
    StringUtil util = new StringUtil();
    @JsonProperty(value="BrandingThemeID")
    private UUID brandingThemeID;
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="LogoUrl")
    private String logoUrl;
    @JsonProperty(value="Type")
    private TypeEnum type;
    @JsonProperty(value="SortOrder")
    private Integer sortOrder;
    @JsonProperty(value="CreatedDateUTC")
    private String createdDateUTC;

    public BrandingTheme brandingThemeID(UUID brandingThemeID) {
        this.brandingThemeID = brandingThemeID;
        return this;
    }

    @ApiModelProperty(value="Xero identifier")
    public UUID getBrandingThemeID() {
        return this.brandingThemeID;
    }

    public void setBrandingThemeID(UUID brandingThemeID) {
        this.brandingThemeID = brandingThemeID;
    }

    public BrandingTheme name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Name of branding theme")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BrandingTheme logoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
        return this;
    }

    @ApiModelProperty(value="The location of the image file used as the logo on this branding theme")
    public String getLogoUrl() {
        return this.logoUrl;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    public BrandingTheme type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="Always INVOICE")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public BrandingTheme sortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    @ApiModelProperty(value="Integer \u2013 ranked order of branding theme. The default branding theme has a value of 0")
    public Integer getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
    }

    @ApiModelProperty(example="/Date(1573755038314)/", value="UTC timestamp of creation date of branding theme")
    public String getCreatedDateUTC() {
        return this.createdDateUTC;
    }

    public OffsetDateTime getCreatedDateUTCAsDate() {
        if (this.createdDateUTC != null) {
            try {
                return this.util.convertStringToOffsetDateTime(this.createdDateUTC);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrandingTheme brandingTheme = (BrandingTheme)o;
        return Objects.equals(this.brandingThemeID, brandingTheme.brandingThemeID) && Objects.equals(this.name, brandingTheme.name) && Objects.equals(this.logoUrl, brandingTheme.logoUrl) && Objects.equals((Object)this.type, (Object)brandingTheme.type) && Objects.equals(this.sortOrder, brandingTheme.sortOrder) && Objects.equals(this.createdDateUTC, brandingTheme.createdDateUTC);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.brandingThemeID, this.name, this.logoUrl, this.type, this.sortOrder, this.createdDateUTC});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BrandingTheme {\n");
        sb.append("    brandingThemeID: ").append(this.toIndentedString(this.brandingThemeID)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    logoUrl: ").append(this.toIndentedString(this.logoUrl)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    sortOrder: ").append(this.toIndentedString(this.sortOrder)).append("\n");
        sb.append("    createdDateUTC: ").append(this.toIndentedString(this.createdDateUTC)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        INVOICE("INVOICE");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

