/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import com.xero.models.accounting.BudgetLine;
import com.xero.models.accounting.TrackingCategory;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.OffsetDateTime;

public class Budget {
    StringUtil util = new StringUtil();
    @JsonProperty(value="BudgetID")
    private UUID budgetID;
    @JsonProperty(value="Type")
    private TypeEnum type;
    @JsonProperty(value="Description")
    private String description;
    @JsonProperty(value="UpdatedDateUTC")
    private String updatedDateUTC;
    @JsonProperty(value="BudgetLines")
    private List<BudgetLine> budgetLines = new ArrayList<BudgetLine>();
    @JsonProperty(value="Tracking")
    private List<TrackingCategory> tracking = new ArrayList<TrackingCategory>();

    public Budget budgetID(UUID budgetID) {
        this.budgetID = budgetID;
        return this;
    }

    @ApiModelProperty(value="Xero identifier")
    public UUID getBudgetID() {
        return this.budgetID;
    }

    public void setBudgetID(UUID budgetID) {
        this.budgetID = budgetID;
    }

    public Budget type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="Type of Budget. OVERALL or TRACKING")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Budget description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The Budget description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ApiModelProperty(example="/Date(1573755038314)/", value="UTC timestamp of last update to budget")
    public String getUpdatedDateUTC() {
        return this.updatedDateUTC;
    }

    public OffsetDateTime getUpdatedDateUTCAsDate() {
        if (this.updatedDateUTC != null) {
            try {
                return this.util.convertStringToOffsetDateTime(this.updatedDateUTC);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Budget budgetLines(List<BudgetLine> budgetLines) {
        this.budgetLines = budgetLines;
        return this;
    }

    public Budget addBudgetLinesItem(BudgetLine budgetLinesItem) {
        if (this.budgetLines == null) {
            this.budgetLines = new ArrayList<BudgetLine>();
        }
        this.budgetLines.add(budgetLinesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<BudgetLine> getBudgetLines() {
        return this.budgetLines;
    }

    public void setBudgetLines(List<BudgetLine> budgetLines) {
        this.budgetLines = budgetLines;
    }

    public Budget tracking(List<TrackingCategory> tracking) {
        this.tracking = tracking;
        return this;
    }

    public Budget addTrackingItem(TrackingCategory trackingItem) {
        if (this.tracking == null) {
            this.tracking = new ArrayList<TrackingCategory>();
        }
        this.tracking.add(trackingItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<TrackingCategory> getTracking() {
        return this.tracking;
    }

    public void setTracking(List<TrackingCategory> tracking) {
        this.tracking = tracking;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Budget budget = (Budget)o;
        return Objects.equals(this.budgetID, budget.budgetID) && Objects.equals((Object)this.type, (Object)budget.type) && Objects.equals(this.description, budget.description) && Objects.equals(this.updatedDateUTC, budget.updatedDateUTC) && Objects.equals(this.budgetLines, budget.budgetLines) && Objects.equals(this.tracking, budget.tracking);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.budgetID, this.type, this.description, this.updatedDateUTC, this.budgetLines, this.tracking});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Budget {\n");
        sb.append("    budgetID: ").append(this.toIndentedString(this.budgetID)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    updatedDateUTC: ").append(this.toIndentedString(this.updatedDateUTC)).append("\n");
        sb.append("    budgetLines: ").append(this.toIndentedString(this.budgetLines)).append("\n");
        sb.append("    tracking: ").append(this.toIndentedString(this.tracking)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        OVERALL("OVERALL"),
        TRACKING("TRACKING");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

