/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import com.xero.models.accounting.Payment;
import com.xero.models.accounting.Receipt;
import com.xero.models.accounting.User;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;

public class ExpenseClaim {
    StringUtil util = new StringUtil();
    @JsonProperty(value="ExpenseClaimID")
    private UUID expenseClaimID;
    @JsonProperty(value="Status")
    private StatusEnum status;
    @JsonProperty(value="Payments")
    private List<Payment> payments = new ArrayList<Payment>();
    @JsonProperty(value="User")
    private User user;
    @JsonProperty(value="Receipts")
    private List<Receipt> receipts = new ArrayList<Receipt>();
    @JsonProperty(value="UpdatedDateUTC")
    private String updatedDateUTC;
    @JsonProperty(value="Total")
    private Double total;
    @JsonProperty(value="AmountDue")
    private Double amountDue;
    @JsonProperty(value="AmountPaid")
    private Double amountPaid;
    @JsonProperty(value="PaymentDueDate")
    private String paymentDueDate;
    @JsonProperty(value="ReportingDate")
    private String reportingDate;
    @JsonProperty(value="ReceiptID")
    private UUID receiptID;

    public ExpenseClaim expenseClaimID(UUID expenseClaimID) {
        this.expenseClaimID = expenseClaimID;
        return this;
    }

    @ApiModelProperty(value="Xero generated unique identifier for an expense claim")
    public UUID getExpenseClaimID() {
        return this.expenseClaimID;
    }

    public void setExpenseClaimID(UUID expenseClaimID) {
        this.expenseClaimID = expenseClaimID;
    }

    public ExpenseClaim status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="Current status of an expense claim \u2013 see status types")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public ExpenseClaim payments(List<Payment> payments) {
        this.payments = payments;
        return this;
    }

    public ExpenseClaim addPaymentsItem(Payment paymentsItem) {
        if (this.payments == null) {
            this.payments = new ArrayList<Payment>();
        }
        this.payments.add(paymentsItem);
        return this;
    }

    @ApiModelProperty(value="See Payments")
    public List<Payment> getPayments() {
        return this.payments;
    }

    public void setPayments(List<Payment> payments) {
        this.payments = payments;
    }

    public ExpenseClaim user(User user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(value="")
    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public ExpenseClaim receipts(List<Receipt> receipts) {
        this.receipts = receipts;
        return this;
    }

    public ExpenseClaim addReceiptsItem(Receipt receiptsItem) {
        if (this.receipts == null) {
            this.receipts = new ArrayList<Receipt>();
        }
        this.receipts.add(receiptsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<Receipt> getReceipts() {
        return this.receipts;
    }

    public void setReceipts(List<Receipt> receipts) {
        this.receipts = receipts;
    }

    @ApiModelProperty(example="/Date(1573755038314)/", value="Last modified date UTC format")
    public String getUpdatedDateUTC() {
        return this.updatedDateUTC;
    }

    public OffsetDateTime getUpdatedDateUTCAsDate() {
        if (this.updatedDateUTC != null) {
            try {
                return this.util.convertStringToOffsetDateTime(this.updatedDateUTC);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @ApiModelProperty(value="The total of an expense claim being paid")
    public Double getTotal() {
        return this.total;
    }

    @ApiModelProperty(value="The amount due to be paid for an expense claim")
    public Double getAmountDue() {
        return this.amountDue;
    }

    @ApiModelProperty(value="The amount still to pay for an expense claim")
    public Double getAmountPaid() {
        return this.amountPaid;
    }

    @ApiModelProperty(value="The date when the expense claim is due to be paid YYYY-MM-DD")
    public String getPaymentDueDate() {
        return this.paymentDueDate;
    }

    public LocalDate getPaymentDueDateAsDate() {
        if (this.paymentDueDate != null) {
            try {
                return this.util.convertStringToDate(this.paymentDueDate);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @ApiModelProperty(value="The date the expense claim will be reported in Xero YYYY-MM-DD")
    public String getReportingDate() {
        return this.reportingDate;
    }

    public LocalDate getReportingDateAsDate() {
        if (this.reportingDate != null) {
            try {
                return this.util.convertStringToDate(this.reportingDate);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public ExpenseClaim receiptID(UUID receiptID) {
        this.receiptID = receiptID;
        return this;
    }

    @ApiModelProperty(value="The Xero identifier for the Receipt e.g. e59a2c7f-1306-4078-a0f3-73537afcbba9")
    public UUID getReceiptID() {
        return this.receiptID;
    }

    public void setReceiptID(UUID receiptID) {
        this.receiptID = receiptID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpenseClaim expenseClaim = (ExpenseClaim)o;
        return Objects.equals(this.expenseClaimID, expenseClaim.expenseClaimID) && Objects.equals((Object)this.status, (Object)expenseClaim.status) && Objects.equals(this.payments, expenseClaim.payments) && Objects.equals(this.user, expenseClaim.user) && Objects.equals(this.receipts, expenseClaim.receipts) && Objects.equals(this.updatedDateUTC, expenseClaim.updatedDateUTC) && Objects.equals(this.total, expenseClaim.total) && Objects.equals(this.amountDue, expenseClaim.amountDue) && Objects.equals(this.amountPaid, expenseClaim.amountPaid) && Objects.equals(this.paymentDueDate, expenseClaim.paymentDueDate) && Objects.equals(this.reportingDate, expenseClaim.reportingDate) && Objects.equals(this.receiptID, expenseClaim.receiptID);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.expenseClaimID, this.status, this.payments, this.user, this.receipts, this.updatedDateUTC, this.total, this.amountDue, this.amountPaid, this.paymentDueDate, this.reportingDate, this.receiptID});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExpenseClaim {\n");
        sb.append("    expenseClaimID: ").append(this.toIndentedString(this.expenseClaimID)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    payments: ").append(this.toIndentedString(this.payments)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    receipts: ").append(this.toIndentedString(this.receipts)).append("\n");
        sb.append("    updatedDateUTC: ").append(this.toIndentedString(this.updatedDateUTC)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("    amountDue: ").append(this.toIndentedString(this.amountDue)).append("\n");
        sb.append("    amountPaid: ").append(this.toIndentedString(this.amountPaid)).append("\n");
        sb.append("    paymentDueDate: ").append(this.toIndentedString(this.paymentDueDate)).append("\n");
        sb.append("    reportingDate: ").append(this.toIndentedString(this.reportingDate)).append("\n");
        sb.append("    receiptID: ").append(this.toIndentedString(this.receiptID)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        SUBMITTED("SUBMITTED"),
        AUTHORISED("AUTHORISED"),
        PAID("PAID"),
        VOIDED("VOIDED"),
        DELETED("DELETED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

