/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import com.xero.models.accounting.LineItemItem;
import com.xero.models.accounting.LineItemTracking;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class LineItem {
    StringUtil util = new StringUtil();
    @JsonProperty(value="LineItemID")
    private UUID lineItemID;
    @JsonProperty(value="Description")
    private String description;
    @JsonProperty(value="Quantity")
    private Double quantity;
    @JsonProperty(value="UnitAmount")
    private Double unitAmount;
    @JsonProperty(value="ItemCode")
    private String itemCode;
    @JsonProperty(value="AccountCode")
    private String accountCode;
    @JsonProperty(value="AccountID")
    private UUID accountID;
    @JsonProperty(value="TaxType")
    private String taxType;
    @JsonProperty(value="TaxAmount")
    private Double taxAmount;
    @JsonProperty(value="Item")
    private LineItemItem item;
    @JsonProperty(value="LineAmount")
    private Double lineAmount;
    @JsonProperty(value="Tracking")
    private List<LineItemTracking> tracking = new ArrayList<LineItemTracking>();
    @JsonProperty(value="DiscountRate")
    private Double discountRate;
    @JsonProperty(value="DiscountAmount")
    private Double discountAmount;
    @JsonProperty(value="RepeatingInvoiceID")
    private UUID repeatingInvoiceID;

    public LineItem lineItemID(UUID lineItemID) {
        this.lineItemID = lineItemID;
        return this;
    }

    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", value="LineItem unique ID")
    public UUID getLineItemID() {
        return this.lineItemID;
    }

    public void setLineItemID(UUID lineItemID) {
        this.lineItemID = lineItemID;
    }

    public LineItem description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Description needs to be at least 1 char long. A line item with just a description (i.e no unit amount or quantity) can be created by specifying just a <Description> element that contains at least 1 character")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public LineItem quantity(Double quantity) {
        this.quantity = quantity;
        return this;
    }

    @ApiModelProperty(value="LineItem Quantity")
    public Double getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Double quantity) {
        this.quantity = quantity;
    }

    public LineItem unitAmount(Double unitAmount) {
        this.unitAmount = unitAmount;
        return this;
    }

    @ApiModelProperty(value="LineItem Unit Amount")
    public Double getUnitAmount() {
        return this.unitAmount;
    }

    public void setUnitAmount(Double unitAmount) {
        this.unitAmount = unitAmount;
    }

    public LineItem itemCode(String itemCode) {
        this.itemCode = itemCode;
        return this;
    }

    @ApiModelProperty(value="See Items")
    public String getItemCode() {
        return this.itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public LineItem accountCode(String accountCode) {
        this.accountCode = accountCode;
        return this;
    }

    @ApiModelProperty(value="See Accounts")
    public String getAccountCode() {
        return this.accountCode;
    }

    public void setAccountCode(String accountCode) {
        this.accountCode = accountCode;
    }

    public LineItem accountID(UUID accountID) {
        this.accountID = accountID;
        return this;
    }

    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", value="The associated account ID related to this line item")
    public UUID getAccountID() {
        return this.accountID;
    }

    public void setAccountID(UUID accountID) {
        this.accountID = accountID;
    }

    public LineItem taxType(String taxType) {
        this.taxType = taxType;
        return this;
    }

    @ApiModelProperty(value="The tax type from TaxRates")
    public String getTaxType() {
        return this.taxType;
    }

    public void setTaxType(String taxType) {
        this.taxType = taxType;
    }

    public LineItem taxAmount(Double taxAmount) {
        this.taxAmount = taxAmount;
        return this;
    }

    @ApiModelProperty(value="The tax amount is auto calculated as a percentage of the line amount (see below) based on the tax rate. This value can be overriden if the calculated <TaxAmount> is not correct.")
    public Double getTaxAmount() {
        return this.taxAmount;
    }

    public void setTaxAmount(Double taxAmount) {
        this.taxAmount = taxAmount;
    }

    public LineItem item(LineItemItem item) {
        this.item = item;
        return this;
    }

    @ApiModelProperty(value="")
    public LineItemItem getItem() {
        return this.item;
    }

    public void setItem(LineItemItem item) {
        this.item = item;
    }

    public LineItem lineAmount(Double lineAmount) {
        this.lineAmount = lineAmount;
        return this;
    }

    @ApiModelProperty(value="If you wish to omit either the Quantity or UnitAmount you can provide a LineAmount and Xero will calculate the missing amount for you. The line amount reflects the discounted price if either a DiscountRate or DiscountAmount has been used i.e. LineAmount = Quantity * Unit Amount * ((100 - DiscountRate)/100) or LineAmount = (Quantity * UnitAmount) - DiscountAmount")
    public Double getLineAmount() {
        return this.lineAmount;
    }

    public void setLineAmount(Double lineAmount) {
        this.lineAmount = lineAmount;
    }

    public LineItem tracking(List<LineItemTracking> tracking) {
        this.tracking = tracking;
        return this;
    }

    public LineItem addTrackingItem(LineItemTracking trackingItem) {
        if (this.tracking == null) {
            this.tracking = new ArrayList<LineItemTracking>();
        }
        this.tracking.add(trackingItem);
        return this;
    }

    @ApiModelProperty(value="Optional Tracking Category \u2013 see Tracking.  Any LineItem can have a  maximum of 2 <TrackingCategory> elements.")
    public List<LineItemTracking> getTracking() {
        return this.tracking;
    }

    public void setTracking(List<LineItemTracking> tracking) {
        this.tracking = tracking;
    }

    public LineItem discountRate(Double discountRate) {
        this.discountRate = discountRate;
        return this;
    }

    @ApiModelProperty(value="Percentage discount being applied to a line item (only supported on  ACCREC invoices \u2013 ACC PAY invoices and credit notes in Xero do not support discounts")
    public Double getDiscountRate() {
        return this.discountRate;
    }

    public void setDiscountRate(Double discountRate) {
        this.discountRate = discountRate;
    }

    public LineItem discountAmount(Double discountAmount) {
        this.discountAmount = discountAmount;
        return this;
    }

    @ApiModelProperty(value="Discount amount being applied to a line item. Only supported on ACCREC invoices and quotes. ACCPAY invoices and credit notes in Xero do not support discounts.")
    public Double getDiscountAmount() {
        return this.discountAmount;
    }

    public void setDiscountAmount(Double discountAmount) {
        this.discountAmount = discountAmount;
    }

    public LineItem repeatingInvoiceID(UUID repeatingInvoiceID) {
        this.repeatingInvoiceID = repeatingInvoiceID;
        return this;
    }

    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", value="The Xero identifier for a Repeating Invoice")
    public UUID getRepeatingInvoiceID() {
        return this.repeatingInvoiceID;
    }

    public void setRepeatingInvoiceID(UUID repeatingInvoiceID) {
        this.repeatingInvoiceID = repeatingInvoiceID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LineItem lineItem = (LineItem)o;
        return Objects.equals(this.lineItemID, lineItem.lineItemID) && Objects.equals(this.description, lineItem.description) && Objects.equals(this.quantity, lineItem.quantity) && Objects.equals(this.unitAmount, lineItem.unitAmount) && Objects.equals(this.itemCode, lineItem.itemCode) && Objects.equals(this.accountCode, lineItem.accountCode) && Objects.equals(this.accountID, lineItem.accountID) && Objects.equals(this.taxType, lineItem.taxType) && Objects.equals(this.taxAmount, lineItem.taxAmount) && Objects.equals(this.item, lineItem.item) && Objects.equals(this.lineAmount, lineItem.lineAmount) && Objects.equals(this.tracking, lineItem.tracking) && Objects.equals(this.discountRate, lineItem.discountRate) && Objects.equals(this.discountAmount, lineItem.discountAmount) && Objects.equals(this.repeatingInvoiceID, lineItem.repeatingInvoiceID);
    }

    public int hashCode() {
        return Objects.hash(this.lineItemID, this.description, this.quantity, this.unitAmount, this.itemCode, this.accountCode, this.accountID, this.taxType, this.taxAmount, this.item, this.lineAmount, this.tracking, this.discountRate, this.discountAmount, this.repeatingInvoiceID);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LineItem {\n");
        sb.append("    lineItemID: ").append(this.toIndentedString(this.lineItemID)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    unitAmount: ").append(this.toIndentedString(this.unitAmount)).append("\n");
        sb.append("    itemCode: ").append(this.toIndentedString(this.itemCode)).append("\n");
        sb.append("    accountCode: ").append(this.toIndentedString(this.accountCode)).append("\n");
        sb.append("    accountID: ").append(this.toIndentedString(this.accountID)).append("\n");
        sb.append("    taxType: ").append(this.toIndentedString(this.taxType)).append("\n");
        sb.append("    taxAmount: ").append(this.toIndentedString(this.taxAmount)).append("\n");
        sb.append("    item: ").append(this.toIndentedString(this.item)).append("\n");
        sb.append("    lineAmount: ").append(this.toIndentedString(this.lineAmount)).append("\n");
        sb.append("    tracking: ").append(this.toIndentedString(this.tracking)).append("\n");
        sb.append("    discountRate: ").append(this.toIndentedString(this.discountRate)).append("\n");
        sb.append("    discountAmount: ").append(this.toIndentedString(this.discountAmount)).append("\n");
        sb.append("    repeatingInvoiceID: ").append(this.toIndentedString(this.repeatingInvoiceID)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

