/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import com.xero.models.accounting.Allocation;
import com.xero.models.accounting.Attachment;
import com.xero.models.accounting.Contact;
import com.xero.models.accounting.CurrencyCode;
import com.xero.models.accounting.LineAmountTypes;
import com.xero.models.accounting.LineItem;
import com.xero.models.accounting.Payment;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.ZoneId;

public class Prepayment {
    StringUtil util = new StringUtil();
    @JsonProperty(value="Type")
    private TypeEnum type;
    @JsonProperty(value="Contact")
    private Contact contact;
    @JsonProperty(value="Date")
    private String date;
    @JsonProperty(value="Status")
    private StatusEnum status;
    @JsonProperty(value="LineAmountTypes")
    private LineAmountTypes lineAmountTypes;
    @JsonProperty(value="LineItems")
    private List<LineItem> lineItems = new ArrayList<LineItem>();
    @JsonProperty(value="SubTotal")
    private Double subTotal;
    @JsonProperty(value="TotalTax")
    private Double totalTax;
    @JsonProperty(value="Total")
    private Double total;
    @JsonProperty(value="Reference")
    private String reference;
    @JsonProperty(value="UpdatedDateUTC")
    private String updatedDateUTC;
    @JsonProperty(value="CurrencyCode")
    private CurrencyCode currencyCode;
    @JsonProperty(value="PrepaymentID")
    private UUID prepaymentID;
    @JsonProperty(value="CurrencyRate")
    private Double currencyRate;
    @JsonProperty(value="RemainingCredit")
    private Double remainingCredit;
    @JsonProperty(value="Allocations")
    private List<Allocation> allocations = new ArrayList<Allocation>();
    @JsonProperty(value="Payments")
    private List<Payment> payments = new ArrayList<Payment>();
    @JsonProperty(value="AppliedAmount")
    private Double appliedAmount;
    @JsonProperty(value="HasAttachments")
    private Boolean hasAttachments = false;
    @JsonProperty(value="Attachments")
    private List<Attachment> attachments = new ArrayList<Attachment>();

    public Prepayment type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="See Prepayment Types")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Prepayment contact(Contact contact) {
        this.contact = contact;
        return this;
    }

    @ApiModelProperty(value="")
    public Contact getContact() {
        return this.contact;
    }

    public void setContact(Contact contact) {
        this.contact = contact;
    }

    public Prepayment date(String date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(value="The date the prepayment is created YYYY-MM-DD")
    public String getDate() {
        return this.date;
    }

    public LocalDate getDateAsDate() {
        if (this.date != null) {
            try {
                return this.util.convertStringToDate(this.date);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public void setDate(LocalDate date) {
        Instant instant = date.atStartOfDay(ZoneId.of((String)"UTC").normalized()).toInstant();
        long timeInMillis = instant.toEpochMilli();
        this.date = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
    }

    public Prepayment status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="See Prepayment Status Codes")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Prepayment lineAmountTypes(LineAmountTypes lineAmountTypes) {
        this.lineAmountTypes = lineAmountTypes;
        return this;
    }

    @ApiModelProperty(value="")
    public LineAmountTypes getLineAmountTypes() {
        return this.lineAmountTypes;
    }

    public void setLineAmountTypes(LineAmountTypes lineAmountTypes) {
        this.lineAmountTypes = lineAmountTypes;
    }

    public Prepayment lineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
        return this;
    }

    public Prepayment addLineItemsItem(LineItem lineItemsItem) {
        if (this.lineItems == null) {
            this.lineItems = new ArrayList<LineItem>();
        }
        this.lineItems.add(lineItemsItem);
        return this;
    }

    @ApiModelProperty(value="See Prepayment Line Items")
    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    public void setLineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
    }

    public Prepayment subTotal(Double subTotal) {
        this.subTotal = subTotal;
        return this;
    }

    @ApiModelProperty(value="The subtotal of the prepayment excluding taxes")
    public Double getSubTotal() {
        return this.subTotal;
    }

    public void setSubTotal(Double subTotal) {
        this.subTotal = subTotal;
    }

    public Prepayment totalTax(Double totalTax) {
        this.totalTax = totalTax;
        return this;
    }

    @ApiModelProperty(value="The total tax on the prepayment")
    public Double getTotalTax() {
        return this.totalTax;
    }

    public void setTotalTax(Double totalTax) {
        this.totalTax = totalTax;
    }

    public Prepayment total(Double total) {
        this.total = total;
        return this;
    }

    @ApiModelProperty(value="The total of the prepayment(subtotal + total tax)")
    public Double getTotal() {
        return this.total;
    }

    public void setTotal(Double total) {
        this.total = total;
    }

    @ApiModelProperty(value="Returns Invoice number field. Reference field isn't available.")
    public String getReference() {
        return this.reference;
    }

    @ApiModelProperty(example="/Date(1573755038314)/", value="UTC timestamp of last update to the prepayment")
    public String getUpdatedDateUTC() {
        return this.updatedDateUTC;
    }

    public OffsetDateTime getUpdatedDateUTCAsDate() {
        if (this.updatedDateUTC != null) {
            try {
                return this.util.convertStringToOffsetDateTime(this.updatedDateUTC);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Prepayment currencyCode(CurrencyCode currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @ApiModelProperty(value="")
    public CurrencyCode getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(CurrencyCode currencyCode) {
        this.currencyCode = currencyCode;
    }

    public Prepayment prepaymentID(UUID prepaymentID) {
        this.prepaymentID = prepaymentID;
        return this;
    }

    @ApiModelProperty(value="Xero generated unique identifier")
    public UUID getPrepaymentID() {
        return this.prepaymentID;
    }

    public void setPrepaymentID(UUID prepaymentID) {
        this.prepaymentID = prepaymentID;
    }

    public Prepayment currencyRate(Double currencyRate) {
        this.currencyRate = currencyRate;
        return this;
    }

    @ApiModelProperty(value="The currency rate for a multicurrency prepayment. If no rate is specified, the XE.com day rate is used")
    public Double getCurrencyRate() {
        return this.currencyRate;
    }

    public void setCurrencyRate(Double currencyRate) {
        this.currencyRate = currencyRate;
    }

    public Prepayment remainingCredit(Double remainingCredit) {
        this.remainingCredit = remainingCredit;
        return this;
    }

    @ApiModelProperty(value="The remaining credit balance on the prepayment")
    public Double getRemainingCredit() {
        return this.remainingCredit;
    }

    public void setRemainingCredit(Double remainingCredit) {
        this.remainingCredit = remainingCredit;
    }

    public Prepayment allocations(List<Allocation> allocations) {
        this.allocations = allocations;
        return this;
    }

    public Prepayment addAllocationsItem(Allocation allocationsItem) {
        if (this.allocations == null) {
            this.allocations = new ArrayList<Allocation>();
        }
        this.allocations.add(allocationsItem);
        return this;
    }

    @ApiModelProperty(value="See Allocations")
    public List<Allocation> getAllocations() {
        return this.allocations;
    }

    public void setAllocations(List<Allocation> allocations) {
        this.allocations = allocations;
    }

    public Prepayment payments(List<Payment> payments) {
        this.payments = payments;
        return this;
    }

    public Prepayment addPaymentsItem(Payment paymentsItem) {
        if (this.payments == null) {
            this.payments = new ArrayList<Payment>();
        }
        this.payments.add(paymentsItem);
        return this;
    }

    @ApiModelProperty(value="See Payments")
    public List<Payment> getPayments() {
        return this.payments;
    }

    public void setPayments(List<Payment> payments) {
        this.payments = payments;
    }

    public Prepayment appliedAmount(Double appliedAmount) {
        this.appliedAmount = appliedAmount;
        return this;
    }

    @ApiModelProperty(example="2.0", value="The amount of applied to an invoice")
    public Double getAppliedAmount() {
        return this.appliedAmount;
    }

    public void setAppliedAmount(Double appliedAmount) {
        this.appliedAmount = appliedAmount;
    }

    @ApiModelProperty(example="false", value="boolean to indicate if a prepayment has an attachment")
    public Boolean getHasAttachments() {
        return this.hasAttachments;
    }

    public Prepayment attachments(List<Attachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    public Prepayment addAttachmentsItem(Attachment attachmentsItem) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<Attachment>();
        }
        this.attachments.add(attachmentsItem);
        return this;
    }

    @ApiModelProperty(value="See Attachments")
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Prepayment prepayment = (Prepayment)o;
        return Objects.equals((Object)this.type, (Object)prepayment.type) && Objects.equals(this.contact, prepayment.contact) && Objects.equals(this.date, prepayment.date) && Objects.equals((Object)this.status, (Object)prepayment.status) && Objects.equals((Object)this.lineAmountTypes, (Object)prepayment.lineAmountTypes) && Objects.equals(this.lineItems, prepayment.lineItems) && Objects.equals(this.subTotal, prepayment.subTotal) && Objects.equals(this.totalTax, prepayment.totalTax) && Objects.equals(this.total, prepayment.total) && Objects.equals(this.reference, prepayment.reference) && Objects.equals(this.updatedDateUTC, prepayment.updatedDateUTC) && Objects.equals((Object)this.currencyCode, (Object)prepayment.currencyCode) && Objects.equals(this.prepaymentID, prepayment.prepaymentID) && Objects.equals(this.currencyRate, prepayment.currencyRate) && Objects.equals(this.remainingCredit, prepayment.remainingCredit) && Objects.equals(this.allocations, prepayment.allocations) && Objects.equals(this.payments, prepayment.payments) && Objects.equals(this.appliedAmount, prepayment.appliedAmount) && Objects.equals(this.hasAttachments, prepayment.hasAttachments) && Objects.equals(this.attachments, prepayment.attachments);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.contact, this.date, this.status, this.lineAmountTypes, this.lineItems, this.subTotal, this.totalTax, this.total, this.reference, this.updatedDateUTC, this.currencyCode, this.prepaymentID, this.currencyRate, this.remainingCredit, this.allocations, this.payments, this.appliedAmount, this.hasAttachments, this.attachments});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Prepayment {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    lineAmountTypes: ").append(this.toIndentedString((Object)this.lineAmountTypes)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    subTotal: ").append(this.toIndentedString(this.subTotal)).append("\n");
        sb.append("    totalTax: ").append(this.toIndentedString(this.totalTax)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    updatedDateUTC: ").append(this.toIndentedString(this.updatedDateUTC)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString((Object)this.currencyCode)).append("\n");
        sb.append("    prepaymentID: ").append(this.toIndentedString(this.prepaymentID)).append("\n");
        sb.append("    currencyRate: ").append(this.toIndentedString(this.currencyRate)).append("\n");
        sb.append("    remainingCredit: ").append(this.toIndentedString(this.remainingCredit)).append("\n");
        sb.append("    allocations: ").append(this.toIndentedString(this.allocations)).append("\n");
        sb.append("    payments: ").append(this.toIndentedString(this.payments)).append("\n");
        sb.append("    appliedAmount: ").append(this.toIndentedString(this.appliedAmount)).append("\n");
        sb.append("    hasAttachments: ").append(this.toIndentedString(this.hasAttachments)).append("\n");
        sb.append("    attachments: ").append(this.toIndentedString(this.attachments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        AUTHORISED("AUTHORISED"),
        PAID("PAID"),
        VOIDED("VOIDED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        RECEIVE_PREPAYMENT("RECEIVE-PREPAYMENT"),
        SPEND_PREPAYMENT("SPEND-PREPAYMENT"),
        ARPREPAYMENT("ARPREPAYMENT"),
        APPREPAYMENT("APPREPAYMENT");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

