/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import com.xero.models.accounting.Contact;
import com.xero.models.accounting.CurrencyCode;
import com.xero.models.accounting.LineItem;
import com.xero.models.accounting.QuoteLineAmountTypes;
import com.xero.models.accounting.QuoteStatusCodes;
import com.xero.models.accounting.ValidationError;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.ZoneId;

public class Quote {
    StringUtil util = new StringUtil();
    @JsonProperty(value="QuoteID")
    private UUID quoteID;
    @JsonProperty(value="QuoteNumber")
    private String quoteNumber;
    @JsonProperty(value="Reference")
    private String reference;
    @JsonProperty(value="Terms")
    private String terms;
    @JsonProperty(value="Contact")
    private Contact contact;
    @JsonProperty(value="LineItems")
    private List<LineItem> lineItems = new ArrayList<LineItem>();
    @JsonProperty(value="Date")
    private String date;
    @JsonProperty(value="DateString")
    private String dateString;
    @JsonProperty(value="ExpiryDate")
    private String expiryDate;
    @JsonProperty(value="ExpiryDateString")
    private String expiryDateString;
    @JsonProperty(value="Status")
    private QuoteStatusCodes status;
    @JsonProperty(value="CurrencyCode")
    private CurrencyCode currencyCode;
    @JsonProperty(value="CurrencyRate")
    private Double currencyRate;
    @JsonProperty(value="SubTotal")
    private Double subTotal;
    @JsonProperty(value="TotalTax")
    private Double totalTax;
    @JsonProperty(value="Total")
    private Double total;
    @JsonProperty(value="TotalDiscount")
    private Double totalDiscount;
    @JsonProperty(value="Title")
    private String title;
    @JsonProperty(value="Summary")
    private String summary;
    @JsonProperty(value="BrandingThemeID")
    private UUID brandingThemeID;
    @JsonProperty(value="UpdatedDateUTC")
    private String updatedDateUTC;
    @JsonProperty(value="LineAmountTypes")
    private QuoteLineAmountTypes lineAmountTypes;
    @JsonProperty(value="StatusAttributeString")
    private String statusAttributeString;
    @JsonProperty(value="ValidationErrors")
    private List<ValidationError> validationErrors = new ArrayList<ValidationError>();

    public Quote quoteID(UUID quoteID) {
        this.quoteID = quoteID;
        return this;
    }

    @ApiModelProperty(value="QuoteID GUID is automatically generated and is returned after create or GET.")
    public UUID getQuoteID() {
        return this.quoteID;
    }

    public void setQuoteID(UUID quoteID) {
        this.quoteID = quoteID;
    }

    public Quote quoteNumber(String quoteNumber) {
        this.quoteNumber = quoteNumber;
        return this;
    }

    @ApiModelProperty(value="Unique alpha numeric code identifying a quote (Max Length = 255)")
    public String getQuoteNumber() {
        return this.quoteNumber;
    }

    public void setQuoteNumber(String quoteNumber) {
        this.quoteNumber = quoteNumber;
    }

    public Quote reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Additional reference number")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public Quote terms(String terms) {
        this.terms = terms;
        return this;
    }

    @ApiModelProperty(value="Terms of the quote")
    public String getTerms() {
        return this.terms;
    }

    public void setTerms(String terms) {
        this.terms = terms;
    }

    public Quote contact(Contact contact) {
        this.contact = contact;
        return this;
    }

    @ApiModelProperty(value="")
    public Contact getContact() {
        return this.contact;
    }

    public void setContact(Contact contact) {
        this.contact = contact;
    }

    public Quote lineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
        return this;
    }

    public Quote addLineItemsItem(LineItem lineItemsItem) {
        if (this.lineItems == null) {
            this.lineItems = new ArrayList<LineItem>();
        }
        this.lineItems.add(lineItemsItem);
        return this;
    }

    @ApiModelProperty(value="See LineItems")
    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    public void setLineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
    }

    public Quote date(String date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(value="Date quote was issued \u2013 YYYY-MM-DD. If the Date element is not specified it will default to the current date based on the timezone setting of the organisation")
    public String getDate() {
        return this.date;
    }

    public LocalDate getDateAsDate() {
        if (this.date != null) {
            try {
                return this.util.convertStringToDate(this.date);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public void setDate(LocalDate date) {
        Instant instant = date.atStartOfDay(ZoneId.of((String)"UTC").normalized()).toInstant();
        long timeInMillis = instant.toEpochMilli();
        this.date = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
    }

    public Quote dateString(String dateString) {
        this.dateString = dateString;
        return this;
    }

    @ApiModelProperty(value="Date the quote was issued (YYYY-MM-DD)")
    public String getDateString() {
        return this.dateString;
    }

    public void setDateString(String dateString) {
        this.dateString = dateString;
    }

    public Quote expiryDate(String expiryDate) {
        this.expiryDate = expiryDate;
        return this;
    }

    @ApiModelProperty(value="Date the quote expires \u2013 YYYY-MM-DD.")
    public String getExpiryDate() {
        return this.expiryDate;
    }

    public LocalDate getExpiryDateAsDate() {
        if (this.expiryDate != null) {
            try {
                return this.util.convertStringToDate(this.expiryDate);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setExpiryDate(String expiryDate) {
        this.expiryDate = expiryDate;
    }

    public void setExpiryDate(LocalDate expiryDate) {
        Instant instant = expiryDate.atStartOfDay(ZoneId.of((String)"UTC").normalized()).toInstant();
        long timeInMillis = instant.toEpochMilli();
        this.expiryDate = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
    }

    public Quote expiryDateString(String expiryDateString) {
        this.expiryDateString = expiryDateString;
        return this;
    }

    @ApiModelProperty(value="Date the quote expires \u2013 YYYY-MM-DD.")
    public String getExpiryDateString() {
        return this.expiryDateString;
    }

    public void setExpiryDateString(String expiryDateString) {
        this.expiryDateString = expiryDateString;
    }

    public Quote status(QuoteStatusCodes status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="")
    public QuoteStatusCodes getStatus() {
        return this.status;
    }

    public void setStatus(QuoteStatusCodes status) {
        this.status = status;
    }

    public Quote currencyCode(CurrencyCode currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @ApiModelProperty(value="")
    public CurrencyCode getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(CurrencyCode currencyCode) {
        this.currencyCode = currencyCode;
    }

    public Quote currencyRate(Double currencyRate) {
        this.currencyRate = currencyRate;
        return this;
    }

    @ApiModelProperty(value="The currency rate for a multicurrency quote")
    public Double getCurrencyRate() {
        return this.currencyRate;
    }

    public void setCurrencyRate(Double currencyRate) {
        this.currencyRate = currencyRate;
    }

    @ApiModelProperty(value="Total of quote excluding taxes.")
    public Double getSubTotal() {
        return this.subTotal;
    }

    @ApiModelProperty(value="Total tax on quote")
    public Double getTotalTax() {
        return this.totalTax;
    }

    @ApiModelProperty(value="Total of Quote tax inclusive (i.e. SubTotal + TotalTax). This will be ignored if it doesn\u2019t equal the sum of the LineAmounts")
    public Double getTotal() {
        return this.total;
    }

    @ApiModelProperty(value="Total of discounts applied on the quote line items")
    public Double getTotalDiscount() {
        return this.totalDiscount;
    }

    public Quote title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(value="Title text for the quote")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Quote summary(String summary) {
        this.summary = summary;
        return this;
    }

    @ApiModelProperty(value="Summary text for the quote")
    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public Quote brandingThemeID(UUID brandingThemeID) {
        this.brandingThemeID = brandingThemeID;
        return this;
    }

    @ApiModelProperty(value="See BrandingThemes")
    public UUID getBrandingThemeID() {
        return this.brandingThemeID;
    }

    public void setBrandingThemeID(UUID brandingThemeID) {
        this.brandingThemeID = brandingThemeID;
    }

    @ApiModelProperty(example="/Date(1573755038314)/", value="Last modified date UTC format")
    public String getUpdatedDateUTC() {
        return this.updatedDateUTC;
    }

    public OffsetDateTime getUpdatedDateUTCAsDate() {
        if (this.updatedDateUTC != null) {
            try {
                return this.util.convertStringToOffsetDateTime(this.updatedDateUTC);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Quote lineAmountTypes(QuoteLineAmountTypes lineAmountTypes) {
        this.lineAmountTypes = lineAmountTypes;
        return this;
    }

    @ApiModelProperty(value="")
    public QuoteLineAmountTypes getLineAmountTypes() {
        return this.lineAmountTypes;
    }

    public void setLineAmountTypes(QuoteLineAmountTypes lineAmountTypes) {
        this.lineAmountTypes = lineAmountTypes;
    }

    public Quote statusAttributeString(String statusAttributeString) {
        this.statusAttributeString = statusAttributeString;
        return this;
    }

    @ApiModelProperty(value="A string to indicate if a invoice status")
    public String getStatusAttributeString() {
        return this.statusAttributeString;
    }

    public void setStatusAttributeString(String statusAttributeString) {
        this.statusAttributeString = statusAttributeString;
    }

    public Quote validationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
        return this;
    }

    public Quote addValidationErrorsItem(ValidationError validationErrorsItem) {
        if (this.validationErrors == null) {
            this.validationErrors = new ArrayList<ValidationError>();
        }
        this.validationErrors.add(validationErrorsItem);
        return this;
    }

    @ApiModelProperty(value="Displays array of validation error messages from the API")
    public List<ValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    public void setValidationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Quote quote = (Quote)o;
        return Objects.equals(this.quoteID, quote.quoteID) && Objects.equals(this.quoteNumber, quote.quoteNumber) && Objects.equals(this.reference, quote.reference) && Objects.equals(this.terms, quote.terms) && Objects.equals(this.contact, quote.contact) && Objects.equals(this.lineItems, quote.lineItems) && Objects.equals(this.date, quote.date) && Objects.equals(this.dateString, quote.dateString) && Objects.equals(this.expiryDate, quote.expiryDate) && Objects.equals(this.expiryDateString, quote.expiryDateString) && Objects.equals((Object)this.status, (Object)quote.status) && Objects.equals((Object)this.currencyCode, (Object)quote.currencyCode) && Objects.equals(this.currencyRate, quote.currencyRate) && Objects.equals(this.subTotal, quote.subTotal) && Objects.equals(this.totalTax, quote.totalTax) && Objects.equals(this.total, quote.total) && Objects.equals(this.totalDiscount, quote.totalDiscount) && Objects.equals(this.title, quote.title) && Objects.equals(this.summary, quote.summary) && Objects.equals(this.brandingThemeID, quote.brandingThemeID) && Objects.equals(this.updatedDateUTC, quote.updatedDateUTC) && Objects.equals((Object)this.lineAmountTypes, (Object)quote.lineAmountTypes) && Objects.equals(this.statusAttributeString, quote.statusAttributeString) && Objects.equals(this.validationErrors, quote.validationErrors);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.quoteID, this.quoteNumber, this.reference, this.terms, this.contact, this.lineItems, this.date, this.dateString, this.expiryDate, this.expiryDateString, this.status, this.currencyCode, this.currencyRate, this.subTotal, this.totalTax, this.total, this.totalDiscount, this.title, this.summary, this.brandingThemeID, this.updatedDateUTC, this.lineAmountTypes, this.statusAttributeString, this.validationErrors});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Quote {\n");
        sb.append("    quoteID: ").append(this.toIndentedString(this.quoteID)).append("\n");
        sb.append("    quoteNumber: ").append(this.toIndentedString(this.quoteNumber)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    terms: ").append(this.toIndentedString(this.terms)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    dateString: ").append(this.toIndentedString(this.dateString)).append("\n");
        sb.append("    expiryDate: ").append(this.toIndentedString(this.expiryDate)).append("\n");
        sb.append("    expiryDateString: ").append(this.toIndentedString(this.expiryDateString)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    currencyCode: ").append(this.toIndentedString((Object)this.currencyCode)).append("\n");
        sb.append("    currencyRate: ").append(this.toIndentedString(this.currencyRate)).append("\n");
        sb.append("    subTotal: ").append(this.toIndentedString(this.subTotal)).append("\n");
        sb.append("    totalTax: ").append(this.toIndentedString(this.totalTax)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("    totalDiscount: ").append(this.toIndentedString(this.totalDiscount)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    summary: ").append(this.toIndentedString(this.summary)).append("\n");
        sb.append("    brandingThemeID: ").append(this.toIndentedString(this.brandingThemeID)).append("\n");
        sb.append("    updatedDateUTC: ").append(this.toIndentedString(this.updatedDateUTC)).append("\n");
        sb.append("    lineAmountTypes: ").append(this.toIndentedString((Object)this.lineAmountTypes)).append("\n");
        sb.append("    statusAttributeString: ").append(this.toIndentedString(this.statusAttributeString)).append("\n");
        sb.append("    validationErrors: ").append(this.toIndentedString(this.validationErrors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

