/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import com.xero.models.accounting.Attachment;
import com.xero.models.accounting.Contact;
import com.xero.models.accounting.LineAmountTypes;
import com.xero.models.accounting.LineItem;
import com.xero.models.accounting.User;
import com.xero.models.accounting.ValidationError;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.ZoneId;

public class Receipt {
    StringUtil util = new StringUtil();
    @JsonProperty(value="Date")
    private String date;
    @JsonProperty(value="Contact")
    private Contact contact;
    @JsonProperty(value="LineItems")
    private List<LineItem> lineItems = new ArrayList<LineItem>();
    @JsonProperty(value="User")
    private User user;
    @JsonProperty(value="Reference")
    private String reference;
    @JsonProperty(value="LineAmountTypes")
    private LineAmountTypes lineAmountTypes;
    @JsonProperty(value="SubTotal")
    private Double subTotal;
    @JsonProperty(value="TotalTax")
    private Double totalTax;
    @JsonProperty(value="Total")
    private Double total;
    @JsonProperty(value="ReceiptID")
    private UUID receiptID;
    @JsonProperty(value="Status")
    private StatusEnum status;
    @JsonProperty(value="ReceiptNumber")
    private String receiptNumber;
    @JsonProperty(value="UpdatedDateUTC")
    private String updatedDateUTC;
    @JsonProperty(value="HasAttachments")
    private Boolean hasAttachments = false;
    @JsonProperty(value="Url")
    private String url;
    @JsonProperty(value="ValidationErrors")
    private List<ValidationError> validationErrors = new ArrayList<ValidationError>();
    @JsonProperty(value="Warnings")
    private List<ValidationError> warnings = new ArrayList<ValidationError>();
    @JsonProperty(value="Attachments")
    private List<Attachment> attachments = new ArrayList<Attachment>();

    public Receipt date(String date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(value="Date of receipt \u2013 YYYY-MM-DD")
    public String getDate() {
        return this.date;
    }

    public LocalDate getDateAsDate() {
        if (this.date != null) {
            try {
                return this.util.convertStringToDate(this.date);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public void setDate(LocalDate date) {
        Instant instant = date.atStartOfDay(ZoneId.of((String)"UTC").normalized()).toInstant();
        long timeInMillis = instant.toEpochMilli();
        this.date = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
    }

    public Receipt contact(Contact contact) {
        this.contact = contact;
        return this;
    }

    @ApiModelProperty(value="")
    public Contact getContact() {
        return this.contact;
    }

    public void setContact(Contact contact) {
        this.contact = contact;
    }

    public Receipt lineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
        return this;
    }

    public Receipt addLineItemsItem(LineItem lineItemsItem) {
        if (this.lineItems == null) {
            this.lineItems = new ArrayList<LineItem>();
        }
        this.lineItems.add(lineItemsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    public void setLineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
    }

    public Receipt user(User user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(value="")
    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Receipt reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Additional reference number")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public Receipt lineAmountTypes(LineAmountTypes lineAmountTypes) {
        this.lineAmountTypes = lineAmountTypes;
        return this;
    }

    @ApiModelProperty(value="")
    public LineAmountTypes getLineAmountTypes() {
        return this.lineAmountTypes;
    }

    public void setLineAmountTypes(LineAmountTypes lineAmountTypes) {
        this.lineAmountTypes = lineAmountTypes;
    }

    public Receipt subTotal(Double subTotal) {
        this.subTotal = subTotal;
        return this;
    }

    @ApiModelProperty(value="Total of receipt excluding taxes")
    public Double getSubTotal() {
        return this.subTotal;
    }

    public void setSubTotal(Double subTotal) {
        this.subTotal = subTotal;
    }

    public Receipt totalTax(Double totalTax) {
        this.totalTax = totalTax;
        return this;
    }

    @ApiModelProperty(value="Total tax on receipt")
    public Double getTotalTax() {
        return this.totalTax;
    }

    public void setTotalTax(Double totalTax) {
        this.totalTax = totalTax;
    }

    public Receipt total(Double total) {
        this.total = total;
        return this;
    }

    @ApiModelProperty(value="Total of receipt tax inclusive (i.e. SubTotal + TotalTax)")
    public Double getTotal() {
        return this.total;
    }

    public void setTotal(Double total) {
        this.total = total;
    }

    public Receipt receiptID(UUID receiptID) {
        this.receiptID = receiptID;
        return this;
    }

    @ApiModelProperty(value="Xero generated unique identifier for receipt")
    public UUID getReceiptID() {
        return this.receiptID;
    }

    public void setReceiptID(UUID receiptID) {
        this.receiptID = receiptID;
    }

    public Receipt status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="Current status of receipt \u2013 see status types")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    @ApiModelProperty(value="Xero generated sequence number for receipt in current claim for a given user")
    public String getReceiptNumber() {
        return this.receiptNumber;
    }

    @ApiModelProperty(example="/Date(1573755038314)/", value="Last modified date UTC format")
    public String getUpdatedDateUTC() {
        return this.updatedDateUTC;
    }

    public OffsetDateTime getUpdatedDateUTCAsDate() {
        if (this.updatedDateUTC != null) {
            try {
                return this.util.convertStringToOffsetDateTime(this.updatedDateUTC);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @ApiModelProperty(example="false", value="boolean to indicate if a receipt has an attachment")
    public Boolean getHasAttachments() {
        return this.hasAttachments;
    }

    @ApiModelProperty(value="URL link to a source document \u2013 shown as \u201cGo to [appName]\u201d in the Xero app")
    public String getUrl() {
        return this.url;
    }

    public Receipt validationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
        return this;
    }

    public Receipt addValidationErrorsItem(ValidationError validationErrorsItem) {
        if (this.validationErrors == null) {
            this.validationErrors = new ArrayList<ValidationError>();
        }
        this.validationErrors.add(validationErrorsItem);
        return this;
    }

    @ApiModelProperty(value="Displays array of validation error messages from the API")
    public List<ValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    public void setValidationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
    }

    public Receipt warnings(List<ValidationError> warnings) {
        this.warnings = warnings;
        return this;
    }

    public Receipt addWarningsItem(ValidationError warningsItem) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<ValidationError>();
        }
        this.warnings.add(warningsItem);
        return this;
    }

    @ApiModelProperty(value="Displays array of warning messages from the API")
    public List<ValidationError> getWarnings() {
        return this.warnings;
    }

    public void setWarnings(List<ValidationError> warnings) {
        this.warnings = warnings;
    }

    public Receipt attachments(List<Attachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    public Receipt addAttachmentsItem(Attachment attachmentsItem) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<Attachment>();
        }
        this.attachments.add(attachmentsItem);
        return this;
    }

    @ApiModelProperty(value="Displays array of attachments from the API")
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Receipt receipt = (Receipt)o;
        return Objects.equals(this.date, receipt.date) && Objects.equals(this.contact, receipt.contact) && Objects.equals(this.lineItems, receipt.lineItems) && Objects.equals(this.user, receipt.user) && Objects.equals(this.reference, receipt.reference) && Objects.equals((Object)this.lineAmountTypes, (Object)receipt.lineAmountTypes) && Objects.equals(this.subTotal, receipt.subTotal) && Objects.equals(this.totalTax, receipt.totalTax) && Objects.equals(this.total, receipt.total) && Objects.equals(this.receiptID, receipt.receiptID) && Objects.equals((Object)this.status, (Object)receipt.status) && Objects.equals(this.receiptNumber, receipt.receiptNumber) && Objects.equals(this.updatedDateUTC, receipt.updatedDateUTC) && Objects.equals(this.hasAttachments, receipt.hasAttachments) && Objects.equals(this.url, receipt.url) && Objects.equals(this.validationErrors, receipt.validationErrors) && Objects.equals(this.warnings, receipt.warnings) && Objects.equals(this.attachments, receipt.attachments);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.date, this.contact, this.lineItems, this.user, this.reference, this.lineAmountTypes, this.subTotal, this.totalTax, this.total, this.receiptID, this.status, this.receiptNumber, this.updatedDateUTC, this.hasAttachments, this.url, this.validationErrors, this.warnings, this.attachments});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Receipt {\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    lineAmountTypes: ").append(this.toIndentedString((Object)this.lineAmountTypes)).append("\n");
        sb.append("    subTotal: ").append(this.toIndentedString(this.subTotal)).append("\n");
        sb.append("    totalTax: ").append(this.toIndentedString(this.totalTax)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("    receiptID: ").append(this.toIndentedString(this.receiptID)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    receiptNumber: ").append(this.toIndentedString(this.receiptNumber)).append("\n");
        sb.append("    updatedDateUTC: ").append(this.toIndentedString(this.updatedDateUTC)).append("\n");
        sb.append("    hasAttachments: ").append(this.toIndentedString(this.hasAttachments)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    validationErrors: ").append(this.toIndentedString(this.validationErrors)).append("\n");
        sb.append("    warnings: ").append(this.toIndentedString(this.warnings)).append("\n");
        sb.append("    attachments: ").append(this.toIndentedString(this.attachments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        DRAFT("DRAFT"),
        SUBMITTED("SUBMITTED"),
        AUTHORISED("AUTHORISED"),
        DECLINED("DECLINED"),
        VOIDED("VOIDED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

