/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.accounting;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.OffsetDateTime;

public class User {
    StringUtil util = new StringUtil();
    @JsonProperty(value="UserID")
    private UUID userID;
    @JsonProperty(value="EmailAddress")
    private String emailAddress;
    @JsonProperty(value="FirstName")
    private String firstName;
    @JsonProperty(value="LastName")
    private String lastName;
    @JsonProperty(value="UpdatedDateUTC")
    private String updatedDateUTC;
    @JsonProperty(value="IsSubscriber")
    private Boolean isSubscriber;
    @JsonProperty(value="OrganisationRole")
    private OrganisationRoleEnum organisationRole;

    public User userID(UUID userID) {
        this.userID = userID;
        return this;
    }

    @ApiModelProperty(value="Xero identifier")
    public UUID getUserID() {
        return this.userID;
    }

    public void setUserID(UUID userID) {
        this.userID = userID;
    }

    public User emailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    @ApiModelProperty(value="Email address of user")
    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public User firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @ApiModelProperty(value="First name of user")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public User lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @ApiModelProperty(value="Last name of user")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @ApiModelProperty(example="/Date(1573755038314)/", value="Timestamp of last change to user")
    public String getUpdatedDateUTC() {
        return this.updatedDateUTC;
    }

    public OffsetDateTime getUpdatedDateUTCAsDate() {
        if (this.updatedDateUTC != null) {
            try {
                return this.util.convertStringToOffsetDateTime(this.updatedDateUTC);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public User isSubscriber(Boolean isSubscriber) {
        this.isSubscriber = isSubscriber;
        return this;
    }

    @ApiModelProperty(value="Boolean to indicate if user is the subscriber")
    public Boolean getIsSubscriber() {
        return this.isSubscriber;
    }

    public void setIsSubscriber(Boolean isSubscriber) {
        this.isSubscriber = isSubscriber;
    }

    public User organisationRole(OrganisationRoleEnum organisationRole) {
        this.organisationRole = organisationRole;
        return this;
    }

    @ApiModelProperty(value="User role that defines permissions in Xero and via API (READONLY, INVOICEONLY, STANDARD, FINANCIALADVISER, etc)")
    public OrganisationRoleEnum getOrganisationRole() {
        return this.organisationRole;
    }

    public void setOrganisationRole(OrganisationRoleEnum organisationRole) {
        this.organisationRole = organisationRole;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return Objects.equals(this.userID, user.userID) && Objects.equals(this.emailAddress, user.emailAddress) && Objects.equals(this.firstName, user.firstName) && Objects.equals(this.lastName, user.lastName) && Objects.equals(this.updatedDateUTC, user.updatedDateUTC) && Objects.equals(this.isSubscriber, user.isSubscriber) && Objects.equals((Object)this.organisationRole, (Object)user.organisationRole);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.userID, this.emailAddress, this.firstName, this.lastName, this.updatedDateUTC, this.isSubscriber, this.organisationRole});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class User {\n");
        sb.append("    userID: ").append(this.toIndentedString(this.userID)).append("\n");
        sb.append("    emailAddress: ").append(this.toIndentedString(this.emailAddress)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    updatedDateUTC: ").append(this.toIndentedString(this.updatedDateUTC)).append("\n");
        sb.append("    isSubscriber: ").append(this.toIndentedString(this.isSubscriber)).append("\n");
        sb.append("    organisationRole: ").append(this.toIndentedString((Object)this.organisationRole)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OrganisationRoleEnum {
        READONLY("READONLY"),
        INVOICEONLY("INVOICEONLY"),
        STANDARD("STANDARD"),
        FINANCIALADVISER("FINANCIALADVISER"),
        MANAGEDCLIENT("MANAGEDCLIENT"),
        CASHBOOKCLIENT("CASHBOOKCLIENT"),
        UNKNOWN("UNKNOWN");

        private String value;

        private OrganisationRoleEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OrganisationRoleEnum fromValue(String value) {
            for (OrganisationRoleEnum b : OrganisationRoleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

