/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.appstore;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.xero.api.StringUtil;
import com.xero.models.appstore.Price;
import com.xero.models.appstore.Product;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDateTime;

public class SubscriptionItem {
    StringUtil util = new StringUtil();
    @JsonProperty(value="endDate")
    private LocalDateTime endDate;
    @JsonProperty(value="id")
    private UUID id;
    @JsonProperty(value="price")
    private Price price;
    @JsonProperty(value="product")
    private Product product;
    @JsonProperty(value="quantity")
    private Integer quantity;
    @JsonProperty(value="startDate")
    private LocalDateTime startDate;
    @JsonProperty(value="status")
    private StatusEnum status;
    @JsonProperty(value="testMode")
    private Boolean testMode;

    public SubscriptionItem endDate(LocalDateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    @ApiModelProperty(value="Date when the subscription to this product will end")
    public LocalDateTime getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDateTime endDate) {
        this.endDate = endDate;
    }

    public SubscriptionItem id(UUID id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the subscription item.")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public SubscriptionItem price(Price price) {
        this.price = price;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Price getPrice() {
        return this.price;
    }

    public void setPrice(Price price) {
        this.price = price;
    }

    public SubscriptionItem product(Product product) {
        this.product = product;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public SubscriptionItem quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @ApiModelProperty(value="The quantity of the item. For a fixed product, it is 1. For a per-seat product, it is a positive integer. For metered products, it is always null.")
    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public SubscriptionItem startDate(LocalDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(required=true, value="Date the subscription started, or will start. Note: this could be in the future for downgrades or reduced number of seats that haven't taken effect yet. ")
    public LocalDateTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDateTime startDate) {
        this.startDate = startDate;
    }

    public SubscriptionItem status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="Status of the subscription item. Available statuses are ACTIVE, CANCELED, and PENDING_ACTIVATION. ")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public SubscriptionItem testMode(Boolean testMode) {
        this.testMode = testMode;
        return this;
    }

    @ApiModelProperty(value="If the subscription is a test subscription")
    public Boolean getTestMode() {
        return this.testMode;
    }

    public void setTestMode(Boolean testMode) {
        this.testMode = testMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionItem subscriptionItem = (SubscriptionItem)o;
        return Objects.equals(this.endDate, subscriptionItem.endDate) && Objects.equals(this.id, subscriptionItem.id) && Objects.equals(this.price, subscriptionItem.price) && Objects.equals(this.product, subscriptionItem.product) && Objects.equals(this.quantity, subscriptionItem.quantity) && Objects.equals(this.startDate, subscriptionItem.startDate) && Objects.equals((Object)this.status, (Object)subscriptionItem.status) && Objects.equals(this.testMode, subscriptionItem.testMode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.endDate, this.id, this.price, this.product, this.quantity, this.startDate, this.status, this.testMode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubscriptionItem {\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    product: ").append(this.toIndentedString(this.product)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    testMode: ").append(this.toIndentedString(this.testMode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        ACTIVE("ACTIVE"),
        CANCELED("CANCELED"),
        PENDING_ACTIVATION("PENDING_ACTIVATION");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

