/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.assets;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.threeten.bp.LocalDate;

public class BookDepreciationDetail {
    StringUtil util = new StringUtil();
    @JsonProperty(value="currentCapitalGain")
    private Double currentCapitalGain;
    @JsonProperty(value="currentGainLoss")
    private Double currentGainLoss;
    @JsonProperty(value="depreciationStartDate")
    private LocalDate depreciationStartDate;
    @JsonProperty(value="costLimit")
    private Double costLimit;
    @JsonProperty(value="residualValue")
    private Double residualValue;
    @JsonProperty(value="priorAccumDepreciationAmount")
    private Double priorAccumDepreciationAmount;
    @JsonProperty(value="currentAccumDepreciationAmount")
    private Double currentAccumDepreciationAmount;

    public BookDepreciationDetail currentCapitalGain(Double currentCapitalGain) {
        this.currentCapitalGain = currentCapitalGain;
        return this;
    }

    @ApiModelProperty(example="5.25", value="When an asset is disposed, this will be the sell price minus the purchase price if a profit was made.")
    public Double getCurrentCapitalGain() {
        return this.currentCapitalGain;
    }

    public void setCurrentCapitalGain(Double currentCapitalGain) {
        this.currentCapitalGain = currentCapitalGain;
    }

    public BookDepreciationDetail currentGainLoss(Double currentGainLoss) {
        this.currentGainLoss = currentGainLoss;
        return this;
    }

    @ApiModelProperty(example="10.5", value="When an asset is disposed, this will be the lowest one of sell price or purchase price, minus the current book value.")
    public Double getCurrentGainLoss() {
        return this.currentGainLoss;
    }

    public void setCurrentGainLoss(Double currentGainLoss) {
        this.currentGainLoss = currentGainLoss;
    }

    public BookDepreciationDetail depreciationStartDate(LocalDate depreciationStartDate) {
        this.depreciationStartDate = depreciationStartDate;
        return this;
    }

    @ApiModelProperty(value="YYYY-MM-DD")
    public LocalDate getDepreciationStartDate() {
        return this.depreciationStartDate;
    }

    public void setDepreciationStartDate(LocalDate depreciationStartDate) {
        this.depreciationStartDate = depreciationStartDate;
    }

    public BookDepreciationDetail costLimit(Double costLimit) {
        this.costLimit = costLimit;
        return this;
    }

    @ApiModelProperty(example="9000.0", value="The value of the asset you want to depreciate, if this is less than the cost of the asset.")
    public Double getCostLimit() {
        return this.costLimit;
    }

    public void setCostLimit(Double costLimit) {
        this.costLimit = costLimit;
    }

    public BookDepreciationDetail residualValue(Double residualValue) {
        this.residualValue = residualValue;
        return this;
    }

    @ApiModelProperty(example="10000.0", value="The value of the asset remaining when you've fully depreciated it.")
    public Double getResidualValue() {
        return this.residualValue;
    }

    public void setResidualValue(Double residualValue) {
        this.residualValue = residualValue;
    }

    public BookDepreciationDetail priorAccumDepreciationAmount(Double priorAccumDepreciationAmount) {
        this.priorAccumDepreciationAmount = priorAccumDepreciationAmount;
        return this;
    }

    @ApiModelProperty(example="0.45", value="All depreciation prior to the current financial year.")
    public Double getPriorAccumDepreciationAmount() {
        return this.priorAccumDepreciationAmount;
    }

    public void setPriorAccumDepreciationAmount(Double priorAccumDepreciationAmount) {
        this.priorAccumDepreciationAmount = priorAccumDepreciationAmount;
    }

    public BookDepreciationDetail currentAccumDepreciationAmount(Double currentAccumDepreciationAmount) {
        this.currentAccumDepreciationAmount = currentAccumDepreciationAmount;
        return this;
    }

    @ApiModelProperty(example="5.0", value="All depreciation occurring in the current financial year.")
    public Double getCurrentAccumDepreciationAmount() {
        return this.currentAccumDepreciationAmount;
    }

    public void setCurrentAccumDepreciationAmount(Double currentAccumDepreciationAmount) {
        this.currentAccumDepreciationAmount = currentAccumDepreciationAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BookDepreciationDetail bookDepreciationDetail = (BookDepreciationDetail)o;
        return Objects.equals(this.currentCapitalGain, bookDepreciationDetail.currentCapitalGain) && Objects.equals(this.currentGainLoss, bookDepreciationDetail.currentGainLoss) && Objects.equals(this.depreciationStartDate, bookDepreciationDetail.depreciationStartDate) && Objects.equals(this.costLimit, bookDepreciationDetail.costLimit) && Objects.equals(this.residualValue, bookDepreciationDetail.residualValue) && Objects.equals(this.priorAccumDepreciationAmount, bookDepreciationDetail.priorAccumDepreciationAmount) && Objects.equals(this.currentAccumDepreciationAmount, bookDepreciationDetail.currentAccumDepreciationAmount);
    }

    public int hashCode() {
        return Objects.hash(this.currentCapitalGain, this.currentGainLoss, this.depreciationStartDate, this.costLimit, this.residualValue, this.priorAccumDepreciationAmount, this.currentAccumDepreciationAmount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BookDepreciationDetail {\n");
        sb.append("    currentCapitalGain: ").append(this.toIndentedString(this.currentCapitalGain)).append("\n");
        sb.append("    currentGainLoss: ").append(this.toIndentedString(this.currentGainLoss)).append("\n");
        sb.append("    depreciationStartDate: ").append(this.toIndentedString(this.depreciationStartDate)).append("\n");
        sb.append("    costLimit: ").append(this.toIndentedString(this.costLimit)).append("\n");
        sb.append("    residualValue: ").append(this.toIndentedString(this.residualValue)).append("\n");
        sb.append("    priorAccumDepreciationAmount: ").append(this.toIndentedString(this.priorAccumDepreciationAmount)).append("\n");
        sb.append("    currentAccumDepreciationAmount: ").append(this.toIndentedString(this.currentAccumDepreciationAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

