/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.file;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;

public class Folder {
    StringUtil util = new StringUtil();
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="FileCount")
    private Integer fileCount;
    @JsonProperty(value="Email")
    private String email;
    @JsonProperty(value="IsInbox")
    private Boolean isInbox;
    @JsonProperty(value="Id")
    private UUID id;

    public Folder name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="assets", value="The name of the folder")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Folder fileCount(Integer fileCount) {
        this.fileCount = fileCount;
        return this;
    }

    @ApiModelProperty(example="5", value="The number of files in the folder")
    public Integer getFileCount() {
        return this.fileCount;
    }

    public void setFileCount(Integer fileCount) {
        this.fileCount = fileCount;
    }

    public Folder email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(example="foo@bar.com", value="The email address used to email files to the inbox. Only the inbox will have this element.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Folder isInbox(Boolean isInbox) {
        this.isInbox = isInbox;
        return this;
    }

    @ApiModelProperty(example="true", value="to indicate if the folder is the Inbox. The Inbox cannot be renamed or deleted.")
    public Boolean getIsInbox() {
        return this.isInbox;
    }

    public void setIsInbox(Boolean isInbox) {
        this.isInbox = isInbox;
    }

    public Folder id(UUID id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="4ff1e5cc-9835-40d5-bb18-09fdb118db9c", value="Xero unique identifier for a folder  Files")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Folder folder = (Folder)o;
        return Objects.equals(this.name, folder.name) && Objects.equals(this.fileCount, folder.fileCount) && Objects.equals(this.email, folder.email) && Objects.equals(this.isInbox, folder.isInbox) && Objects.equals(this.id, folder.id);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fileCount, this.email, this.isInbox, this.id);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Folder {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    fileCount: ").append(this.toIndentedString(this.fileCount)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    isInbox: ").append(this.toIndentedString(this.isInbox)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

