/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.finance;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import com.xero.models.finance.ContactResponse;
import com.xero.models.finance.LineItemResponse;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDate;

public class BankTransactionResponse {
    StringUtil util = new StringUtil();
    @JsonProperty(value="bankTransactionId")
    private UUID bankTransactionId;
    @JsonProperty(value="batchPaymentId")
    private UUID batchPaymentId;
    @JsonProperty(value="contact")
    private ContactResponse contact;
    @JsonProperty(value="date")
    private LocalDate date;
    @JsonProperty(value="amount")
    private Double amount;
    @JsonProperty(value="lineItems")
    private List<LineItemResponse> lineItems = new ArrayList<LineItemResponse>();

    public BankTransactionResponse bankTransactionId(UUID bankTransactionId) {
        this.bankTransactionId = bankTransactionId;
        return this;
    }

    @ApiModelProperty(value="Xero Identifier of transaction")
    public UUID getBankTransactionId() {
        return this.bankTransactionId;
    }

    public void setBankTransactionId(UUID bankTransactionId) {
        this.bankTransactionId = bankTransactionId;
    }

    public BankTransactionResponse batchPaymentId(UUID batchPaymentId) {
        this.batchPaymentId = batchPaymentId;
        return this;
    }

    @ApiModelProperty(value="Xero Identifier of batch payment. Present if the transaction is part of a batch.")
    public UUID getBatchPaymentId() {
        return this.batchPaymentId;
    }

    public void setBatchPaymentId(UUID batchPaymentId) {
        this.batchPaymentId = batchPaymentId;
    }

    public BankTransactionResponse contact(ContactResponse contact) {
        this.contact = contact;
        return this;
    }

    @ApiModelProperty(value="")
    public ContactResponse getContact() {
        return this.contact;
    }

    public void setContact(ContactResponse contact) {
        this.contact = contact;
    }

    public BankTransactionResponse date(LocalDate date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(value="Date of transaction - YYYY-MM-DD")
    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public BankTransactionResponse amount(Double amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="Amount of transaction")
    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public BankTransactionResponse lineItems(List<LineItemResponse> lineItems) {
        this.lineItems = lineItems;
        return this;
    }

    public BankTransactionResponse addLineItemsItem(LineItemResponse lineItemsItem) {
        if (this.lineItems == null) {
            this.lineItems = new ArrayList<LineItemResponse>();
        }
        this.lineItems.add(lineItemsItem);
        return this;
    }

    @ApiModelProperty(value="The LineItems element can contain any number of individual LineItem sub-elements. Not included in summary mode")
    public List<LineItemResponse> getLineItems() {
        return this.lineItems;
    }

    public void setLineItems(List<LineItemResponse> lineItems) {
        this.lineItems = lineItems;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankTransactionResponse bankTransactionResponse = (BankTransactionResponse)o;
        return Objects.equals(this.bankTransactionId, bankTransactionResponse.bankTransactionId) && Objects.equals(this.batchPaymentId, bankTransactionResponse.batchPaymentId) && Objects.equals(this.contact, bankTransactionResponse.contact) && Objects.equals(this.date, bankTransactionResponse.date) && Objects.equals(this.amount, bankTransactionResponse.amount) && Objects.equals(this.lineItems, bankTransactionResponse.lineItems);
    }

    public int hashCode() {
        return Objects.hash(this.bankTransactionId, this.batchPaymentId, this.contact, this.date, this.amount, this.lineItems);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BankTransactionResponse {\n");
        sb.append("    bankTransactionId: ").append(this.toIndentedString(this.bankTransactionId)).append("\n");
        sb.append("    batchPaymentId: ").append(this.toIndentedString(this.batchPaymentId)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

