/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.finance;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;

public class CashflowAccount {
    StringUtil util = new StringUtil();
    @JsonProperty(value="accountId")
    private UUID accountId;
    @JsonProperty(value="accountType")
    private String accountType;
    @JsonProperty(value="accountClass")
    private String accountClass;
    @JsonProperty(value="code")
    private String code;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="reportingCode")
    private String reportingCode;
    @JsonProperty(value="total")
    private Double total;

    public CashflowAccount accountId(UUID accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(value="ID of the account")
    public UUID getAccountId() {
        return this.accountId;
    }

    public void setAccountId(UUID accountId) {
        this.accountId = accountId;
    }

    public CashflowAccount accountType(String accountType) {
        this.accountType = accountType;
        return this;
    }

    @ApiModelProperty(value="The type of the account. See <a href='https://developer.xero.com/documentation/api/types#AccountTypes'>Account Types</a>")
    public String getAccountType() {
        return this.accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public CashflowAccount accountClass(String accountClass) {
        this.accountClass = accountClass;
        return this;
    }

    @ApiModelProperty(value="The class of the account. See <a href='https://developer.xero.com/documentation/api/types#AccountClassTypes'>Account Class Types</a>")
    public String getAccountClass() {
        return this.accountClass;
    }

    public void setAccountClass(String accountClass) {
        this.accountClass = accountClass;
    }

    public CashflowAccount code(String code) {
        this.code = code;
        return this;
    }

    @ApiModelProperty(value="Account code")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public CashflowAccount name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Account name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CashflowAccount reportingCode(String reportingCode) {
        this.reportingCode = reportingCode;
        return this;
    }

    @ApiModelProperty(value="Reporting code used for cash flow classification")
    public String getReportingCode() {
        return this.reportingCode;
    }

    public void setReportingCode(String reportingCode) {
        this.reportingCode = reportingCode;
    }

    public CashflowAccount total(Double total) {
        this.total = total;
        return this;
    }

    @ApiModelProperty(value="Total amount for the account")
    public Double getTotal() {
        return this.total;
    }

    public void setTotal(Double total) {
        this.total = total;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CashflowAccount cashflowAccount = (CashflowAccount)o;
        return Objects.equals(this.accountId, cashflowAccount.accountId) && Objects.equals(this.accountType, cashflowAccount.accountType) && Objects.equals(this.accountClass, cashflowAccount.accountClass) && Objects.equals(this.code, cashflowAccount.code) && Objects.equals(this.name, cashflowAccount.name) && Objects.equals(this.reportingCode, cashflowAccount.reportingCode) && Objects.equals(this.total, cashflowAccount.total);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.accountType, this.accountClass, this.code, this.name, this.reportingCode, this.total);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CashflowAccount {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    accountType: ").append(this.toIndentedString(this.accountType)).append("\n");
        sb.append("    accountClass: ").append(this.toIndentedString(this.accountClass)).append("\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    reportingCode: ").append(this.toIndentedString(this.reportingCode)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

