/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.finance;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import com.xero.models.finance.CreditNoteResponse;
import com.xero.models.finance.InvoiceResponse;
import com.xero.models.finance.OverpaymentResponse;
import com.xero.models.finance.PrepaymentResponse;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDate;

public class PaymentResponse {
    StringUtil util = new StringUtil();
    @JsonProperty(value="paymentId")
    private UUID paymentId;
    @JsonProperty(value="batchPaymentId")
    private UUID batchPaymentId;
    @JsonProperty(value="date")
    private LocalDate date;
    @JsonProperty(value="amount")
    private Double amount;
    @JsonProperty(value="bankAmount")
    private Double bankAmount;
    @JsonProperty(value="currencyRate")
    private Double currencyRate;
    @JsonProperty(value="invoice")
    private InvoiceResponse invoice;
    @JsonProperty(value="creditNote")
    private CreditNoteResponse creditNote;
    @JsonProperty(value="prepayment")
    private PrepaymentResponse prepayment;
    @JsonProperty(value="overpayment")
    private OverpaymentResponse overpayment;

    public PaymentResponse paymentId(UUID paymentId) {
        this.paymentId = paymentId;
        return this;
    }

    @ApiModelProperty(value="Xero Identifier of payment")
    public UUID getPaymentId() {
        return this.paymentId;
    }

    public void setPaymentId(UUID paymentId) {
        this.paymentId = paymentId;
    }

    public PaymentResponse batchPaymentId(UUID batchPaymentId) {
        this.batchPaymentId = batchPaymentId;
        return this;
    }

    @ApiModelProperty(value="Xero Identifier of batch payment. Present if the payment was created as part of a batch.")
    public UUID getBatchPaymentId() {
        return this.batchPaymentId;
    }

    public void setBatchPaymentId(UUID batchPaymentId) {
        this.batchPaymentId = batchPaymentId;
    }

    public PaymentResponse date(LocalDate date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(value="Date the payment is being made (YYYY-MM-DD) e.g. 2009-09-06")
    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public PaymentResponse amount(Double amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="The amount of the payment")
    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public PaymentResponse bankAmount(Double bankAmount) {
        this.bankAmount = bankAmount;
        return this;
    }

    @ApiModelProperty(value="The bank amount of the payment")
    public Double getBankAmount() {
        return this.bankAmount;
    }

    public void setBankAmount(Double bankAmount) {
        this.bankAmount = bankAmount;
    }

    public PaymentResponse currencyRate(Double currencyRate) {
        this.currencyRate = currencyRate;
        return this;
    }

    @ApiModelProperty(value="Exchange rate when payment is received. Only used for non base currency invoices and credit notes e.g. 0.7500")
    public Double getCurrencyRate() {
        return this.currencyRate;
    }

    public void setCurrencyRate(Double currencyRate) {
        this.currencyRate = currencyRate;
    }

    public PaymentResponse invoice(InvoiceResponse invoice) {
        this.invoice = invoice;
        return this;
    }

    @ApiModelProperty(value="")
    public InvoiceResponse getInvoice() {
        return this.invoice;
    }

    public void setInvoice(InvoiceResponse invoice) {
        this.invoice = invoice;
    }

    public PaymentResponse creditNote(CreditNoteResponse creditNote) {
        this.creditNote = creditNote;
        return this;
    }

    @ApiModelProperty(value="")
    public CreditNoteResponse getCreditNote() {
        return this.creditNote;
    }

    public void setCreditNote(CreditNoteResponse creditNote) {
        this.creditNote = creditNote;
    }

    public PaymentResponse prepayment(PrepaymentResponse prepayment) {
        this.prepayment = prepayment;
        return this;
    }

    @ApiModelProperty(value="")
    public PrepaymentResponse getPrepayment() {
        return this.prepayment;
    }

    public void setPrepayment(PrepaymentResponse prepayment) {
        this.prepayment = prepayment;
    }

    public PaymentResponse overpayment(OverpaymentResponse overpayment) {
        this.overpayment = overpayment;
        return this;
    }

    @ApiModelProperty(value="")
    public OverpaymentResponse getOverpayment() {
        return this.overpayment;
    }

    public void setOverpayment(OverpaymentResponse overpayment) {
        this.overpayment = overpayment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentResponse paymentResponse = (PaymentResponse)o;
        return Objects.equals(this.paymentId, paymentResponse.paymentId) && Objects.equals(this.batchPaymentId, paymentResponse.batchPaymentId) && Objects.equals(this.date, paymentResponse.date) && Objects.equals(this.amount, paymentResponse.amount) && Objects.equals(this.bankAmount, paymentResponse.bankAmount) && Objects.equals(this.currencyRate, paymentResponse.currencyRate) && Objects.equals(this.invoice, paymentResponse.invoice) && Objects.equals(this.creditNote, paymentResponse.creditNote) && Objects.equals(this.prepayment, paymentResponse.prepayment) && Objects.equals(this.overpayment, paymentResponse.overpayment);
    }

    public int hashCode() {
        return Objects.hash(this.paymentId, this.batchPaymentId, this.date, this.amount, this.bankAmount, this.currencyRate, this.invoice, this.creditNote, this.prepayment, this.overpayment);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentResponse {\n");
        sb.append("    paymentId: ").append(this.toIndentedString(this.paymentId)).append("\n");
        sb.append("    batchPaymentId: ").append(this.toIndentedString(this.batchPaymentId)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    bankAmount: ").append(this.toIndentedString(this.bankAmount)).append("\n");
        sb.append("    currencyRate: ").append(this.toIndentedString(this.currencyRate)).append("\n");
        sb.append("    invoice: ").append(this.toIndentedString(this.invoice)).append("\n");
        sb.append("    creditNote: ").append(this.toIndentedString(this.creditNote)).append("\n");
        sb.append("    prepayment: ").append(this.toIndentedString(this.prepayment)).append("\n");
        sb.append("    overpayment: ").append(this.toIndentedString(this.overpayment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

