/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.finance;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import com.xero.models.finance.BankTransactionResponse;
import com.xero.models.finance.PaymentResponse;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.LocalDate;

public class StatementLineResponse {
    StringUtil util = new StringUtil();
    @JsonProperty(value="statementLineId")
    private UUID statementLineId;
    @JsonProperty(value="postedDate")
    private LocalDate postedDate;
    @JsonProperty(value="payee")
    private String payee;
    @JsonProperty(value="reference")
    private String reference;
    @JsonProperty(value="notes")
    private String notes;
    @JsonProperty(value="chequeNo")
    private String chequeNo;
    @JsonProperty(value="amount")
    private Double amount;
    @JsonProperty(value="transactionDate")
    private LocalDate transactionDate;
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="isReconciled")
    private Boolean isReconciled;
    @JsonProperty(value="isDuplicate")
    private Boolean isDuplicate;
    @JsonProperty(value="isDeleted")
    private Boolean isDeleted;
    @JsonProperty(value="payments")
    private List<PaymentResponse> payments = new ArrayList<PaymentResponse>();
    @JsonProperty(value="bankTransactions")
    private List<BankTransactionResponse> bankTransactions = new ArrayList<BankTransactionResponse>();

    public StatementLineResponse statementLineId(UUID statementLineId) {
        this.statementLineId = statementLineId;
        return this;
    }

    @ApiModelProperty(value="Xero Identifier of statement line")
    public UUID getStatementLineId() {
        return this.statementLineId;
    }

    public void setStatementLineId(UUID statementLineId) {
        this.statementLineId = statementLineId;
    }

    public StatementLineResponse postedDate(LocalDate postedDate) {
        this.postedDate = postedDate;
        return this;
    }

    @ApiModelProperty(value="Date of when statement line was posted")
    public LocalDate getPostedDate() {
        return this.postedDate;
    }

    public void setPostedDate(LocalDate postedDate) {
        this.postedDate = postedDate;
    }

    public StatementLineResponse payee(String payee) {
        this.payee = payee;
        return this;
    }

    @ApiModelProperty(value="Payee description of statement line")
    public String getPayee() {
        return this.payee;
    }

    public void setPayee(String payee) {
        this.payee = payee;
    }

    public StatementLineResponse reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Reference description of statement line")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public StatementLineResponse notes(String notes) {
        this.notes = notes;
        return this;
    }

    @ApiModelProperty(value="Notes description of statement line")
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public StatementLineResponse chequeNo(String chequeNo) {
        this.chequeNo = chequeNo;
        return this;
    }

    @ApiModelProperty(value="Cheque number of statement line")
    public String getChequeNo() {
        return this.chequeNo;
    }

    public void setChequeNo(String chequeNo) {
        this.chequeNo = chequeNo;
    }

    public StatementLineResponse amount(Double amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="Amount of statement line")
    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public StatementLineResponse transactionDate(LocalDate transactionDate) {
        this.transactionDate = transactionDate;
        return this;
    }

    @ApiModelProperty(value="Transaction date of statement line")
    public LocalDate getTransactionDate() {
        return this.transactionDate;
    }

    public void setTransactionDate(LocalDate transactionDate) {
        this.transactionDate = transactionDate;
    }

    public StatementLineResponse type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="Type of statement line")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public StatementLineResponse isReconciled(Boolean isReconciled) {
        this.isReconciled = isReconciled;
        return this;
    }

    @ApiModelProperty(value="Boolean to show if statement line is reconciled")
    public Boolean getIsReconciled() {
        return this.isReconciled;
    }

    public void setIsReconciled(Boolean isReconciled) {
        this.isReconciled = isReconciled;
    }

    public StatementLineResponse isDuplicate(Boolean isDuplicate) {
        this.isDuplicate = isDuplicate;
        return this;
    }

    @ApiModelProperty(value="Boolean to show if statement line is duplicate")
    public Boolean getIsDuplicate() {
        return this.isDuplicate;
    }

    public void setIsDuplicate(Boolean isDuplicate) {
        this.isDuplicate = isDuplicate;
    }

    public StatementLineResponse isDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
        return this;
    }

    @ApiModelProperty(value="Boolean to show if statement line is deleted")
    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    public StatementLineResponse payments(List<PaymentResponse> payments) {
        this.payments = payments;
        return this;
    }

    public StatementLineResponse addPaymentsItem(PaymentResponse paymentsItem) {
        if (this.payments == null) {
            this.payments = new ArrayList<PaymentResponse>();
        }
        this.payments.add(paymentsItem);
        return this;
    }

    @ApiModelProperty(value="List of payments associated with reconciled statement lines")
    public List<PaymentResponse> getPayments() {
        return this.payments;
    }

    public void setPayments(List<PaymentResponse> payments) {
        this.payments = payments;
    }

    public StatementLineResponse bankTransactions(List<BankTransactionResponse> bankTransactions) {
        this.bankTransactions = bankTransactions;
        return this;
    }

    public StatementLineResponse addBankTransactionsItem(BankTransactionResponse bankTransactionsItem) {
        if (this.bankTransactions == null) {
            this.bankTransactions = new ArrayList<BankTransactionResponse>();
        }
        this.bankTransactions.add(bankTransactionsItem);
        return this;
    }

    @ApiModelProperty(value="List of bank transactions associated with reconciled statement lines")
    public List<BankTransactionResponse> getBankTransactions() {
        return this.bankTransactions;
    }

    public void setBankTransactions(List<BankTransactionResponse> bankTransactions) {
        this.bankTransactions = bankTransactions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatementLineResponse statementLineResponse = (StatementLineResponse)o;
        return Objects.equals(this.statementLineId, statementLineResponse.statementLineId) && Objects.equals(this.postedDate, statementLineResponse.postedDate) && Objects.equals(this.payee, statementLineResponse.payee) && Objects.equals(this.reference, statementLineResponse.reference) && Objects.equals(this.notes, statementLineResponse.notes) && Objects.equals(this.chequeNo, statementLineResponse.chequeNo) && Objects.equals(this.amount, statementLineResponse.amount) && Objects.equals(this.transactionDate, statementLineResponse.transactionDate) && Objects.equals(this.type, statementLineResponse.type) && Objects.equals(this.isReconciled, statementLineResponse.isReconciled) && Objects.equals(this.isDuplicate, statementLineResponse.isDuplicate) && Objects.equals(this.isDeleted, statementLineResponse.isDeleted) && Objects.equals(this.payments, statementLineResponse.payments) && Objects.equals(this.bankTransactions, statementLineResponse.bankTransactions);
    }

    public int hashCode() {
        return Objects.hash(this.statementLineId, this.postedDate, this.payee, this.reference, this.notes, this.chequeNo, this.amount, this.transactionDate, this.type, this.isReconciled, this.isDuplicate, this.isDeleted, this.payments, this.bankTransactions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StatementLineResponse {\n");
        sb.append("    statementLineId: ").append(this.toIndentedString(this.statementLineId)).append("\n");
        sb.append("    postedDate: ").append(this.toIndentedString(this.postedDate)).append("\n");
        sb.append("    payee: ").append(this.toIndentedString(this.payee)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    chequeNo: ").append(this.toIndentedString(this.chequeNo)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    transactionDate: ").append(this.toIndentedString(this.transactionDate)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    isReconciled: ").append(this.toIndentedString(this.isReconciled)).append("\n");
        sb.append("    isDuplicate: ").append(this.toIndentedString(this.isDuplicate)).append("\n");
        sb.append("    isDeleted: ").append(this.toIndentedString(this.isDeleted)).append("\n");
        sb.append("    payments: ").append(this.toIndentedString(this.payments)).append("\n");
        sb.append("    bankTransactions: ").append(this.toIndentedString(this.bankTransactions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

