/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.finance;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import com.xero.models.finance.TrialBalanceEntry;
import com.xero.models.finance.TrialBalanceMovement;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;

public class TrialBalanceAccount {
    StringUtil util = new StringUtil();
    @JsonProperty(value="accountId")
    private UUID accountId;
    @JsonProperty(value="accountType")
    private String accountType;
    @JsonProperty(value="accountCode")
    private String accountCode;
    @JsonProperty(value="accountClass")
    private String accountClass;
    @JsonProperty(value="status")
    private String status;
    @JsonProperty(value="reportingCode")
    private String reportingCode;
    @JsonProperty(value="accountName")
    private String accountName;
    @JsonProperty(value="balance")
    private TrialBalanceEntry balance;
    @JsonProperty(value="signedBalance")
    private Double signedBalance;
    @JsonProperty(value="accountMovement")
    private TrialBalanceMovement accountMovement;

    public TrialBalanceAccount accountId(UUID accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(value="ID of the account")
    public UUID getAccountId() {
        return this.accountId;
    }

    public void setAccountId(UUID accountId) {
        this.accountId = accountId;
    }

    public TrialBalanceAccount accountType(String accountType) {
        this.accountType = accountType;
        return this;
    }

    @ApiModelProperty(value="The type of the account. See <a href='https://developer.xero.com/documentation/api/types#AccountTypes'>Account Types</a>")
    public String getAccountType() {
        return this.accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public TrialBalanceAccount accountCode(String accountCode) {
        this.accountCode = accountCode;
        return this;
    }

    @ApiModelProperty(value="Customer defined alpha numeric account code e.g 200 or SALES")
    public String getAccountCode() {
        return this.accountCode;
    }

    public void setAccountCode(String accountCode) {
        this.accountCode = accountCode;
    }

    public TrialBalanceAccount accountClass(String accountClass) {
        this.accountClass = accountClass;
        return this;
    }

    @ApiModelProperty(value="The class of the account. See <a href='https://developer.xero.com/documentation/api/types#AccountClassTypes'>Account Class Types</a>")
    public String getAccountClass() {
        return this.accountClass;
    }

    public void setAccountClass(String accountClass) {
        this.accountClass = accountClass;
    }

    public TrialBalanceAccount status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="Accounts with a status of ACTIVE can be updated to ARCHIVED. See <a href='https://developer.xero.com/documentation/api/types#AccountStatusCodes'>Account Status Codes</a>")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public TrialBalanceAccount reportingCode(String reportingCode) {
        this.reportingCode = reportingCode;
        return this;
    }

    @ApiModelProperty(value="Reporting code (Shown if set)")
    public String getReportingCode() {
        return this.reportingCode;
    }

    public void setReportingCode(String reportingCode) {
        this.reportingCode = reportingCode;
    }

    public TrialBalanceAccount accountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    @ApiModelProperty(value="Name of the account")
    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public TrialBalanceAccount balance(TrialBalanceEntry balance) {
        this.balance = balance;
        return this;
    }

    @ApiModelProperty(value="")
    public TrialBalanceEntry getBalance() {
        return this.balance;
    }

    public void setBalance(TrialBalanceEntry balance) {
        this.balance = balance;
    }

    public TrialBalanceAccount signedBalance(Double signedBalance) {
        this.signedBalance = signedBalance;
        return this;
    }

    @ApiModelProperty(value="Value of balance. Expense and Asset accounts code debits as positive. Revenue, Liability, and Equity accounts code debits as negative")
    public Double getSignedBalance() {
        return this.signedBalance;
    }

    public void setSignedBalance(Double signedBalance) {
        this.signedBalance = signedBalance;
    }

    public TrialBalanceAccount accountMovement(TrialBalanceMovement accountMovement) {
        this.accountMovement = accountMovement;
        return this;
    }

    @ApiModelProperty(value="")
    public TrialBalanceMovement getAccountMovement() {
        return this.accountMovement;
    }

    public void setAccountMovement(TrialBalanceMovement accountMovement) {
        this.accountMovement = accountMovement;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrialBalanceAccount trialBalanceAccount = (TrialBalanceAccount)o;
        return Objects.equals(this.accountId, trialBalanceAccount.accountId) && Objects.equals(this.accountType, trialBalanceAccount.accountType) && Objects.equals(this.accountCode, trialBalanceAccount.accountCode) && Objects.equals(this.accountClass, trialBalanceAccount.accountClass) && Objects.equals(this.status, trialBalanceAccount.status) && Objects.equals(this.reportingCode, trialBalanceAccount.reportingCode) && Objects.equals(this.accountName, trialBalanceAccount.accountName) && Objects.equals(this.balance, trialBalanceAccount.balance) && Objects.equals(this.signedBalance, trialBalanceAccount.signedBalance) && Objects.equals(this.accountMovement, trialBalanceAccount.accountMovement);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.accountType, this.accountCode, this.accountClass, this.status, this.reportingCode, this.accountName, this.balance, this.signedBalance, this.accountMovement);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TrialBalanceAccount {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    accountType: ").append(this.toIndentedString(this.accountType)).append("\n");
        sb.append("    accountCode: ").append(this.toIndentedString(this.accountCode)).append("\n");
        sb.append("    accountClass: ").append(this.toIndentedString(this.accountClass)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    reportingCode: ").append(this.toIndentedString(this.reportingCode)).append("\n");
        sb.append("    accountName: ").append(this.toIndentedString(this.accountName)).append("\n");
        sb.append("    balance: ").append(this.toIndentedString(this.balance)).append("\n");
        sb.append("    signedBalance: ").append(this.toIndentedString(this.signedBalance)).append("\n");
        sb.append("    accountMovement: ").append(this.toIndentedString(this.accountMovement)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

