/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrollau;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import com.xero.models.payrollau.AccountType;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;

public class Account {
    StringUtil util = new StringUtil();
    @JsonProperty(value="AccountID")
    private UUID accountID;
    @JsonProperty(value="Type")
    private AccountType type;
    @JsonProperty(value="Code")
    private String code;
    @JsonProperty(value="Name")
    private String name;

    public Account accountID(UUID accountID) {
        this.accountID = accountID;
        return this;
    }

    @ApiModelProperty(example="c56b19ef-75bf-45e8-98a4-e699a96609f7", value="Xero identifier for accounts")
    public UUID getAccountID() {
        return this.accountID;
    }

    public void setAccountID(UUID accountID) {
        this.accountID = accountID;
    }

    public Account type(AccountType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="")
    public AccountType getType() {
        return this.type;
    }

    public void setType(AccountType type) {
        this.type = type;
    }

    public Account code(String code) {
        this.code = code;
        return this;
    }

    @ApiModelProperty(example="420", value="Customer defined account code")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Account name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="General expenses", value="Name of account")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Account account = (Account)o;
        return Objects.equals(this.accountID, account.accountID) && Objects.equals((Object)this.type, (Object)account.type) && Objects.equals(this.code, account.code) && Objects.equals(this.name, account.name);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountID, this.type, this.code, this.name});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Account {\n");
        sb.append("    accountID: ").append(this.toIndentedString(this.accountID)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

