/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrollau;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import com.xero.models.payrollau.PayRunStatus;
import com.xero.models.payrollau.PayslipSummary;
import com.xero.models.payrollau.ValidationError;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.ZoneId;

public class PayRun {
    StringUtil util = new StringUtil();
    @JsonProperty(value="PayrollCalendarID")
    private UUID payrollCalendarID;
    @JsonProperty(value="PayRunID")
    private UUID payRunID;
    @JsonProperty(value="PayRunPeriodStartDate")
    private String payRunPeriodStartDate;
    @JsonProperty(value="PayRunPeriodEndDate")
    private String payRunPeriodEndDate;
    @JsonProperty(value="PayRunStatus")
    private PayRunStatus payRunStatus;
    @JsonProperty(value="PaymentDate")
    private String paymentDate;
    @JsonProperty(value="PayslipMessage")
    private String payslipMessage;
    @JsonProperty(value="UpdatedDateUTC")
    private String updatedDateUTC;
    @JsonProperty(value="Payslips")
    private List<PayslipSummary> payslips = new ArrayList<PayslipSummary>();
    @JsonProperty(value="Wages")
    private Double wages;
    @JsonProperty(value="Deductions")
    private Double deductions;
    @JsonProperty(value="Tax")
    private Double tax;
    @JsonProperty(value="Super")
    private Double _super;
    @JsonProperty(value="Reimbursement")
    private Double reimbursement;
    @JsonProperty(value="NetPay")
    private Double netPay;
    @JsonProperty(value="ValidationErrors")
    private List<ValidationError> validationErrors = new ArrayList<ValidationError>();

    public PayRun payrollCalendarID(UUID payrollCalendarID) {
        this.payrollCalendarID = payrollCalendarID;
        return this;
    }

    @ApiModelProperty(example="bfac31bd-ea62-4fc8-a5e7-7965d9504b15", required=true, value="Xero identifier for pay run")
    public UUID getPayrollCalendarID() {
        return this.payrollCalendarID;
    }

    public void setPayrollCalendarID(UUID payrollCalendarID) {
        this.payrollCalendarID = payrollCalendarID;
    }

    public PayRun payRunID(UUID payRunID) {
        this.payRunID = payRunID;
        return this;
    }

    @ApiModelProperty(example="bba1d10f-63b1-4692-b5c5-a99f869523a4", value="Xero identifier for pay run")
    public UUID getPayRunID() {
        return this.payRunID;
    }

    public void setPayRunID(UUID payRunID) {
        this.payRunID = payRunID;
    }

    public PayRun payRunPeriodStartDate(String payRunPeriodStartDate) {
        this.payRunPeriodStartDate = payRunPeriodStartDate;
        return this;
    }

    @ApiModelProperty(example="/Date(322560000000+0000)/", value="Period Start Date for the PayRun (YYYY-MM-DD)")
    public String getPayRunPeriodStartDate() {
        return this.payRunPeriodStartDate;
    }

    public LocalDate getPayRunPeriodStartDateAsDate() {
        if (this.payRunPeriodStartDate != null) {
            try {
                return this.util.convertStringToDate(this.payRunPeriodStartDate);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setPayRunPeriodStartDate(String payRunPeriodStartDate) {
        this.payRunPeriodStartDate = payRunPeriodStartDate;
    }

    public void setPayRunPeriodStartDate(LocalDate payRunPeriodStartDate) {
        Instant instant = payRunPeriodStartDate.atStartOfDay(ZoneId.of((String)"UTC").normalized()).toInstant();
        long timeInMillis = instant.toEpochMilli();
        this.payRunPeriodStartDate = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
    }

    public PayRun payRunPeriodEndDate(String payRunPeriodEndDate) {
        this.payRunPeriodEndDate = payRunPeriodEndDate;
        return this;
    }

    @ApiModelProperty(example="/Date(322560000000+0000)/", value="Period End Date for the PayRun (YYYY-MM-DD)")
    public String getPayRunPeriodEndDate() {
        return this.payRunPeriodEndDate;
    }

    public LocalDate getPayRunPeriodEndDateAsDate() {
        if (this.payRunPeriodEndDate != null) {
            try {
                return this.util.convertStringToDate(this.payRunPeriodEndDate);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setPayRunPeriodEndDate(String payRunPeriodEndDate) {
        this.payRunPeriodEndDate = payRunPeriodEndDate;
    }

    public void setPayRunPeriodEndDate(LocalDate payRunPeriodEndDate) {
        Instant instant = payRunPeriodEndDate.atStartOfDay(ZoneId.of((String)"UTC").normalized()).toInstant();
        long timeInMillis = instant.toEpochMilli();
        this.payRunPeriodEndDate = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
    }

    public PayRun payRunStatus(PayRunStatus payRunStatus) {
        this.payRunStatus = payRunStatus;
        return this;
    }

    @ApiModelProperty(value="")
    public PayRunStatus getPayRunStatus() {
        return this.payRunStatus;
    }

    public void setPayRunStatus(PayRunStatus payRunStatus) {
        this.payRunStatus = payRunStatus;
    }

    public PayRun paymentDate(String paymentDate) {
        this.paymentDate = paymentDate;
        return this;
    }

    @ApiModelProperty(example="/Date(322560000000+0000)/", value="Payment Date for the PayRun (YYYY-MM-DD)")
    public String getPaymentDate() {
        return this.paymentDate;
    }

    public LocalDate getPaymentDateAsDate() {
        if (this.paymentDate != null) {
            try {
                return this.util.convertStringToDate(this.paymentDate);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setPaymentDate(String paymentDate) {
        this.paymentDate = paymentDate;
    }

    public void setPaymentDate(LocalDate paymentDate) {
        Instant instant = paymentDate.atStartOfDay(ZoneId.of((String)"UTC").normalized()).toInstant();
        long timeInMillis = instant.toEpochMilli();
        this.paymentDate = "/Date(" + Long.toString(timeInMillis) + "+0000)/";
    }

    public PayRun payslipMessage(String payslipMessage) {
        this.payslipMessage = payslipMessage;
        return this;
    }

    @ApiModelProperty(example="Thanks for being awesome", value="Payslip message for the PayRun")
    public String getPayslipMessage() {
        return this.payslipMessage;
    }

    public void setPayslipMessage(String payslipMessage) {
        this.payslipMessage = payslipMessage;
    }

    @ApiModelProperty(example="/Date(1583967733054+0000)/", value="Last modified timestamp")
    public String getUpdatedDateUTC() {
        return this.updatedDateUTC;
    }

    public OffsetDateTime getUpdatedDateUTCAsDate() {
        if (this.updatedDateUTC != null) {
            try {
                return this.util.convertStringToOffsetDateTime(this.updatedDateUTC);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public PayRun payslips(List<PayslipSummary> payslips) {
        this.payslips = payslips;
        return this;
    }

    public PayRun addPayslipsItem(PayslipSummary payslipsItem) {
        if (this.payslips == null) {
            this.payslips = new ArrayList<PayslipSummary>();
        }
        this.payslips.add(payslipsItem);
        return this;
    }

    @ApiModelProperty(value="The payslips in the payrun")
    public List<PayslipSummary> getPayslips() {
        return this.payslips;
    }

    public void setPayslips(List<PayslipSummary> payslips) {
        this.payslips = payslips;
    }

    public PayRun wages(Double wages) {
        this.wages = wages;
        return this;
    }

    @ApiModelProperty(example="1060.5", value="The total Wages for the Payrun")
    public Double getWages() {
        return this.wages;
    }

    public void setWages(Double wages) {
        this.wages = wages;
    }

    public PayRun deductions(Double deductions) {
        this.deductions = deductions;
        return this;
    }

    @ApiModelProperty(example="0.0", value="The total Deductions for the Payrun")
    public Double getDeductions() {
        return this.deductions;
    }

    public void setDeductions(Double deductions) {
        this.deductions = deductions;
    }

    public PayRun tax(Double tax) {
        this.tax = tax;
        return this;
    }

    @ApiModelProperty(example="198.0", value="The total Tax for the Payrun")
    public Double getTax() {
        return this.tax;
    }

    public void setTax(Double tax) {
        this.tax = tax;
    }

    public PayRun _super(Double _super) {
        this._super = _super;
        return this;
    }

    @ApiModelProperty(example="75.6", value="The total Super for the Payrun")
    public Double getSuper() {
        return this._super;
    }

    public void setSuper(Double _super) {
        this._super = _super;
    }

    public PayRun reimbursement(Double reimbursement) {
        this.reimbursement = reimbursement;
        return this;
    }

    @ApiModelProperty(example="0.0", value="The total Reimbursements for the Payrun")
    public Double getReimbursement() {
        return this.reimbursement;
    }

    public void setReimbursement(Double reimbursement) {
        this.reimbursement = reimbursement;
    }

    public PayRun netPay(Double netPay) {
        this.netPay = netPay;
        return this;
    }

    @ApiModelProperty(example="862.5", value="The total NetPay for the Payrun")
    public Double getNetPay() {
        return this.netPay;
    }

    public void setNetPay(Double netPay) {
        this.netPay = netPay;
    }

    public PayRun validationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
        return this;
    }

    public PayRun addValidationErrorsItem(ValidationError validationErrorsItem) {
        if (this.validationErrors == null) {
            this.validationErrors = new ArrayList<ValidationError>();
        }
        this.validationErrors.add(validationErrorsItem);
        return this;
    }

    @ApiModelProperty(value="Displays array of validation error messages from the API")
    public List<ValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    public void setValidationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayRun payRun = (PayRun)o;
        return Objects.equals(this.payrollCalendarID, payRun.payrollCalendarID) && Objects.equals(this.payRunID, payRun.payRunID) && Objects.equals(this.payRunPeriodStartDate, payRun.payRunPeriodStartDate) && Objects.equals(this.payRunPeriodEndDate, payRun.payRunPeriodEndDate) && Objects.equals((Object)this.payRunStatus, (Object)payRun.payRunStatus) && Objects.equals(this.paymentDate, payRun.paymentDate) && Objects.equals(this.payslipMessage, payRun.payslipMessage) && Objects.equals(this.updatedDateUTC, payRun.updatedDateUTC) && Objects.equals(this.payslips, payRun.payslips) && Objects.equals(this.wages, payRun.wages) && Objects.equals(this.deductions, payRun.deductions) && Objects.equals(this.tax, payRun.tax) && Objects.equals(this._super, payRun._super) && Objects.equals(this.reimbursement, payRun.reimbursement) && Objects.equals(this.netPay, payRun.netPay) && Objects.equals(this.validationErrors, payRun.validationErrors);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.payrollCalendarID, this.payRunID, this.payRunPeriodStartDate, this.payRunPeriodEndDate, this.payRunStatus, this.paymentDate, this.payslipMessage, this.updatedDateUTC, this.payslips, this.wages, this.deductions, this.tax, this._super, this.reimbursement, this.netPay, this.validationErrors});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayRun {\n");
        sb.append("    payrollCalendarID: ").append(this.toIndentedString(this.payrollCalendarID)).append("\n");
        sb.append("    payRunID: ").append(this.toIndentedString(this.payRunID)).append("\n");
        sb.append("    payRunPeriodStartDate: ").append(this.toIndentedString(this.payRunPeriodStartDate)).append("\n");
        sb.append("    payRunPeriodEndDate: ").append(this.toIndentedString(this.payRunPeriodEndDate)).append("\n");
        sb.append("    payRunStatus: ").append(this.toIndentedString((Object)this.payRunStatus)).append("\n");
        sb.append("    paymentDate: ").append(this.toIndentedString(this.paymentDate)).append("\n");
        sb.append("    payslipMessage: ").append(this.toIndentedString(this.payslipMessage)).append("\n");
        sb.append("    updatedDateUTC: ").append(this.toIndentedString(this.updatedDateUTC)).append("\n");
        sb.append("    payslips: ").append(this.toIndentedString(this.payslips)).append("\n");
        sb.append("    wages: ").append(this.toIndentedString(this.wages)).append("\n");
        sb.append("    deductions: ").append(this.toIndentedString(this.deductions)).append("\n");
        sb.append("    tax: ").append(this.toIndentedString(this.tax)).append("\n");
        sb.append("    _super: ").append(this.toIndentedString(this._super)).append("\n");
        sb.append("    reimbursement: ").append(this.toIndentedString(this.reimbursement)).append("\n");
        sb.append("    netPay: ").append(this.toIndentedString(this.netPay)).append("\n");
        sb.append("    validationErrors: ").append(this.toIndentedString(this.validationErrors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

