/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrollau;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import com.xero.models.payrollau.DeductionLine;
import com.xero.models.payrollau.EarningsLine;
import com.xero.models.payrollau.LeaveAccrualLine;
import com.xero.models.payrollau.LeaveEarningsLine;
import com.xero.models.payrollau.ReimbursementLine;
import com.xero.models.payrollau.SuperannuationLine;
import com.xero.models.payrollau.TaxLine;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.OffsetDateTime;

public class Payslip {
    StringUtil util = new StringUtil();
    @JsonProperty(value="EmployeeID")
    private UUID employeeID;
    @JsonProperty(value="PayslipID")
    private UUID payslipID;
    @JsonProperty(value="FirstName")
    private String firstName;
    @JsonProperty(value="LastName")
    private String lastName;
    @JsonProperty(value="Wages")
    private Double wages;
    @JsonProperty(value="Deductions")
    private Double deductions;
    @JsonProperty(value="Tax")
    private Double tax;
    @JsonProperty(value="Super")
    private Double _super;
    @JsonProperty(value="Reimbursements")
    private Double reimbursements;
    @JsonProperty(value="NetPay")
    private Double netPay;
    @JsonProperty(value="EarningsLines")
    private List<EarningsLine> earningsLines = new ArrayList<EarningsLine>();
    @JsonProperty(value="LeaveEarningsLines")
    private List<LeaveEarningsLine> leaveEarningsLines = new ArrayList<LeaveEarningsLine>();
    @JsonProperty(value="TimesheetEarningsLines")
    private List<EarningsLine> timesheetEarningsLines = new ArrayList<EarningsLine>();
    @JsonProperty(value="DeductionLines")
    private List<DeductionLine> deductionLines = new ArrayList<DeductionLine>();
    @JsonProperty(value="LeaveAccrualLines")
    private List<LeaveAccrualLine> leaveAccrualLines = new ArrayList<LeaveAccrualLine>();
    @JsonProperty(value="ReimbursementLines")
    private List<ReimbursementLine> reimbursementLines = new ArrayList<ReimbursementLine>();
    @JsonProperty(value="SuperannuationLines")
    private List<SuperannuationLine> superannuationLines = new ArrayList<SuperannuationLine>();
    @JsonProperty(value="TaxLines")
    private List<TaxLine> taxLines = new ArrayList<TaxLine>();
    @JsonProperty(value="UpdatedDateUTC")
    private String updatedDateUTC;

    public Payslip employeeID(UUID employeeID) {
        this.employeeID = employeeID;
        return this;
    }

    @ApiModelProperty(example="4729f087-8eec-49c1-8294-4d11a5a0a37c", value="The Xero identifier for an employee")
    public UUID getEmployeeID() {
        return this.employeeID;
    }

    public void setEmployeeID(UUID employeeID) {
        this.employeeID = employeeID;
    }

    public Payslip payslipID(UUID payslipID) {
        this.payslipID = payslipID;
        return this;
    }

    @ApiModelProperty(example="f3c0874d-7cdd-459a-a95c-d90d51decc42", value="Xero identifier for the payslip")
    public UUID getPayslipID() {
        return this.payslipID;
    }

    public void setPayslipID(UUID payslipID) {
        this.payslipID = payslipID;
    }

    public Payslip firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @ApiModelProperty(example="Karen", value="First name of employee")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public Payslip lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @ApiModelProperty(example="Jones", value="Last name of employee")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public Payslip wages(Double wages) {
        this.wages = wages;
        return this;
    }

    @ApiModelProperty(example="1060.5", value="The Wages for the Payslip")
    public Double getWages() {
        return this.wages;
    }

    public void setWages(Double wages) {
        this.wages = wages;
    }

    public Payslip deductions(Double deductions) {
        this.deductions = deductions;
        return this;
    }

    @ApiModelProperty(example="0.0", value="The Deductions for the Payslip")
    public Double getDeductions() {
        return this.deductions;
    }

    public void setDeductions(Double deductions) {
        this.deductions = deductions;
    }

    public Payslip tax(Double tax) {
        this.tax = tax;
        return this;
    }

    @ApiModelProperty(example="198.0", value="The Tax for the Payslip")
    public Double getTax() {
        return this.tax;
    }

    public void setTax(Double tax) {
        this.tax = tax;
    }

    public Payslip _super(Double _super) {
        this._super = _super;
        return this;
    }

    @ApiModelProperty(example="75.6", value="The Super for the Payslip")
    public Double getSuper() {
        return this._super;
    }

    public void setSuper(Double _super) {
        this._super = _super;
    }

    public Payslip reimbursements(Double reimbursements) {
        this.reimbursements = reimbursements;
        return this;
    }

    @ApiModelProperty(example="0.0", value="The Reimbursements for the Payslip")
    public Double getReimbursements() {
        return this.reimbursements;
    }

    public void setReimbursements(Double reimbursements) {
        this.reimbursements = reimbursements;
    }

    public Payslip netPay(Double netPay) {
        this.netPay = netPay;
        return this;
    }

    @ApiModelProperty(example="862.5", value="The NetPay for the Payslip")
    public Double getNetPay() {
        return this.netPay;
    }

    public void setNetPay(Double netPay) {
        this.netPay = netPay;
    }

    public Payslip earningsLines(List<EarningsLine> earningsLines) {
        this.earningsLines = earningsLines;
        return this;
    }

    public Payslip addEarningsLinesItem(EarningsLine earningsLinesItem) {
        if (this.earningsLines == null) {
            this.earningsLines = new ArrayList<EarningsLine>();
        }
        this.earningsLines.add(earningsLinesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<EarningsLine> getEarningsLines() {
        return this.earningsLines;
    }

    public void setEarningsLines(List<EarningsLine> earningsLines) {
        this.earningsLines = earningsLines;
    }

    public Payslip leaveEarningsLines(List<LeaveEarningsLine> leaveEarningsLines) {
        this.leaveEarningsLines = leaveEarningsLines;
        return this;
    }

    public Payslip addLeaveEarningsLinesItem(LeaveEarningsLine leaveEarningsLinesItem) {
        if (this.leaveEarningsLines == null) {
            this.leaveEarningsLines = new ArrayList<LeaveEarningsLine>();
        }
        this.leaveEarningsLines.add(leaveEarningsLinesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<LeaveEarningsLine> getLeaveEarningsLines() {
        return this.leaveEarningsLines;
    }

    public void setLeaveEarningsLines(List<LeaveEarningsLine> leaveEarningsLines) {
        this.leaveEarningsLines = leaveEarningsLines;
    }

    public Payslip timesheetEarningsLines(List<EarningsLine> timesheetEarningsLines) {
        this.timesheetEarningsLines = timesheetEarningsLines;
        return this;
    }

    public Payslip addTimesheetEarningsLinesItem(EarningsLine timesheetEarningsLinesItem) {
        if (this.timesheetEarningsLines == null) {
            this.timesheetEarningsLines = new ArrayList<EarningsLine>();
        }
        this.timesheetEarningsLines.add(timesheetEarningsLinesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<EarningsLine> getTimesheetEarningsLines() {
        return this.timesheetEarningsLines;
    }

    public void setTimesheetEarningsLines(List<EarningsLine> timesheetEarningsLines) {
        this.timesheetEarningsLines = timesheetEarningsLines;
    }

    public Payslip deductionLines(List<DeductionLine> deductionLines) {
        this.deductionLines = deductionLines;
        return this;
    }

    public Payslip addDeductionLinesItem(DeductionLine deductionLinesItem) {
        if (this.deductionLines == null) {
            this.deductionLines = new ArrayList<DeductionLine>();
        }
        this.deductionLines.add(deductionLinesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<DeductionLine> getDeductionLines() {
        return this.deductionLines;
    }

    public void setDeductionLines(List<DeductionLine> deductionLines) {
        this.deductionLines = deductionLines;
    }

    public Payslip leaveAccrualLines(List<LeaveAccrualLine> leaveAccrualLines) {
        this.leaveAccrualLines = leaveAccrualLines;
        return this;
    }

    public Payslip addLeaveAccrualLinesItem(LeaveAccrualLine leaveAccrualLinesItem) {
        if (this.leaveAccrualLines == null) {
            this.leaveAccrualLines = new ArrayList<LeaveAccrualLine>();
        }
        this.leaveAccrualLines.add(leaveAccrualLinesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<LeaveAccrualLine> getLeaveAccrualLines() {
        return this.leaveAccrualLines;
    }

    public void setLeaveAccrualLines(List<LeaveAccrualLine> leaveAccrualLines) {
        this.leaveAccrualLines = leaveAccrualLines;
    }

    public Payslip reimbursementLines(List<ReimbursementLine> reimbursementLines) {
        this.reimbursementLines = reimbursementLines;
        return this;
    }

    public Payslip addReimbursementLinesItem(ReimbursementLine reimbursementLinesItem) {
        if (this.reimbursementLines == null) {
            this.reimbursementLines = new ArrayList<ReimbursementLine>();
        }
        this.reimbursementLines.add(reimbursementLinesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<ReimbursementLine> getReimbursementLines() {
        return this.reimbursementLines;
    }

    public void setReimbursementLines(List<ReimbursementLine> reimbursementLines) {
        this.reimbursementLines = reimbursementLines;
    }

    public Payslip superannuationLines(List<SuperannuationLine> superannuationLines) {
        this.superannuationLines = superannuationLines;
        return this;
    }

    public Payslip addSuperannuationLinesItem(SuperannuationLine superannuationLinesItem) {
        if (this.superannuationLines == null) {
            this.superannuationLines = new ArrayList<SuperannuationLine>();
        }
        this.superannuationLines.add(superannuationLinesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<SuperannuationLine> getSuperannuationLines() {
        return this.superannuationLines;
    }

    public void setSuperannuationLines(List<SuperannuationLine> superannuationLines) {
        this.superannuationLines = superannuationLines;
    }

    public Payslip taxLines(List<TaxLine> taxLines) {
        this.taxLines = taxLines;
        return this;
    }

    public Payslip addTaxLinesItem(TaxLine taxLinesItem) {
        if (this.taxLines == null) {
            this.taxLines = new ArrayList<TaxLine>();
        }
        this.taxLines.add(taxLinesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<TaxLine> getTaxLines() {
        return this.taxLines;
    }

    public void setTaxLines(List<TaxLine> taxLines) {
        this.taxLines = taxLines;
    }

    @ApiModelProperty(example="/Date(1583967733054+0000)/", value="Last modified timestamp")
    public String getUpdatedDateUTC() {
        return this.updatedDateUTC;
    }

    public OffsetDateTime getUpdatedDateUTCAsDate() {
        if (this.updatedDateUTC != null) {
            try {
                return this.util.convertStringToOffsetDateTime(this.updatedDateUTC);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Payslip payslip = (Payslip)o;
        return Objects.equals(this.employeeID, payslip.employeeID) && Objects.equals(this.payslipID, payslip.payslipID) && Objects.equals(this.firstName, payslip.firstName) && Objects.equals(this.lastName, payslip.lastName) && Objects.equals(this.wages, payslip.wages) && Objects.equals(this.deductions, payslip.deductions) && Objects.equals(this.tax, payslip.tax) && Objects.equals(this._super, payslip._super) && Objects.equals(this.reimbursements, payslip.reimbursements) && Objects.equals(this.netPay, payslip.netPay) && Objects.equals(this.earningsLines, payslip.earningsLines) && Objects.equals(this.leaveEarningsLines, payslip.leaveEarningsLines) && Objects.equals(this.timesheetEarningsLines, payslip.timesheetEarningsLines) && Objects.equals(this.deductionLines, payslip.deductionLines) && Objects.equals(this.leaveAccrualLines, payslip.leaveAccrualLines) && Objects.equals(this.reimbursementLines, payslip.reimbursementLines) && Objects.equals(this.superannuationLines, payslip.superannuationLines) && Objects.equals(this.taxLines, payslip.taxLines) && Objects.equals(this.updatedDateUTC, payslip.updatedDateUTC);
    }

    public int hashCode() {
        return Objects.hash(this.employeeID, this.payslipID, this.firstName, this.lastName, this.wages, this.deductions, this.tax, this._super, this.reimbursements, this.netPay, this.earningsLines, this.leaveEarningsLines, this.timesheetEarningsLines, this.deductionLines, this.leaveAccrualLines, this.reimbursementLines, this.superannuationLines, this.taxLines, this.updatedDateUTC);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Payslip {\n");
        sb.append("    employeeID: ").append(this.toIndentedString(this.employeeID)).append("\n");
        sb.append("    payslipID: ").append(this.toIndentedString(this.payslipID)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    wages: ").append(this.toIndentedString(this.wages)).append("\n");
        sb.append("    deductions: ").append(this.toIndentedString(this.deductions)).append("\n");
        sb.append("    tax: ").append(this.toIndentedString(this.tax)).append("\n");
        sb.append("    _super: ").append(this.toIndentedString(this._super)).append("\n");
        sb.append("    reimbursements: ").append(this.toIndentedString(this.reimbursements)).append("\n");
        sb.append("    netPay: ").append(this.toIndentedString(this.netPay)).append("\n");
        sb.append("    earningsLines: ").append(this.toIndentedString(this.earningsLines)).append("\n");
        sb.append("    leaveEarningsLines: ").append(this.toIndentedString(this.leaveEarningsLines)).append("\n");
        sb.append("    timesheetEarningsLines: ").append(this.toIndentedString(this.timesheetEarningsLines)).append("\n");
        sb.append("    deductionLines: ").append(this.toIndentedString(this.deductionLines)).append("\n");
        sb.append("    leaveAccrualLines: ").append(this.toIndentedString(this.leaveAccrualLines)).append("\n");
        sb.append("    reimbursementLines: ").append(this.toIndentedString(this.reimbursementLines)).append("\n");
        sb.append("    superannuationLines: ").append(this.toIndentedString(this.superannuationLines)).append("\n");
        sb.append("    taxLines: ").append(this.toIndentedString(this.taxLines)).append("\n");
        sb.append("    updatedDateUTC: ").append(this.toIndentedString(this.updatedDateUTC)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

