/*
 * Decompiled with CFR 0.152.
 */
package com.xero.models.payrollau;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xero.api.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import org.threeten.bp.OffsetDateTime;

public class PayslipSummary {
    StringUtil util = new StringUtil();
    @JsonProperty(value="EmployeeID")
    private UUID employeeID;
    @JsonProperty(value="PayslipID")
    private UUID payslipID;
    @JsonProperty(value="FirstName")
    private String firstName;
    @JsonProperty(value="LastName")
    private String lastName;
    @JsonProperty(value="EmployeeGroup")
    private String employeeGroup;
    @JsonProperty(value="Wages")
    private Double wages;
    @JsonProperty(value="Deductions")
    private Double deductions;
    @JsonProperty(value="Tax")
    private Double tax;
    @JsonProperty(value="Super")
    private Double _super;
    @JsonProperty(value="Reimbursements")
    private Double reimbursements;
    @JsonProperty(value="NetPay")
    private Double netPay;
    @JsonProperty(value="UpdatedDateUTC")
    private String updatedDateUTC;

    public PayslipSummary employeeID(UUID employeeID) {
        this.employeeID = employeeID;
        return this;
    }

    @ApiModelProperty(example="4729f087-8eec-49c1-8294-4d11a5a0a37c", value="The Xero identifier for an employee")
    public UUID getEmployeeID() {
        return this.employeeID;
    }

    public void setEmployeeID(UUID employeeID) {
        this.employeeID = employeeID;
    }

    public PayslipSummary payslipID(UUID payslipID) {
        this.payslipID = payslipID;
        return this;
    }

    @ApiModelProperty(example="f3c0874d-7cdd-459a-a95c-d90d51decc42", value="Xero identifier for the payslip")
    public UUID getPayslipID() {
        return this.payslipID;
    }

    public void setPayslipID(UUID payslipID) {
        this.payslipID = payslipID;
    }

    public PayslipSummary firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @ApiModelProperty(example="Karen", value="First name of employee")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public PayslipSummary lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @ApiModelProperty(example="Jones", value="Last name of employee")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public PayslipSummary employeeGroup(String employeeGroup) {
        this.employeeGroup = employeeGroup;
        return this;
    }

    @ApiModelProperty(example="Marketing", value="Employee group name")
    public String getEmployeeGroup() {
        return this.employeeGroup;
    }

    public void setEmployeeGroup(String employeeGroup) {
        this.employeeGroup = employeeGroup;
    }

    public PayslipSummary wages(Double wages) {
        this.wages = wages;
        return this;
    }

    @ApiModelProperty(example="1060.5", value="The Wages for the Payslip")
    public Double getWages() {
        return this.wages;
    }

    public void setWages(Double wages) {
        this.wages = wages;
    }

    public PayslipSummary deductions(Double deductions) {
        this.deductions = deductions;
        return this;
    }

    @ApiModelProperty(example="0.0", value="The Deductions for the Payslip")
    public Double getDeductions() {
        return this.deductions;
    }

    public void setDeductions(Double deductions) {
        this.deductions = deductions;
    }

    public PayslipSummary tax(Double tax) {
        this.tax = tax;
        return this;
    }

    @ApiModelProperty(example="198.0", value="The Tax for the Payslip")
    public Double getTax() {
        return this.tax;
    }

    public void setTax(Double tax) {
        this.tax = tax;
    }

    public PayslipSummary _super(Double _super) {
        this._super = _super;
        return this;
    }

    @ApiModelProperty(example="75.6", value="The Super for the Payslip")
    public Double getSuper() {
        return this._super;
    }

    public void setSuper(Double _super) {
        this._super = _super;
    }

    public PayslipSummary reimbursements(Double reimbursements) {
        this.reimbursements = reimbursements;
        return this;
    }

    @ApiModelProperty(example="0.0", value="The Reimbursements for the Payslip")
    public Double getReimbursements() {
        return this.reimbursements;
    }

    public void setReimbursements(Double reimbursements) {
        this.reimbursements = reimbursements;
    }

    public PayslipSummary netPay(Double netPay) {
        this.netPay = netPay;
        return this;
    }

    @ApiModelProperty(example="862.5", value="The NetPay for the Payslip")
    public Double getNetPay() {
        return this.netPay;
    }

    public void setNetPay(Double netPay) {
        this.netPay = netPay;
    }

    @ApiModelProperty(example="/Date(1583967733054+0000)/", value="Last modified timestamp")
    public String getUpdatedDateUTC() {
        return this.updatedDateUTC;
    }

    public OffsetDateTime getUpdatedDateUTCAsDate() {
        if (this.updatedDateUTC != null) {
            try {
                return this.util.convertStringToOffsetDateTime(this.updatedDateUTC);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayslipSummary payslipSummary = (PayslipSummary)o;
        return Objects.equals(this.employeeID, payslipSummary.employeeID) && Objects.equals(this.payslipID, payslipSummary.payslipID) && Objects.equals(this.firstName, payslipSummary.firstName) && Objects.equals(this.lastName, payslipSummary.lastName) && Objects.equals(this.employeeGroup, payslipSummary.employeeGroup) && Objects.equals(this.wages, payslipSummary.wages) && Objects.equals(this.deductions, payslipSummary.deductions) && Objects.equals(this.tax, payslipSummary.tax) && Objects.equals(this._super, payslipSummary._super) && Objects.equals(this.reimbursements, payslipSummary.reimbursements) && Objects.equals(this.netPay, payslipSummary.netPay) && Objects.equals(this.updatedDateUTC, payslipSummary.updatedDateUTC);
    }

    public int hashCode() {
        return Objects.hash(this.employeeID, this.payslipID, this.firstName, this.lastName, this.employeeGroup, this.wages, this.deductions, this.tax, this._super, this.reimbursements, this.netPay, this.updatedDateUTC);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayslipSummary {\n");
        sb.append("    employeeID: ").append(this.toIndentedString(this.employeeID)).append("\n");
        sb.append("    payslipID: ").append(this.toIndentedString(this.payslipID)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    employeeGroup: ").append(this.toIndentedString(this.employeeGroup)).append("\n");
        sb.append("    wages: ").append(this.toIndentedString(this.wages)).append("\n");
        sb.append("    deductions: ").append(this.toIndentedString(this.deductions)).append("\n");
        sb.append("    tax: ").append(this.toIndentedString(this.tax)).append("\n");
        sb.append("    _super: ").append(this.toIndentedString(this._super)).append("\n");
        sb.append("    reimbursements: ").append(this.toIndentedString(this.reimbursements)).append("\n");
        sb.append("    netPay: ").append(this.toIndentedString(this.netPay)).append("\n");
        sb.append("    updatedDateUTC: ").append(this.toIndentedString(this.updatedDateUTC)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

